http_codes_en: dict[int, tuple[str, str]] = {
    100: ('Continue', 'Request received, please continue'),
    101: (
        'Switching Protocols',
        'Switching to new protocol; obey Upgrade header',
    ),
    200: ('OK', 'Request fulfilled, document follows'),
    201: ('Created', 'Document created, URL follows'),
    202: ('Accepted', 'Request accepted, processing continues off-line'),
    203: ('Non-Authoritative Information', 'Request fulfilled from cache'),
    204: ('No Content', 'Request fulfilled, nothing follows'),
    205: ('Reset Content', 'Clear input form for further input.'),
    206: ('Partial Content', 'Partial content follows.'),
    300: ('Multiple Choices', 'Object has several resources -- see URI list'),
    301: ('Moved Permanently', 'Object moved permanently -- see URI list'),
    302: ('Found', 'Object moved temporarily -- see URI list'),
    303: ('See Other', 'Object moved -- see Method and URL list'),
    304: ('Not Modified', 'Document has not changed since given time'),
    305: (
        'Use Proxy',
        'You must use proxy specified in Location to access this ' 'resource.',
    ),
    307: ('Temporary Redirect', 'Object moved temporarily -- see URI list'),
    400: ('Bad Request', 'Bad request syntax or unsupported method'),
    401: ('Unauthorized', 'No permission -- see authorization schemes'),
    402: ('Payment Required', 'No payment -- see charging schemes'),
    403: ('Forbidden', 'Request forbidden -- authorization will not help'),
    404: ('Not Found', 'Nothing matches the given URI'),
    405: (
        'Method Not Allowed',
        'Specified method is invalid for this server.',
    ),
    406: ('Not Acceptable', 'URI not available in preferred format.'),
    407: (
        'Proxy Authentication Required',
        'You must authenticate with ' 'this proxy before proceeding.',
    ),
    408: ('Request Timeout', 'Request timed out; try again later.'),
    409: ('Conflict', 'Request conflict.'),
    410: ('Gone', 'URI no longer exists and has been permanently removed.'),
    411: ('Length Required', 'Client must specify Content-Length.'),
    412: ('Precondition Failed', 'Precondition in headers is false.'),
    413: ('Request Entity Too Large', 'Entity is too large.'),
    414: ('Request-URI Too Long', 'URI is too long.'),
    415: ('Unsupported Media Type', 'Entity body in unsupported format.'),
    416: ('Requested Range Not Satisfiable', 'Cannot satisfy request range.'),
    417: ('Expectation Failed', 'Expect condition could not be satisfied.'),
    500: ('Internal Server Error', 'Server got itself in trouble'),
    501: ('Not Implemented', 'Server does not support this operation'),
    502: ('Bad Gateway', 'Invalid responses from another server/proxy.'),
    503: (
        'Service Unavailable',
        'The server cannot process the request due to a high load',
    ),
    504: (
        'Gateway Timeout',
        'The gateway server did not receive a timely response',
    ),
    505: ('HTTP Version Not Supported', 'Cannot fulfill request.'),
}

http_codes_nl: dict[int, tuple[str, str]] = {
    100: ('Doorgaan', 'Verzoek ontvangen, gelieve door te gaan'),
    101: (
        'Protocol Wisselen',
        'Overstappen naar nieuw protocol; gehoorzaam de Upgrade-header',
    ),
    200: ('OK', 'Verzoek ingewilligd, document volgt'),
    201: ('Gecreëerd', 'Document aangemaakt, URL volgt'),
    202: (
        'Geaccepteerd',
        'Verzoek geaccepteerd, verwerking gaat offline verder',
    ),
    203: ('Niet-Autoritatieve Informatie', 'Verzoek vervuld vanuit cache'),
    204: ('Geen Inhoud', 'Verzoek vervuld, er volgt niets'),
    205: ('Inhoud Resetten', 'Formulier leegmaken voor verdere invoer.'),
    206: ('Gedeeltelijke Inhoud', 'Gedeeltelijke inhoud volgt.'),
    300: (
        'Meerdere Opties',
        'Object heeft verschillende bronnen -- zie URI-lijst',
    ),
    301: (
        'Permanent Verplaatst',
        'Object permanent verplaatst -- zie URI-lijst',
    ),
    302: ('Gevonden', 'Object tijdelijk verplaatst -- zie URI-lijst'),
    303: ('Zie Andere', 'Object verplaatst -- zie Methode en URL-lijst'),
    304: (
        'Niet Gewijzigd',
        'Document is niet gewijzigd sinds de opgegeven tijd',
    ),
    305: (
        'Gebruik Proxy',
        'Je moet de proxy gebruiken die is opgegeven in Locatie om toegang te krijgen tot deze bron.',
    ),
    307: (
        'Tijdelijke Omleiding',
        'Object tijdelijk verplaatst -- zie URI-lijst',
    ),
    400: (
        'Slecht Verzoek',
        'Slechte verzoeksyntax of niet-ondersteunde methode',
    ),
    401: ('Ongeautoriseerd', 'Geen toestemming -- zie autorisatieschema\'s'),
    402: ('Betaling Vereist', 'Geen betaling -- zie tariefschema\'s'),
    403: ('Verboden', 'Verzoek verboden -- autorisatie zal niet helpen'),
    404: ('Niet Gevonden', 'Niets komt overeen met de opgegeven URI'),
    405: (
        'Methode Niet Toegestaan',
        'Opgegeven methode is ongeldig voor deze server.',
    ),
    406: ('Niet Acceptabel', 'URI niet beschikbaar in het gewenste formaat.'),
    407: (
        'Proxy-Authenticatie Vereist',
        'Je moet je authenticeren bij deze proxy voordat je verder gaat.',
    ),
    408: ('Verzoek Timeout', 'Verzoek is verlopen; probeer later opnieuw.'),
    409: ('Conflict', 'Verzoekconflict.'),
    410: ('Verdwenen', 'URI bestaat niet meer en is permanent verwijderd.'),
    411: ('Lengte Vereist', 'Client moet Content-Length specificeren.'),
    412: ('Voorwaarde Mislukt', 'Voorwaarde in headers is onwaar.'),
    413: ('Verzoek Entiteit Te Groot', 'Entiteit is te groot.'),
    414: ('Verzoek-URI Te Lang', 'URI is te lang.'),
    415: (
        'Niet Ondersteund Mediatype',
        'Entiteitslichaam in een niet-ondersteund formaat.',
    ),
    416: (
        'Gevraagd Bereik Niet Voldaan',
        'Kan het verzoeksbereik niet voldoen.',
    ),
    417: ('Verwachting Mislukt', 'Verwachting kan niet worden vervuld.'),
    500: ('Interne Serverfout', 'Server heeft problemen met zichzelf'),
    501: ('Niet Geïmplementeerd', 'Server ondersteunt deze bewerking niet'),
    502: (
        'Slechte Gateway',
        'Ongeldige reacties van een andere server/proxy.',
    ),
    503: (
        'Service Niet Beschikbaar',
        'De server kan het verzoek niet verwerken vanwege een hoge belasting',
    ),
    504: (
        'Gateway Timeout',
        'De gateway-server heeft geen tijdige reactie ontvangen',
    ),
    505: ('HTTP-Versie Niet Ondersteund', 'Kan het verzoek niet vervullen.'),
}
