"""Contains the TYPE_CONVERSION_MATRIX constant which can be used to determine
if it is allowed to cast an object to a different type.
"""

import datetime
import uuid

TYPE_CONVERSION_MATRIX: dict[type, dict[type, bool]] = {
    str: {
        str: True,
        complex: True,
        int: True,
        float: True,
        bytes: True,
        bytearray: True,
        list: True,
        dict: False,
        set: True,
        tuple: True,
        bool: True,
        datetime.datetime: True,
        datetime.date: True,
        uuid.UUID: True,
    },
    complex: {
        str: True,
        complex: True,
        int: False,
        float: False,
        bytes: False,
        bytearray: False,
        list: False,
        dict: False,
        set: False,
        tuple: False,
        bool: True,
        datetime.datetime: False,
        datetime.date: False,
        uuid.UUID: False,
    },
    int: {
        str: True,
        complex: True,
        int: True,
        float: True,
        bytes: True,
        bytearray: True,
        list: False,
        dict: False,
        set: False,
        tuple: False,
        bool: True,
        datetime.datetime: True,
        datetime.date: True,
        uuid.UUID: False,
    },
    float: {
        str: True,
        complex: True,
        int: True,
        float: True,
        bytes: False,
        bytearray: False,
        list: False,
        dict: False,
        set: False,
        tuple: False,
        bool: True,
        datetime.datetime: False,
        datetime.date: False,
        uuid.UUID: False,
    },
    bytes: {
        str: False,
        complex: False,
        int: False,
        float: False,
        bytes: True,
        bytearray: True,
        list: False,
        dict: False,
        set: False,
        tuple: False,
        bool: True,
        datetime.datetime: False,
        datetime.date: False,
        uuid.UUID: False,
    },
    bytearray: {
        str: False,
        complex: False,
        int: False,
        float: False,
        bytes: True,
        bytearray: True,
        list: False,
        dict: False,
        set: False,
        tuple: False,
        bool: True,
        datetime.datetime: False,
        datetime.date: False,
        uuid.UUID: False,
    },
    list: {
        str: True,
        complex: False,
        int: False,
        float: False,
        bytes: True,
        bytearray: True,
        list: True,
        dict: False,
        set: True,
        tuple: True,
        bool: True,
        datetime.datetime: False,
        datetime.date: False,
        uuid.UUID: False,
    },
    dict: {
        str: True,
        complex: False,
        int: False,
        float: False,
        bytes: False,
        bytearray: False,
        list: True,
        dict: True,
        set: True,
        tuple: True,
        bool: True,
        datetime.datetime: False,
        datetime.date: False,
        uuid.UUID: False,
    },
    set: {
        str: True,
        complex: False,
        int: False,
        float: False,
        bytes: True,
        bytearray: True,
        list: True,
        dict: False,
        set: True,
        tuple: True,
        bool: True,
        datetime.datetime: False,
        datetime.date: False,
        uuid.UUID: False,
    },
    tuple: {
        str: True,
        complex: False,
        int: False,
        float: False,
        bytes: True,
        bytearray: True,
        list: True,
        dict: False,
        set: True,
        tuple: True,
        bool: True,
        datetime.datetime: False,
        datetime.date: False,
        uuid.UUID: False,
    },
    bool: {
        str: True,
        complex: True,
        int: True,
        float: True,
        bytes: True,
        bytearray: True,
        list: False,
        dict: False,
        set: False,
        tuple: False,
        bool: True,
        datetime.datetime: False,
        datetime.date: False,
        uuid.UUID: False,
    },
    datetime.datetime: {
        str: True,
        complex: False,
        int: False,
        float: False,
        bytes: False,
        bytearray: False,
        list: False,
        dict: False,
        set: False,
        tuple: False,
        bool: True,
        datetime.datetime: True,
        datetime.date: True,
        uuid.UUID: False,
    },
    datetime.date: {
        str: True,
        complex: False,
        int: False,
        float: False,
        bytes: False,
        bytearray: False,
        list: False,
        dict: False,
        set: False,
        tuple: False,
        bool: True,
        datetime.datetime: True,
        datetime.date: True,
        uuid.UUID: False,
    },
    uuid.UUID: {
        str: True,
        complex: False,
        int: True,
        float: False,
        bytes: False,
        bytearray: False,
        list: False,
        dict: False,
        set: False,
        tuple: False,
        bool: False,
        datetime.datetime: False,
        datetime.date: False,
        uuid.UUID: False,
    },
}
