VALID_RESOURCES = {
    'SearchItems': [
        'ItemInfo.Title',
        'Offers.Listings.Price',
        'Images.Primary.Medium',
        'ItemInfo.ProductInfo',
        'ItemInfo.Classifications',
        'BrowseNodeInfo.BrowseNodes',
        'BrowseNodeInfo.BrowseNodes.Ancestor',
        'BrowseNodeInfo.BrowseNodes.SalesRank',
        'BrowseNodeInfo.WebsiteSalesRank',
        'CustomerReviews.Count',
        'CustomerReviews.StarRating',
        'Images.Primary.Small',
        'Images.Primary.Large',
        'Images.Variants.Small',
        'Images.Variants.Medium',
        'Images.Variants.Large',
        'ItemInfo.ByLineInfo',
        'ItemInfo.ContentInfo',
        'ItemInfo.ContentRating',
        'ItemInfo.ExternalIds',
        'ItemInfo.Features',
        'ItemInfo.ManufactureInfo',
        'ItemInfo.TechnicalInfo',
        'ItemInfo.TradeInInfo',
        'Offers.Listings.Availability.MaxOrderQuantity',
        'Offers.Listings.Availability.Message',
        'Offers.Listings.Availability.MinOrderQuantity',
        'Offers.Listings.Availability.Type',
        'Offers.Listings.Condition',
        'Offers.Listings.Condition.ConditionNote',
        'Offers.Listings.Condition.SubCondition',
        'Offers.Listings.DeliveryInfo.IsAmazonFulfilled',
        'Offers.Listings.DeliveryInfo.IsFreeShippingEligible',
        'Offers.Listings.DeliveryInfo.IsPrimeEligible',
        'Offers.Listings.DeliveryInfo.ShippingCharges',
        'Offers.Listings.IsBuyBoxWinner',
        'Offers.Listings.LoyaltyPoints.Points',
        'Offers.Listings.MerchantInfo',
        'Offers.Listings.ProgramEligibility.IsPrimeExclusive',
        'Offers.Listings.ProgramEligibility.IsPrimePantry',
        'Offers.Listings.Promotions',
        'Offers.Listings.SavingBasis',
        'Offers.Summaries.HighestPrice',
        'Offers.Summaries.LowestPrice',
        'Offers.Summaries.OfferCount',
        'ParentASIN',
    ],
    'GetItems': [
        'ItemInfo.Title',
        'Offers.Listings.Price',
        'Images.Primary.Medium',
        'ItemInfo.ProductInfo',
        'ItemInfo.Classifications',
        'BrowseNodeInfo.BrowseNodes',
        'BrowseNodeInfo.BrowseNodes.Ancestor',
        'BrowseNodeInfo.BrowseNodes.SalesRank',
        'BrowseNodeInfo.WebsiteSalesRank',
        'CustomerReviews.Count',
        'CustomerReviews.StarRating',
        'Images.Primary.Small',
        'Images.Primary.Large',
        'Images.Variants.Small',
        'Images.Variants.Medium',
        'Images.Variants.Large',
        'ItemInfo.ByLineInfo',
        'ItemInfo.ContentInfo',
        'ItemInfo.ContentRating',
        'ItemInfo.ExternalIds',
        'ItemInfo.Features',
        'ItemInfo.ManufactureInfo',
        'ItemInfo.TechnicalInfo',
        'ItemInfo.TradeInInfo',
        'Offers.Listings.Availability.MaxOrderQuantity',
        'Offers.Listings.Availability.Message',
        'Offers.Listings.Availability.MinOrderQuantity',
        'Offers.Listings.Availability.Type',
        'Offers.Listings.Condition',
        'Offers.Listings.Condition.ConditionNote',
        'Offers.Listings.Condition.SubCondition',
        'Offers.Listings.DeliveryInfo.IsAmazonFulfilled',
        'Offers.Listings.DeliveryInfo.IsFreeShippingEligible',
        'Offers.Listings.DeliveryInfo.IsPrimeEligible',
        'Offers.Listings.DeliveryInfo.ShippingCharges',
        'Offers.Listings.IsBuyBoxWinner',
        'Offers.Listings.LoyaltyPoints.Points',
        'Offers.Listings.MerchantInfo',
        'Offers.Listings.ProgramEligibility.IsPrimeExclusive',
        'Offers.Listings.ProgramEligibility.IsPrimePantry',
        'Offers.Listings.Promotions',
        'Offers.Listings.SavingBasis',
        'Offers.Summaries.HighestPrice',
        'Offers.Summaries.LowestPrice',
        'Offers.Summaries.OfferCount',
        'ParentASIN',
        'RentalOffers.Listings.Availability.MaxOrderQuantity',
        'RentalOffers.Listings.Availability.Message',
        'RentalOffers.Listings.Availability.MinOrderQuantity',
        'RentalOffers.Listings.Availability.Type',
        'RentalOffers.Listings.BasePrice',
        'RentalOffers.Listings.Condition',
        'RentalOffers.Listings.Condition.ConditionNote',
        'RentalOffers.Listings.Condition.SubCondition',
        'RentalOffers.Listings.DeliveryInfo.IsAmazonFulfilled',
        'RentalOffers.Listings.DeliveryInfo.IsFreeShippingEligible',
        'RentalOffers.Listings.DeliveryInfo.IsPrimeEligible',
        'RentalOffers.Listings.DeliveryInfo.ShippingCharges',
        'RentalOffers.Listings.MerchantInfo',
        'OffersV2.Listings.Availability',
        'OffersV2.Listings.Condition',
        'OffersV2.Listings.DealDetails',
        'OffersV2.Listings.IsBuyBoxWinner',
        'OffersV2.Listings.LoyaltyPoints',
        'OffersV2.Listings.MerchantInfo',
        'OffersV2.Listings.Price',
        'OffersV2.Listings.Type',
    ],
    'GetVariations': [
        'VariationSummary.VariationDimension',
        'VariationSummary.Price.HighestPrice',
        'VariationSummary.Price.LowestPrice',
        'ItemInfo.Title',
        'Offers.Listings.Price',
        'Images.Primary.Medium',
        'ItemInfo.ProductInfo',
        'ItemInfo.Classifications',
        'BrowseNodeInfo.BrowseNodes',
        'BrowseNodeInfo.BrowseNodes.Ancestor',
        'BrowseNodeInfo.BrowseNodes.SalesRank',
        'BrowseNodeInfo.WebsiteSalesRank',
        'CustomerReviews.Count',
        'CustomerReviews.StarRating',
        'Images.Primary.Small',
        'Images.Primary.Large',
        'Images.Variants.Small',
        'Images.Variants.Medium',
        'Images.Variants.Large',
        'ItemInfo.ByLineInfo',
        'ItemInfo.ContentInfo',
        'ItemInfo.ContentRating',
        'ItemInfo.ExternalIds',
        'ItemInfo.Features',
        'ItemInfo.ManufactureInfo',
        'ItemInfo.TechnicalInfo',
        'ItemInfo.TradeInInfo',
        'Offers.Listings.Availability.MaxOrderQuantity',
        'Offers.Listings.Availability.Message',
        'Offers.Listings.Availability.MinOrderQuantity',
        'Offers.Listings.Availability.Type',
        'Offers.Listings.Condition',
        'Offers.Listings.Condition.ConditionNote',
        'Offers.Listings.Condition.SubCondition',
        'Offers.Listings.DeliveryInfo.IsAmazonFulfilled',
        'Offers.Listings.DeliveryInfo.IsFreeShippingEligible',
        'Offers.Listings.DeliveryInfo.IsPrimeEligible',
        'Offers.Listings.DeliveryInfo.ShippingCharges',
        'Offers.Listings.IsBuyBoxWinner',
        'Offers.Listings.LoyaltyPoints.Points',
        'Offers.Listings.MerchantInfo',
        'Offers.Listings.ProgramEligibility.IsPrimeExclusive',
        'Offers.Listings.ProgramEligibility.IsPrimePantry',
        'Offers.Listings.Promotions',
        'Offers.Listings.SavingBasis',
        'Offers.Summaries.HighestPrice',
        'Offers.Summaries.LowestPrice',
        'Offers.Summaries.OfferCount',
        'ParentASIN',
        'RentalOffers.Listings.Availability.MaxOrderQuantity',
        'RentalOffers.Listings.Availability.Message',
        'RentalOffers.Listings.Availability.MinOrderQuantity',
        'RentalOffers.Listings.Availability.Type',
        'RentalOffers.Listings.BasePrice',
        'RentalOffers.Listings.Condition',
        'RentalOffers.Listings.Condition.ConditionNote',
        'RentalOffers.Listings.Condition.SubCondition',
        'RentalOffers.Listings.DeliveryInfo.IsAmazonFulfilled',
        'RentalOffers.Listings.DeliveryInfo.IsFreeShippingEligible',
        'RentalOffers.Listings.DeliveryInfo.IsPrimeEligible',
        'RentalOffers.Listings.DeliveryInfo.ShippingCharges',
        'RentalOffers.Listings.MerchantInfo',
    ],
    'GetBrowseNodes': [
        'BrowseNodeInfo.BrowseNodes',
        'BrowseNodeInfo.WebsiteSalesRank',
        'BrowseNodeInfo.BrowseNodes.Ancestor',
        'BrowseNodeInfo.BrowseNodes.SalesRank',
    ],
}

def validate_resources(operation: str, resources: list) -> None:
    """Validate resources for the given operation."""
    valid = VALID_RESOURCES.get(operation, [])
    invalid = [r for r in resources if r not in valid]
    if invalid:
        raise ValueError(f"Invalid resources for {operation}: {invalid}")