#!/usr/bin/env python3

import os
from pathlib import Path

from setuptools import find_namespace_packages, setup

ROOT = Path(__file__).parent


def read_version() -> str:
    """Resolve the package version.

    CI sets AMEIDE_PYTHON_SDK_VERSION (or the temporary AMEIDE_SDK_VERSION alias)
    to inject the release/dev value described in backlog/388-ameideio-sdks-north-star.md.
    For local builds, fall back to the committed placeholder in VERSION.
    """
    override = os.getenv("AMEIDE_PYTHON_SDK_VERSION") or os.getenv("AMEIDE_SDK_VERSION")
    if override:
        return override.strip()

    version_file = ROOT / "VERSION"
    if not version_file.exists():
        raise RuntimeError(f"VERSION file missing at {version_file}")
    return version_file.read_text(encoding="utf-8").strip()


setup(
    name="ameide-sdk-python",
    version=read_version(),
    description="Official AMEIDE Python SDK",
    author="AMEIDE Team",
    author_email="team@ameide.io",
    packages=find_namespace_packages(where="src", include=["ameide_sdk", "ameide_sdk.*"]),
    package_dir={"": "src"},
    include_package_data=True,
    install_requires=[
        "grpcio>=1.65.5",
        "protobuf>=5.28.0",
        "opentelemetry-api>=1.26.0",
    ],
    python_requires=">=3.12",
)
