import datetime

from google.protobuf import timestamp_pb2 as _timestamp_pb2
from google.protobuf import any_pb2 as _any_pb2
from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class ErrorCode(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    ERROR_CODE_UNSPECIFIED: _ClassVar[ErrorCode]
    ERROR_CODE_WORKFLOW_INVALID_STATE: _ClassVar[ErrorCode]
    ERROR_CODE_WORKFLOW_NOT_FOUND: _ClassVar[ErrorCode]
    ERROR_CODE_WORKFLOW_ALREADY_EXISTS: _ClassVar[ErrorCode]
    ERROR_CODE_AGENT_NOT_READY: _ClassVar[ErrorCode]
    ERROR_CODE_AGENT_TIMEOUT: _ClassVar[ErrorCode]
    ERROR_CODE_AGENT_FAILED: _ClassVar[ErrorCode]
    ERROR_CODE_ORCHESTRATION_FAILED: _ClassVar[ErrorCode]
    ERROR_CODE_ORCHESTRATION_TIMEOUT: _ClassVar[ErrorCode]
    ERROR_CODE_TENANT_QUOTA_EXCEEDED: _ClassVar[ErrorCode]
    ERROR_CODE_RESOURCE_LIMIT_EXCEEDED: _ClassVar[ErrorCode]
    ERROR_CODE_VALIDATION_FAILED: _ClassVar[ErrorCode]
    ERROR_CODE_SCHEMA_MISMATCH: _ClassVar[ErrorCode]
    ERROR_CODE_CONSTRAINT_VIOLATION: _ClassVar[ErrorCode]
    ERROR_CODE_DEPENDENCY_FAILED: _ClassVar[ErrorCode]
    ERROR_CODE_CIRCUIT_BREAKER_OPEN: _ClassVar[ErrorCode]
    ERROR_CODE_SERVICE_UNAVAILABLE: _ClassVar[ErrorCode]

class SortOrder(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    SORT_ORDER_UNSPECIFIED: _ClassVar[SortOrder]
    SORT_ORDER_ASC: _ClassVar[SortOrder]
    SORT_ORDER_DESC: _ClassVar[SortOrder]

class HealthStatus(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    HEALTH_STATUS_UNSPECIFIED: _ClassVar[HealthStatus]
    HEALTH_STATUS_HEALTHY: _ClassVar[HealthStatus]
    HEALTH_STATUS_DEGRADED: _ClassVar[HealthStatus]
    HEALTH_STATUS_UNHEALTHY: _ClassVar[HealthStatus]
ERROR_CODE_UNSPECIFIED: ErrorCode
ERROR_CODE_WORKFLOW_INVALID_STATE: ErrorCode
ERROR_CODE_WORKFLOW_NOT_FOUND: ErrorCode
ERROR_CODE_WORKFLOW_ALREADY_EXISTS: ErrorCode
ERROR_CODE_AGENT_NOT_READY: ErrorCode
ERROR_CODE_AGENT_TIMEOUT: ErrorCode
ERROR_CODE_AGENT_FAILED: ErrorCode
ERROR_CODE_ORCHESTRATION_FAILED: ErrorCode
ERROR_CODE_ORCHESTRATION_TIMEOUT: ErrorCode
ERROR_CODE_TENANT_QUOTA_EXCEEDED: ErrorCode
ERROR_CODE_RESOURCE_LIMIT_EXCEEDED: ErrorCode
ERROR_CODE_VALIDATION_FAILED: ErrorCode
ERROR_CODE_SCHEMA_MISMATCH: ErrorCode
ERROR_CODE_CONSTRAINT_VIOLATION: ErrorCode
ERROR_CODE_DEPENDENCY_FAILED: ErrorCode
ERROR_CODE_CIRCUIT_BREAKER_OPEN: ErrorCode
ERROR_CODE_SERVICE_UNAVAILABLE: ErrorCode
SORT_ORDER_UNSPECIFIED: SortOrder
SORT_ORDER_ASC: SortOrder
SORT_ORDER_DESC: SortOrder
HEALTH_STATUS_UNSPECIFIED: HealthStatus
HEALTH_STATUS_HEALTHY: HealthStatus
HEALTH_STATUS_DEGRADED: HealthStatus
HEALTH_STATUS_UNHEALTHY: HealthStatus

class ResourceMetadata(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    UPDATED_AT_FIELD_NUMBER: _ClassVar[int]
    VERSION_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    TAGS_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    SCHEMA_VERSION_FIELD_NUMBER: _ClassVar[int]
    id: str
    created_at: _timestamp_pb2.Timestamp
    updated_at: _timestamp_pb2.Timestamp
    version: str
    metadata: _containers.ScalarMap[str, str]
    tags: _containers.RepeatedScalarFieldContainer[str]
    tenant_id: str
    schema_version: str
    def __init__(self, id: _Optional[str] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., updated_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., version: _Optional[str] = ..., metadata: _Optional[_Mapping[str, str]] = ..., tags: _Optional[_Iterable[str]] = ..., tenant_id: _Optional[str] = ..., schema_version: _Optional[str] = ...) -> None: ...

class DomainError(_message.Message):
    __slots__ = ()
    class ContextEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ERROR_CODE_FIELD_NUMBER: _ClassVar[int]
    MESSAGE_FIELD_NUMBER: _ClassVar[int]
    DETAILS_FIELD_NUMBER: _ClassVar[int]
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REQUEST_ID_FIELD_NUMBER: _ClassVar[int]
    error_code: ErrorCode
    message: str
    details: _any_pb2.Any
    context: _containers.ScalarMap[str, str]
    request_id: str
    def __init__(self, error_code: _Optional[_Union[ErrorCode, str]] = ..., message: _Optional[str] = ..., details: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., context: _Optional[_Mapping[str, str]] = ..., request_id: _Optional[str] = ...) -> None: ...

class PaginationRequest(_message.Message):
    __slots__ = ()
    PAGE_SIZE_FIELD_NUMBER: _ClassVar[int]
    PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    SORT_BY_FIELD_NUMBER: _ClassVar[int]
    SORT_ORDER_FIELD_NUMBER: _ClassVar[int]
    OFFSET_FIELD_NUMBER: _ClassVar[int]
    page_size: int
    page_token: str
    sort_by: str
    sort_order: SortOrder
    offset: int
    def __init__(self, page_size: _Optional[int] = ..., page_token: _Optional[str] = ..., sort_by: _Optional[str] = ..., sort_order: _Optional[_Union[SortOrder, str]] = ..., offset: _Optional[int] = ...) -> None: ...

class PaginationResponse(_message.Message):
    __slots__ = ()
    TOTAL_COUNT_FIELD_NUMBER: _ClassVar[int]
    NEXT_PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    PREV_PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    PAGE_SIZE_FIELD_NUMBER: _ClassVar[int]
    HAS_NEXT_FIELD_NUMBER: _ClassVar[int]
    HAS_PREV_FIELD_NUMBER: _ClassVar[int]
    CURRENT_PAGE_FIELD_NUMBER: _ClassVar[int]
    TOTAL_PAGES_FIELD_NUMBER: _ClassVar[int]
    total_count: int
    next_page_token: str
    prev_page_token: str
    page_size: int
    has_next: bool
    has_prev: bool
    current_page: int
    total_pages: int
    def __init__(self, total_count: _Optional[int] = ..., next_page_token: _Optional[str] = ..., prev_page_token: _Optional[str] = ..., page_size: _Optional[int] = ..., has_next: _Optional[bool] = ..., has_prev: _Optional[bool] = ..., current_page: _Optional[int] = ..., total_pages: _Optional[int] = ...) -> None: ...

class RequestContext(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    REQUEST_ID_FIELD_NUMBER: _ClassVar[int]
    CORRELATION_ID_FIELD_NUMBER: _ClassVar[int]
    USER_ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    SOURCE_SERVICE_FIELD_NUMBER: _ClassVar[int]
    TIMESTAMP_FIELD_NUMBER: _ClassVar[int]
    DEADLINE_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    CLIENT_ID_FIELD_NUMBER: _ClassVar[int]
    request_id: str
    correlation_id: str
    user_id: str
    tenant_id: str
    source_service: str
    timestamp: _timestamp_pb2.Timestamp
    deadline: _timestamp_pb2.Timestamp
    metadata: _containers.ScalarMap[str, str]
    client_id: str
    def __init__(self, request_id: _Optional[str] = ..., correlation_id: _Optional[str] = ..., user_id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., source_service: _Optional[str] = ..., timestamp: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., deadline: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., metadata: _Optional[_Mapping[str, str]] = ..., client_id: _Optional[str] = ...) -> None: ...

class UpdateMask(_message.Message):
    __slots__ = ()
    PATHS_FIELD_NUMBER: _ClassVar[int]
    paths: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, paths: _Optional[_Iterable[str]] = ...) -> None: ...

class BatchRequest(_message.Message):
    __slots__ = ()
    REQUESTS_FIELD_NUMBER: _ClassVar[int]
    STOP_ON_ERROR_FIELD_NUMBER: _ClassVar[int]
    PARALLEL_FIELD_NUMBER: _ClassVar[int]
    requests: _containers.RepeatedCompositeFieldContainer[_any_pb2.Any]
    stop_on_error: bool
    parallel: bool
    def __init__(self, requests: _Optional[_Iterable[_Union[_any_pb2.Any, _Mapping]]] = ..., stop_on_error: _Optional[bool] = ..., parallel: _Optional[bool] = ...) -> None: ...

class BatchResponse(_message.Message):
    __slots__ = ()
    RESPONSES_FIELD_NUMBER: _ClassVar[int]
    SUCCESS_COUNT_FIELD_NUMBER: _ClassVar[int]
    FAILURE_COUNT_FIELD_NUMBER: _ClassVar[int]
    responses: _containers.RepeatedCompositeFieldContainer[BatchResponseItem]
    success_count: int
    failure_count: int
    def __init__(self, responses: _Optional[_Iterable[_Union[BatchResponseItem, _Mapping]]] = ..., success_count: _Optional[int] = ..., failure_count: _Optional[int] = ...) -> None: ...

class BatchResponseItem(_message.Message):
    __slots__ = ()
    SUCCESS_FIELD_NUMBER: _ClassVar[int]
    RESPONSE_FIELD_NUMBER: _ClassVar[int]
    ERROR_FIELD_NUMBER: _ClassVar[int]
    INDEX_FIELD_NUMBER: _ClassVar[int]
    success: bool
    response: _any_pb2.Any
    error: DomainError
    index: int
    def __init__(self, success: _Optional[bool] = ..., response: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., error: _Optional[_Union[DomainError, _Mapping]] = ..., index: _Optional[int] = ...) -> None: ...

class HealthCheckRequest(_message.Message):
    __slots__ = ()
    SERVICE_FIELD_NUMBER: _ClassVar[int]
    service: str
    def __init__(self, service: _Optional[str] = ...) -> None: ...

class HealthCheckResponse(_message.Message):
    __slots__ = ()
    class ServicesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: ServiceHealth
        def __init__(self, key: _Optional[str] = ..., value: _Optional[_Union[ServiceHealth, _Mapping]] = ...) -> None: ...
    STATUS_FIELD_NUMBER: _ClassVar[int]
    SERVICES_FIELD_NUMBER: _ClassVar[int]
    TIMESTAMP_FIELD_NUMBER: _ClassVar[int]
    VERSION_FIELD_NUMBER: _ClassVar[int]
    status: HealthStatus
    services: _containers.MessageMap[str, ServiceHealth]
    timestamp: _timestamp_pb2.Timestamp
    version: str
    def __init__(self, status: _Optional[_Union[HealthStatus, str]] = ..., services: _Optional[_Mapping[str, ServiceHealth]] = ..., timestamp: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., version: _Optional[str] = ...) -> None: ...

class ServiceHealth(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    STATUS_FIELD_NUMBER: _ClassVar[int]
    LAST_CHECK_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ERROR_FIELD_NUMBER: _ClassVar[int]
    status: HealthStatus
    last_check: _timestamp_pb2.Timestamp
    metadata: _containers.ScalarMap[str, str]
    error: str
    def __init__(self, status: _Optional[_Union[HealthStatus, str]] = ..., last_check: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., metadata: _Optional[_Mapping[str, str]] = ..., error: _Optional[str] = ...) -> None: ...

class Event(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    TYPE_FIELD_NUMBER: _ClassVar[int]
    SOURCE_FIELD_NUMBER: _ClassVar[int]
    TIMESTAMP_FIELD_NUMBER: _ClassVar[int]
    DATA_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    SUBJECT_FIELD_NUMBER: _ClassVar[int]
    VERSION_FIELD_NUMBER: _ClassVar[int]
    id: str
    type: str
    source: str
    timestamp: _timestamp_pb2.Timestamp
    data: _any_pb2.Any
    metadata: _containers.ScalarMap[str, str]
    subject: ResourceReference
    version: str
    def __init__(self, id: _Optional[str] = ..., type: _Optional[str] = ..., source: _Optional[str] = ..., timestamp: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., data: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., metadata: _Optional[_Mapping[str, str]] = ..., subject: _Optional[_Union[ResourceReference, _Mapping]] = ..., version: _Optional[str] = ...) -> None: ...

class ResourceReference(_message.Message):
    __slots__ = ()
    TYPE_FIELD_NUMBER: _ClassVar[int]
    ID_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    VERSION_FIELD_NUMBER: _ClassVar[int]
    type: str
    id: str
    name: str
    version: str
    def __init__(self, type: _Optional[str] = ..., id: _Optional[str] = ..., name: _Optional[str] = ..., version: _Optional[str] = ...) -> None: ...

class TimeRange(_message.Message):
    __slots__ = ()
    START_FIELD_NUMBER: _ClassVar[int]
    END_FIELD_NUMBER: _ClassVar[int]
    start: _timestamp_pb2.Timestamp
    end: _timestamp_pb2.Timestamp
    def __init__(self, start: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., end: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ...) -> None: ...

class Location(_message.Message):
    __slots__ = ()
    LATITUDE_FIELD_NUMBER: _ClassVar[int]
    LONGITUDE_FIELD_NUMBER: _ClassVar[int]
    ALTITUDE_FIELD_NUMBER: _ClassVar[int]
    ACCURACY_FIELD_NUMBER: _ClassVar[int]
    ADDRESS_FIELD_NUMBER: _ClassVar[int]
    latitude: float
    longitude: float
    altitude: float
    accuracy: float
    address: str
    def __init__(self, latitude: _Optional[float] = ..., longitude: _Optional[float] = ..., altitude: _Optional[float] = ..., accuracy: _Optional[float] = ..., address: _Optional[str] = ...) -> None: ...

class Money(_message.Message):
    __slots__ = ()
    CURRENCY_CODE_FIELD_NUMBER: _ClassVar[int]
    AMOUNT_FIELD_NUMBER: _ClassVar[int]
    currency_code: str
    amount: int
    def __init__(self, currency_code: _Optional[str] = ..., amount: _Optional[int] = ...) -> None: ...

class Percentage(_message.Message):
    __slots__ = ()
    VALUE_FIELD_NUMBER: _ClassVar[int]
    value: float
    def __init__(self, value: _Optional[float] = ...) -> None: ...

class KeyValue(_message.Message):
    __slots__ = ()
    KEY_FIELD_NUMBER: _ClassVar[int]
    VALUE_FIELD_NUMBER: _ClassVar[int]
    key: str
    value: str
    def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...

class Position(_message.Message):
    __slots__ = ()
    X_FIELD_NUMBER: _ClassVar[int]
    Y_FIELD_NUMBER: _ClassVar[int]
    x: float
    y: float
    def __init__(self, x: _Optional[float] = ..., y: _Optional[float] = ...) -> None: ...
