import datetime

from google.protobuf import timestamp_pb2 as _timestamp_pb2
from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class GovernancePolicyStatus(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    GOVERNANCE_POLICY_STATUS_UNSPECIFIED: _ClassVar[GovernancePolicyStatus]
    GOVERNANCE_POLICY_STATUS_DRAFT: _ClassVar[GovernancePolicyStatus]
    GOVERNANCE_POLICY_STATUS_ACTIVE: _ClassVar[GovernancePolicyStatus]
    GOVERNANCE_POLICY_STATUS_DEPRECATED: _ClassVar[GovernancePolicyStatus]

class RequiredCheckKind(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    REQUIRED_CHECK_KIND_UNSPECIFIED: _ClassVar[RequiredCheckKind]
    REQUIRED_CHECK_KIND_EVIDENCE: _ClassVar[RequiredCheckKind]
    REQUIRED_CHECK_KIND_AUTOMATED: _ClassVar[RequiredCheckKind]
    REQUIRED_CHECK_KIND_MANUAL: _ClassVar[RequiredCheckKind]

class CheckRunStatus(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    CHECK_RUN_STATUS_UNSPECIFIED: _ClassVar[CheckRunStatus]
    CHECK_RUN_STATUS_PENDING: _ClassVar[CheckRunStatus]
    CHECK_RUN_STATUS_PASSING: _ClassVar[CheckRunStatus]
    CHECK_RUN_STATUS_FAILING: _ClassVar[CheckRunStatus]
    CHECK_RUN_STATUS_BLOCKED: _ClassVar[CheckRunStatus]

class GovernanceCaseState(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    GOVERNANCE_CASE_STATE_UNSPECIFIED: _ClassVar[GovernanceCaseState]
    GOVERNANCE_CASE_STATE_OPEN: _ClassVar[GovernanceCaseState]
    GOVERNANCE_CASE_STATE_IN_PROGRESS: _ClassVar[GovernanceCaseState]
    GOVERNANCE_CASE_STATE_CHANGES_REQUESTED: _ClassVar[GovernanceCaseState]
    GOVERNANCE_CASE_STATE_APPROVED: _ClassVar[GovernanceCaseState]
    GOVERNANCE_CASE_STATE_REJECTED: _ClassVar[GovernanceCaseState]
    GOVERNANCE_CASE_STATE_CLOSED: _ClassVar[GovernanceCaseState]
GOVERNANCE_POLICY_STATUS_UNSPECIFIED: GovernancePolicyStatus
GOVERNANCE_POLICY_STATUS_DRAFT: GovernancePolicyStatus
GOVERNANCE_POLICY_STATUS_ACTIVE: GovernancePolicyStatus
GOVERNANCE_POLICY_STATUS_DEPRECATED: GovernancePolicyStatus
REQUIRED_CHECK_KIND_UNSPECIFIED: RequiredCheckKind
REQUIRED_CHECK_KIND_EVIDENCE: RequiredCheckKind
REQUIRED_CHECK_KIND_AUTOMATED: RequiredCheckKind
REQUIRED_CHECK_KIND_MANUAL: RequiredCheckKind
CHECK_RUN_STATUS_UNSPECIFIED: CheckRunStatus
CHECK_RUN_STATUS_PENDING: CheckRunStatus
CHECK_RUN_STATUS_PASSING: CheckRunStatus
CHECK_RUN_STATUS_FAILING: CheckRunStatus
CHECK_RUN_STATUS_BLOCKED: CheckRunStatus
GOVERNANCE_CASE_STATE_UNSPECIFIED: GovernanceCaseState
GOVERNANCE_CASE_STATE_OPEN: GovernanceCaseState
GOVERNANCE_CASE_STATE_IN_PROGRESS: GovernanceCaseState
GOVERNANCE_CASE_STATE_CHANGES_REQUESTED: GovernanceCaseState
GOVERNANCE_CASE_STATE_APPROVED: GovernanceCaseState
GOVERNANCE_CASE_STATE_REJECTED: GovernanceCaseState
GOVERNANCE_CASE_STATE_CLOSED: GovernanceCaseState

class GovernanceOwnerGroup(_message.Message):
    __slots__ = ()
    class CoverageScopeEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    MEMBER_IDS_FIELD_NUMBER: _ClassVar[int]
    COVERAGE_SCOPE_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    name: str
    description: str
    member_ids: _containers.RepeatedScalarFieldContainer[str]
    coverage_scope: _containers.ScalarMap[str, str]
    attributes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., name: _Optional[str] = ..., description: _Optional[str] = ..., member_ids: _Optional[_Iterable[str]] = ..., coverage_scope: _Optional[_Mapping[str, str]] = ..., attributes: _Optional[_Mapping[str, str]] = ...) -> None: ...

class GovernancePolicy(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    SUMMARY_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    EFFECTIVE_FROM_FIELD_NUMBER: _ClassVar[int]
    EFFECTIVE_TO_FIELD_NUMBER: _ClassVar[int]
    REQUIRED_CHECK_IDS_FIELD_NUMBER: _ClassVar[int]
    OWNER_GROUP_IDS_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    name: str
    summary: str
    status: GovernancePolicyStatus
    effective_from: _timestamp_pb2.Timestamp
    effective_to: _timestamp_pb2.Timestamp
    required_check_ids: _containers.RepeatedScalarFieldContainer[str]
    owner_group_ids: _containers.RepeatedScalarFieldContainer[str]
    attributes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., name: _Optional[str] = ..., summary: _Optional[str] = ..., status: _Optional[_Union[GovernancePolicyStatus, str]] = ..., effective_from: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., effective_to: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., required_check_ids: _Optional[_Iterable[str]] = ..., owner_group_ids: _Optional[_Iterable[str]] = ..., attributes: _Optional[_Mapping[str, str]] = ...) -> None: ...

class RequiredCheck(_message.Message):
    __slots__ = ()
    class ConfigurationEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    KIND_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    name: str
    kind: RequiredCheckKind
    description: str
    configuration: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., name: _Optional[str] = ..., kind: _Optional[_Union[RequiredCheckKind, str]] = ..., description: _Optional[str] = ..., configuration: _Optional[_Mapping[str, str]] = ...) -> None: ...

class GovernanceProfile(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    POLICY_IDS_FIELD_NUMBER: _ClassVar[int]
    DEFAULT_OWNER_GROUP_IDS_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    name: str
    description: str
    policy_ids: _containers.RepeatedScalarFieldContainer[str]
    default_owner_group_ids: _containers.RepeatedScalarFieldContainer[str]
    attributes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., name: _Optional[str] = ..., description: _Optional[str] = ..., policy_ids: _Optional[_Iterable[str]] = ..., default_owner_group_ids: _Optional[_Iterable[str]] = ..., attributes: _Optional[_Mapping[str, str]] = ...) -> None: ...

class GovernanceCase(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    GRAPH_ID_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    SUBMITTER_ID_FIELD_NUMBER: _ClassVar[int]
    OWNER_GROUP_ID_FIELD_NUMBER: _ClassVar[int]
    STATE_FIELD_NUMBER: _ClassVar[int]
    OPENED_AT_FIELD_NUMBER: _ClassVar[int]
    CLOSED_AT_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    graph_id: str
    element_id: str
    submitter_id: str
    owner_group_id: str
    state: GovernanceCaseState
    opened_at: _timestamp_pb2.Timestamp
    closed_at: _timestamp_pb2.Timestamp
    attributes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., graph_id: _Optional[str] = ..., element_id: _Optional[str] = ..., submitter_id: _Optional[str] = ..., owner_group_id: _Optional[str] = ..., state: _Optional[_Union[GovernanceCaseState, str]] = ..., opened_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., closed_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., attributes: _Optional[_Mapping[str, str]] = ...) -> None: ...

class CheckRun(_message.Message):
    __slots__ = ()
    class EvidenceEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    class AnnotationsEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    REQUIRED_CHECK_ID_FIELD_NUMBER: _ClassVar[int]
    GOVERNANCE_CASE_ID_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    STARTED_AT_FIELD_NUMBER: _ClassVar[int]
    COMPLETED_AT_FIELD_NUMBER: _ClassVar[int]
    EVIDENCE_FIELD_NUMBER: _ClassVar[int]
    ANNOTATIONS_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    required_check_id: str
    governance_case_id: str
    status: CheckRunStatus
    started_at: _timestamp_pb2.Timestamp
    completed_at: _timestamp_pb2.Timestamp
    evidence: _containers.ScalarMap[str, str]
    annotations: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., required_check_id: _Optional[str] = ..., governance_case_id: _Optional[str] = ..., status: _Optional[_Union[CheckRunStatus, str]] = ..., started_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., completed_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., evidence: _Optional[_Mapping[str, str]] = ..., annotations: _Optional[_Mapping[str, str]] = ...) -> None: ...

class GovernanceAlert(_message.Message):
    __slots__ = ()
    class ResolutionMetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_ID_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    ALERT_TYPE_FIELD_NUMBER: _ClassVar[int]
    SEVERITY_FIELD_NUMBER: _ClassVar[int]
    MESSAGE_FIELD_NUMBER: _ClassVar[int]
    TRIGGERED_AT_FIELD_NUMBER: _ClassVar[int]
    ACKNOWLEDGED_AT_FIELD_NUMBER: _ClassVar[int]
    RESOLVED_AT_FIELD_NUMBER: _ClassVar[int]
    RESOLUTION_METADATA_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    transformation_id: str
    element_id: str
    alert_type: str
    severity: str
    message: str
    triggered_at: _timestamp_pb2.Timestamp
    acknowledged_at: _timestamp_pb2.Timestamp
    resolved_at: _timestamp_pb2.Timestamp
    resolution_metadata: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., transformation_id: _Optional[str] = ..., element_id: _Optional[str] = ..., alert_type: _Optional[str] = ..., severity: _Optional[str] = ..., message: _Optional[str] = ..., triggered_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., acknowledged_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., resolved_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., resolution_metadata: _Optional[_Mapping[str, str]] = ...) -> None: ...
