import datetime

from google.protobuf import any_pb2 as _any_pb2
from google.protobuf import timestamp_pb2 as _timestamp_pb2
from buf.validate import validate_pb2 as _validate_pb2
from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class ElementKind(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    ELEMENT_KIND_UNSPECIFIED: _ClassVar[ElementKind]
    ELEMENT_KIND_NODE: _ClassVar[ElementKind]
    ELEMENT_KIND_RELATIONSHIP: _ClassVar[ElementKind]
    ELEMENT_KIND_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_BINARY: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_MD: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_PDF: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_DOCX: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_XLSX: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_PPTX: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_TXT: _ClassVar[ElementKind]
    ELEMENT_KIND_ARCHIMATE_ELEMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_ARCHIMATE_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_BPMN_ELEMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_BPMN_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_C4_ELEMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_C4_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_UML_ELEMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_UML_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_DMN_ELEMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_DMN_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_FOLDER: _ClassVar[ElementKind]
ELEMENT_KIND_UNSPECIFIED: ElementKind
ELEMENT_KIND_NODE: ElementKind
ELEMENT_KIND_RELATIONSHIP: ElementKind
ELEMENT_KIND_VIEW: ElementKind
ELEMENT_KIND_DOCUMENT: ElementKind
ELEMENT_KIND_BINARY: ElementKind
ELEMENT_KIND_DOCUMENT_MD: ElementKind
ELEMENT_KIND_DOCUMENT_PDF: ElementKind
ELEMENT_KIND_DOCUMENT_DOCX: ElementKind
ELEMENT_KIND_DOCUMENT_XLSX: ElementKind
ELEMENT_KIND_DOCUMENT_PPTX: ElementKind
ELEMENT_KIND_DOCUMENT_TXT: ElementKind
ELEMENT_KIND_ARCHIMATE_ELEMENT: ElementKind
ELEMENT_KIND_ARCHIMATE_VIEW: ElementKind
ELEMENT_KIND_BPMN_ELEMENT: ElementKind
ELEMENT_KIND_BPMN_VIEW: ElementKind
ELEMENT_KIND_C4_ELEMENT: ElementKind
ELEMENT_KIND_C4_VIEW: ElementKind
ELEMENT_KIND_UML_ELEMENT: ElementKind
ELEMENT_KIND_UML_VIEW: ElementKind
ELEMENT_KIND_DMN_ELEMENT: ElementKind
ELEMENT_KIND_DMN_VIEW: ElementKind
ELEMENT_KIND_FOLDER: ElementKind

class Element(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    KIND_FIELD_NUMBER: _ClassVar[int]
    TYPE_KEY_FIELD_NUMBER: _ClassVar[int]
    BODY_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    TAGS_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_FIELD_NUMBER: _ClassVar[int]
    UPDATED_AT_FIELD_NUMBER: _ClassVar[int]
    UPDATED_BY_FIELD_NUMBER: _ClassVar[int]
    TITLE_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    LIFECYCLE_STATE_FIELD_NUMBER: _ClassVar[int]
    HEAD_VERSION_ID_FIELD_NUMBER: _ClassVar[int]
    PUBLISHED_VERSION_ID_FIELD_NUMBER: _ClassVar[int]
    id: str
    tenant_id: str
    organization_id: str
    repository_id: str
    kind: ElementKind
    type_key: str
    body: _any_pb2.Any
    metadata: _containers.ScalarMap[str, str]
    tags: _containers.RepeatedScalarFieldContainer[str]
    created_at: _timestamp_pb2.Timestamp
    created_by: str
    updated_at: _timestamp_pb2.Timestamp
    updated_by: str
    title: str
    description: str
    lifecycle_state: str
    head_version_id: str
    published_version_id: str
    def __init__(self, id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., kind: _Optional[_Union[ElementKind, str]] = ..., type_key: _Optional[str] = ..., body: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., metadata: _Optional[_Mapping[str, str]] = ..., tags: _Optional[_Iterable[str]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_by: _Optional[str] = ..., updated_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., updated_by: _Optional[str] = ..., title: _Optional[str] = ..., description: _Optional[str] = ..., lifecycle_state: _Optional[str] = ..., head_version_id: _Optional[str] = ..., published_version_id: _Optional[str] = ...) -> None: ...

class ElementVersion(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    VERSION_NUMBER_FIELD_NUMBER: _ClassVar[int]
    BODY_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_FIELD_NUMBER: _ClassVar[int]
    id: str
    element_id: str
    version_number: int
    body: _any_pb2.Any
    metadata: _containers.ScalarMap[str, str]
    created_at: _timestamp_pb2.Timestamp
    created_by: str
    def __init__(self, id: _Optional[str] = ..., element_id: _Optional[str] = ..., version_number: _Optional[int] = ..., body: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., metadata: _Optional[_Mapping[str, str]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_by: _Optional[str] = ...) -> None: ...

class ElementRelationship(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    TYPE_KEY_FIELD_NUMBER: _ClassVar[int]
    SOURCE_ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    TARGET_ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    BODY_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_FIELD_NUMBER: _ClassVar[int]
    UPDATED_AT_FIELD_NUMBER: _ClassVar[int]
    UPDATED_BY_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_KIND_FIELD_NUMBER: _ClassVar[int]
    POSITION_FIELD_NUMBER: _ClassVar[int]
    ROLE_FIELD_NUMBER: _ClassVar[int]
    id: str
    tenant_id: str
    organization_id: str
    repository_id: str
    type_key: str
    source_element_id: str
    target_element_id: str
    body: _any_pb2.Any
    metadata: _containers.ScalarMap[str, str]
    created_at: _timestamp_pb2.Timestamp
    created_by: str
    updated_at: _timestamp_pb2.Timestamp
    updated_by: str
    relationship_kind: str
    position: int
    role: str
    def __init__(self, id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., type_key: _Optional[str] = ..., source_element_id: _Optional[str] = ..., target_element_id: _Optional[str] = ..., body: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., metadata: _Optional[_Mapping[str, str]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_by: _Optional[str] = ..., updated_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., updated_by: _Optional[str] = ..., relationship_kind: _Optional[str] = ..., position: _Optional[int] = ..., role: _Optional[str] = ...) -> None: ...

class RelationshipVersion(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_ID_FIELD_NUMBER: _ClassVar[int]
    VERSION_NUMBER_FIELD_NUMBER: _ClassVar[int]
    SOURCE_ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    TARGET_ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    BODY_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_FIELD_NUMBER: _ClassVar[int]
    id: str
    relationship_id: str
    version_number: int
    source_element_id: str
    target_element_id: str
    body: _any_pb2.Any
    metadata: _containers.ScalarMap[str, str]
    created_at: _timestamp_pb2.Timestamp
    created_by: str
    def __init__(self, id: _Optional[str] = ..., relationship_id: _Optional[str] = ..., version_number: _Optional[int] = ..., source_element_id: _Optional[str] = ..., target_element_id: _Optional[str] = ..., body: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., metadata: _Optional[_Mapping[str, str]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_by: _Optional[str] = ...) -> None: ...

class Attachment(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    STORAGE_URI_FIELD_NUMBER: _ClassVar[int]
    HASH_FIELD_NUMBER: _ClassVar[int]
    MEDIA_TYPE_FIELD_NUMBER: _ClassVar[int]
    SIZE_BYTES_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_FIELD_NUMBER: _ClassVar[int]
    id: str
    element_id: str
    storage_uri: str
    hash: str
    media_type: str
    size_bytes: int
    metadata: _containers.ScalarMap[str, str]
    created_at: _timestamp_pb2.Timestamp
    created_by: str
    def __init__(self, id: _Optional[str] = ..., element_id: _Optional[str] = ..., storage_uri: _Optional[str] = ..., hash: _Optional[str] = ..., media_type: _Optional[str] = ..., size_bytes: _Optional[int] = ..., metadata: _Optional[_Mapping[str, str]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_by: _Optional[str] = ...) -> None: ...

class Repository(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    KEY_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    TEMPLATE_ID_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    CONFIG_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    key: str
    name: str
    description: str
    template_id: str
    attributes: _containers.ScalarMap[str, str]
    config: RepositoryConfig
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., key: _Optional[str] = ..., name: _Optional[str] = ..., description: _Optional[str] = ..., template_id: _Optional[str] = ..., attributes: _Optional[_Mapping[str, str]] = ..., config: _Optional[_Union[RepositoryConfig, _Mapping]] = ...) -> None: ...

class RepositoryConfig(_message.Message):
    __slots__ = ()
    class UiHintsEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    NODE_TYPES_FIELD_NUMBER: _ClassVar[int]
    DEFAULT_TREE_FIELD_NUMBER: _ClassVar[int]
    ALLOW_CUSTOM_NODES_FIELD_NUMBER: _ClassVar[int]
    UI_HINTS_FIELD_NUMBER: _ClassVar[int]
    node_types: _containers.RepeatedCompositeFieldContainer[NodeType]
    default_tree: _containers.RepeatedCompositeFieldContainer[NodeDefinition]
    allow_custom_nodes: bool
    ui_hints: _containers.ScalarMap[str, str]
    def __init__(self, node_types: _Optional[_Iterable[_Union[NodeType, _Mapping]]] = ..., default_tree: _Optional[_Iterable[_Union[NodeDefinition, _Mapping]]] = ..., allow_custom_nodes: _Optional[bool] = ..., ui_hints: _Optional[_Mapping[str, str]] = ...) -> None: ...

class NodeType(_message.Message):
    __slots__ = ()
    class UiEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    KEY_FIELD_NUMBER: _ClassVar[int]
    LABEL_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    ALLOWED_CHILD_TYPES_FIELD_NUMBER: _ClassVar[int]
    ALLOWED_ELEMENT_KINDS_FIELD_NUMBER: _ClassVar[int]
    VIRTUAL_FIELD_NUMBER: _ClassVar[int]
    UI_FIELD_NUMBER: _ClassVar[int]
    key: str
    label: str
    description: str
    allowed_child_types: _containers.RepeatedScalarFieldContainer[str]
    allowed_element_kinds: _containers.RepeatedScalarFieldContainer[str]
    virtual: bool
    ui: _containers.ScalarMap[str, str]
    def __init__(self, key: _Optional[str] = ..., label: _Optional[str] = ..., description: _Optional[str] = ..., allowed_child_types: _Optional[_Iterable[str]] = ..., allowed_element_kinds: _Optional[_Iterable[str]] = ..., virtual: _Optional[bool] = ..., ui: _Optional[_Mapping[str, str]] = ...) -> None: ...

class Node(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    PARENT_ID_FIELD_NUMBER: _ClassVar[int]
    TYPE_KEY_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    SLUG_FIELD_NUMBER: _ClassVar[int]
    PATH_FIELD_NUMBER: _ClassVar[int]
    ORDER_FIELD_NUMBER: _ClassVar[int]
    IS_VIRTUAL_FIELD_NUMBER: _ClassVar[int]
    FILTER_EXPRESSION_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    repository_id: str
    parent_id: str
    type_key: str
    name: str
    slug: str
    path: str
    order: int
    is_virtual: bool
    filter_expression: str
    attributes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., parent_id: _Optional[str] = ..., type_key: _Optional[str] = ..., name: _Optional[str] = ..., slug: _Optional[str] = ..., path: _Optional[str] = ..., order: _Optional[int] = ..., is_virtual: _Optional[bool] = ..., filter_expression: _Optional[str] = ..., attributes: _Optional[_Mapping[str, str]] = ...) -> None: ...

class Assignment(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    NODE_ID_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    PINNED_VERSION_ID_FIELD_NUMBER: _ClassVar[int]
    ROLE_FIELD_NUMBER: _ClassVar[int]
    ORDER_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    repository_id: str
    node_id: str
    element_id: str
    pinned_version_id: str
    role: str
    order: int
    attributes: _containers.ScalarMap[str, str]
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., node_id: _Optional[str] = ..., element_id: _Optional[str] = ..., pinned_version_id: _Optional[str] = ..., role: _Optional[str] = ..., order: _Optional[int] = ..., attributes: _Optional[_Mapping[str, str]] = ...) -> None: ...

class NodeDefinition(_message.Message):
    __slots__ = ()
    class AttributesEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    TYPE_KEY_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    SLUG_FIELD_NUMBER: _ClassVar[int]
    ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    CHILDREN_FIELD_NUMBER: _ClassVar[int]
    type_key: str
    name: str
    slug: str
    attributes: _containers.ScalarMap[str, str]
    children: _containers.RepeatedCompositeFieldContainer[NodeDefinition]
    def __init__(self, type_key: _Optional[str] = ..., name: _Optional[str] = ..., slug: _Optional[str] = ..., attributes: _Optional[_Mapping[str, str]] = ..., children: _Optional[_Iterable[_Union[NodeDefinition, _Mapping]]] = ...) -> None: ...

class RepositoryStats(_message.Message):
    __slots__ = ()
    class ElementsByKindEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: int
        def __init__(self, key: _Optional[str] = ..., value: _Optional[int] = ...) -> None: ...
    class ElementsByPhaseEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: int
        def __init__(self, key: _Optional[str] = ..., value: _Optional[int] = ...) -> None: ...
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    NODE_COUNT_FIELD_NUMBER: _ClassVar[int]
    ASSIGNMENT_COUNT_FIELD_NUMBER: _ClassVar[int]
    ELEMENTS_BY_KIND_FIELD_NUMBER: _ClassVar[int]
    ELEMENTS_BY_PHASE_FIELD_NUMBER: _ClassVar[int]
    repository_id: str
    node_count: int
    assignment_count: int
    elements_by_kind: _containers.ScalarMap[str, int]
    elements_by_phase: _containers.ScalarMap[str, int]
    def __init__(self, repository_id: _Optional[str] = ..., node_count: _Optional[int] = ..., assignment_count: _Optional[int] = ..., elements_by_kind: _Optional[_Mapping[str, int]] = ..., elements_by_phase: _Optional[_Mapping[str, int]] = ...) -> None: ...
