from google.protobuf import field_mask_pb2 as _field_mask_pb2
from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from ameide_core_proto.initiative.v1 import initiative_pb2 as _initiative_pb2
from ameide_core_proto.graph.v1 import graph_pb2 as _graph_pb2
from ameide_core_proto.metamodel.v1 import metamodel_pb2 as _metamodel_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class ListInitiativesRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    tenant_id: str
    repository_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., tenant_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListInitiativesResponse(_message.Message):
    __slots__ = ()
    INITIATIVES_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    initiatives: _containers.RepeatedCompositeFieldContainer[_initiative_pb2.Initiative]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, initiatives: _Optional[_Iterable[_Union[_initiative_pb2.Initiative, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetInitiativeRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    initiative_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., initiative_id: _Optional[str] = ...) -> None: ...

class GetInitiativeResponse(_message.Message):
    __slots__ = ()
    INITIATIVE_FIELD_NUMBER: _ClassVar[int]
    initiative: _initiative_pb2.Initiative
    def __init__(self, initiative: _Optional[_Union[_initiative_pb2.Initiative, _Mapping]] = ...) -> None: ...

class CreateInitiativeRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    initiative: _initiative_pb2.Initiative
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., initiative: _Optional[_Union[_initiative_pb2.Initiative, _Mapping]] = ...) -> None: ...

class CreateInitiativeResponse(_message.Message):
    __slots__ = ()
    INITIATIVE_FIELD_NUMBER: _ClassVar[int]
    initiative: _initiative_pb2.Initiative
    def __init__(self, initiative: _Optional[_Union[_initiative_pb2.Initiative, _Mapping]] = ...) -> None: ...

class UpdateInitiativeRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    initiative: _initiative_pb2.Initiative
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., initiative: _Optional[_Union[_initiative_pb2.Initiative, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateInitiativeResponse(_message.Message):
    __slots__ = ()
    INITIATIVE_FIELD_NUMBER: _ClassVar[int]
    initiative: _initiative_pb2.Initiative
    def __init__(self, initiative: _Optional[_Union[_initiative_pb2.Initiative, _Mapping]] = ...) -> None: ...

class GetInitiativeWorkspaceRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    initiative_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., initiative_id: _Optional[str] = ...) -> None: ...

class GetInitiativeWorkspaceResponse(_message.Message):
    __slots__ = ()
    NODES_FIELD_NUMBER: _ClassVar[int]
    ELEMENTS_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_FIELD_NUMBER: _ClassVar[int]
    nodes: _containers.RepeatedCompositeFieldContainer[_initiative_pb2.InitiativeWorkspaceNode]
    elements: _containers.RepeatedCompositeFieldContainer[_metamodel_pb2.Element]
    repository: _graph_pb2.Repository
    def __init__(self, nodes: _Optional[_Iterable[_Union[_initiative_pb2.InitiativeWorkspaceNode, _Mapping]]] = ..., elements: _Optional[_Iterable[_Union[_metamodel_pb2.Element, _Mapping]]] = ..., repository: _Optional[_Union[_graph_pb2.Repository, _Mapping]] = ...) -> None: ...

class ListInitiativeElementsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_ID_FIELD_NUMBER: _ClassVar[int]
    WORKSPACE_NODE_IDS_FIELD_NUMBER: _ClassVar[int]
    SEARCH_QUERY_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    initiative_id: str
    workspace_node_ids: _containers.RepeatedScalarFieldContainer[str]
    search_query: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., initiative_id: _Optional[str] = ..., workspace_node_ids: _Optional[_Iterable[str]] = ..., search_query: _Optional[str] = ...) -> None: ...

class ListInitiativeElementsResponse(_message.Message):
    __slots__ = ()
    ELEMENTS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    elements: _containers.RepeatedCompositeFieldContainer[_metamodel_pb2.Element]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, elements: _Optional[_Iterable[_Union[_metamodel_pb2.Element, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class ListInitiativeMilestonesRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    initiative_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., initiative_id: _Optional[str] = ...) -> None: ...

class ListInitiativeMilestonesResponse(_message.Message):
    __slots__ = ()
    MILESTONES_FIELD_NUMBER: _ClassVar[int]
    milestones: _containers.RepeatedCompositeFieldContainer[_initiative_pb2.InitiativeMilestone]
    def __init__(self, milestones: _Optional[_Iterable[_Union[_initiative_pb2.InitiativeMilestone, _Mapping]]] = ...) -> None: ...

class ListInitiativeMetricSnapshotsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    initiative_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., initiative_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListInitiativeMetricSnapshotsResponse(_message.Message):
    __slots__ = ()
    SNAPSHOTS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    snapshots: _containers.RepeatedCompositeFieldContainer[_initiative_pb2.InitiativeMetricSnapshot]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, snapshots: _Optional[_Iterable[_Union[_initiative_pb2.InitiativeMetricSnapshot, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class ListInitiativeAlertsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    INITIATIVE_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    initiative_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., initiative_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListInitiativeAlertsResponse(_message.Message):
    __slots__ = ()
    ALERTS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    alerts: _containers.RepeatedCompositeFieldContainer[_initiative_pb2.InitiativeAlert]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, alerts: _Optional[_Iterable[_Union[_initiative_pb2.InitiativeAlert, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...
