import datetime

from google.protobuf import any_pb2 as _any_pb2
from google.protobuf import field_mask_pb2 as _field_mask_pb2
from google.protobuf import timestamp_pb2 as _timestamp_pb2
from google.protobuf import empty_pb2 as _empty_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class ElementKind(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    ELEMENT_KIND_UNSPECIFIED: _ClassVar[ElementKind]
    ELEMENT_KIND_NODE: _ClassVar[ElementKind]
    ELEMENT_KIND_RELATIONSHIP: _ClassVar[ElementKind]
    ELEMENT_KIND_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_BINARY: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_MD: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_PDF: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_DOCX: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_XLSX: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_PPTX: _ClassVar[ElementKind]
    ELEMENT_KIND_DOCUMENT_TXT: _ClassVar[ElementKind]
    ELEMENT_KIND_ARCHIMATE_ELEMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_ARCHIMATE_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_BPMN_ELEMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_BPMN_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_C4_ELEMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_C4_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_UML_ELEMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_UML_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_DMN_ELEMENT: _ClassVar[ElementKind]
    ELEMENT_KIND_DMN_VIEW: _ClassVar[ElementKind]
    ELEMENT_KIND_FOLDER: _ClassVar[ElementKind]
ELEMENT_KIND_UNSPECIFIED: ElementKind
ELEMENT_KIND_NODE: ElementKind
ELEMENT_KIND_RELATIONSHIP: ElementKind
ELEMENT_KIND_VIEW: ElementKind
ELEMENT_KIND_DOCUMENT: ElementKind
ELEMENT_KIND_BINARY: ElementKind
ELEMENT_KIND_DOCUMENT_MD: ElementKind
ELEMENT_KIND_DOCUMENT_PDF: ElementKind
ELEMENT_KIND_DOCUMENT_DOCX: ElementKind
ELEMENT_KIND_DOCUMENT_XLSX: ElementKind
ELEMENT_KIND_DOCUMENT_PPTX: ElementKind
ELEMENT_KIND_DOCUMENT_TXT: ElementKind
ELEMENT_KIND_ARCHIMATE_ELEMENT: ElementKind
ELEMENT_KIND_ARCHIMATE_VIEW: ElementKind
ELEMENT_KIND_BPMN_ELEMENT: ElementKind
ELEMENT_KIND_BPMN_VIEW: ElementKind
ELEMENT_KIND_C4_ELEMENT: ElementKind
ELEMENT_KIND_C4_VIEW: ElementKind
ELEMENT_KIND_UML_ELEMENT: ElementKind
ELEMENT_KIND_UML_VIEW: ElementKind
ELEMENT_KIND_DMN_ELEMENT: ElementKind
ELEMENT_KIND_DMN_VIEW: ElementKind
ELEMENT_KIND_FOLDER: ElementKind

class Element(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    KIND_FIELD_NUMBER: _ClassVar[int]
    TYPE_KEY_FIELD_NUMBER: _ClassVar[int]
    BODY_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    TAGS_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_FIELD_NUMBER: _ClassVar[int]
    UPDATED_AT_FIELD_NUMBER: _ClassVar[int]
    UPDATED_BY_FIELD_NUMBER: _ClassVar[int]
    TITLE_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    LIFECYCLE_STATE_FIELD_NUMBER: _ClassVar[int]
    HEAD_VERSION_ID_FIELD_NUMBER: _ClassVar[int]
    PUBLISHED_VERSION_ID_FIELD_NUMBER: _ClassVar[int]
    id: str
    tenant_id: str
    organization_id: str
    repository_id: str
    kind: ElementKind
    type_key: str
    body: _any_pb2.Any
    metadata: _containers.ScalarMap[str, str]
    tags: _containers.RepeatedScalarFieldContainer[str]
    created_at: _timestamp_pb2.Timestamp
    created_by: str
    updated_at: _timestamp_pb2.Timestamp
    updated_by: str
    title: str
    description: str
    lifecycle_state: str
    head_version_id: str
    published_version_id: str
    def __init__(self, id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., kind: _Optional[_Union[ElementKind, str]] = ..., type_key: _Optional[str] = ..., body: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., metadata: _Optional[_Mapping[str, str]] = ..., tags: _Optional[_Iterable[str]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_by: _Optional[str] = ..., updated_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., updated_by: _Optional[str] = ..., title: _Optional[str] = ..., description: _Optional[str] = ..., lifecycle_state: _Optional[str] = ..., head_version_id: _Optional[str] = ..., published_version_id: _Optional[str] = ...) -> None: ...

class ElementVersion(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    VERSION_NUMBER_FIELD_NUMBER: _ClassVar[int]
    BODY_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_FIELD_NUMBER: _ClassVar[int]
    id: str
    element_id: str
    version_number: int
    body: _any_pb2.Any
    metadata: _containers.ScalarMap[str, str]
    created_at: _timestamp_pb2.Timestamp
    created_by: str
    def __init__(self, id: _Optional[str] = ..., element_id: _Optional[str] = ..., version_number: _Optional[int] = ..., body: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., metadata: _Optional[_Mapping[str, str]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_by: _Optional[str] = ...) -> None: ...

class ElementRelationship(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    TYPE_KEY_FIELD_NUMBER: _ClassVar[int]
    SOURCE_ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    TARGET_ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    BODY_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_FIELD_NUMBER: _ClassVar[int]
    UPDATED_AT_FIELD_NUMBER: _ClassVar[int]
    UPDATED_BY_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_KIND_FIELD_NUMBER: _ClassVar[int]
    POSITION_FIELD_NUMBER: _ClassVar[int]
    ROLE_FIELD_NUMBER: _ClassVar[int]
    id: str
    tenant_id: str
    organization_id: str
    repository_id: str
    type_key: str
    source_element_id: str
    target_element_id: str
    body: _any_pb2.Any
    metadata: _containers.ScalarMap[str, str]
    created_at: _timestamp_pb2.Timestamp
    created_by: str
    updated_at: _timestamp_pb2.Timestamp
    updated_by: str
    relationship_kind: str
    position: int
    role: str
    def __init__(self, id: _Optional[str] = ..., tenant_id: _Optional[str] = ..., organization_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., type_key: _Optional[str] = ..., source_element_id: _Optional[str] = ..., target_element_id: _Optional[str] = ..., body: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., metadata: _Optional[_Mapping[str, str]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_by: _Optional[str] = ..., updated_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., updated_by: _Optional[str] = ..., relationship_kind: _Optional[str] = ..., position: _Optional[int] = ..., role: _Optional[str] = ...) -> None: ...

class RelationshipVersion(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    RELATIONSHIP_ID_FIELD_NUMBER: _ClassVar[int]
    VERSION_NUMBER_FIELD_NUMBER: _ClassVar[int]
    SOURCE_ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    TARGET_ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    BODY_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_FIELD_NUMBER: _ClassVar[int]
    id: str
    relationship_id: str
    version_number: int
    source_element_id: str
    target_element_id: str
    body: _any_pb2.Any
    metadata: _containers.ScalarMap[str, str]
    created_at: _timestamp_pb2.Timestamp
    created_by: str
    def __init__(self, id: _Optional[str] = ..., relationship_id: _Optional[str] = ..., version_number: _Optional[int] = ..., source_element_id: _Optional[str] = ..., target_element_id: _Optional[str] = ..., body: _Optional[_Union[_any_pb2.Any, _Mapping]] = ..., metadata: _Optional[_Mapping[str, str]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_by: _Optional[str] = ...) -> None: ...

class Attachment(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ID_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    STORAGE_URI_FIELD_NUMBER: _ClassVar[int]
    HASH_FIELD_NUMBER: _ClassVar[int]
    MEDIA_TYPE_FIELD_NUMBER: _ClassVar[int]
    SIZE_BYTES_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    CREATED_AT_FIELD_NUMBER: _ClassVar[int]
    CREATED_BY_FIELD_NUMBER: _ClassVar[int]
    id: str
    element_id: str
    storage_uri: str
    hash: str
    media_type: str
    size_bytes: int
    metadata: _containers.ScalarMap[str, str]
    created_at: _timestamp_pb2.Timestamp
    created_by: str
    def __init__(self, id: _Optional[str] = ..., element_id: _Optional[str] = ..., storage_uri: _Optional[str] = ..., hash: _Optional[str] = ..., media_type: _Optional[str] = ..., size_bytes: _Optional[int] = ..., metadata: _Optional[_Mapping[str, str]] = ..., created_at: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., created_by: _Optional[str] = ...) -> None: ...

class CreateElementRequest(_message.Message):
    __slots__ = ()
    ELEMENT_FIELD_NUMBER: _ClassVar[int]
    element: Element
    def __init__(self, element: _Optional[_Union[Element, _Mapping]] = ...) -> None: ...

class CreateElementResponse(_message.Message):
    __slots__ = ()
    ELEMENT_FIELD_NUMBER: _ClassVar[int]
    element: Element
    def __init__(self, element: _Optional[_Union[Element, _Mapping]] = ...) -> None: ...

class UpdateElementRequest(_message.Message):
    __slots__ = ()
    ELEMENT_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    element: Element
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, element: _Optional[_Union[Element, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateElementResponse(_message.Message):
    __slots__ = ()
    ELEMENT_FIELD_NUMBER: _ClassVar[int]
    element: Element
    def __init__(self, element: _Optional[_Union[Element, _Mapping]] = ...) -> None: ...

class GetElementRequest(_message.Message):
    __slots__ = ()
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    element_id: str
    def __init__(self, element_id: _Optional[str] = ...) -> None: ...

class GetElementResponse(_message.Message):
    __slots__ = ()
    ELEMENT_FIELD_NUMBER: _ClassVar[int]
    element: Element
    def __init__(self, element: _Optional[_Union[Element, _Mapping]] = ...) -> None: ...

class ListElementsRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    TYPE_KEYS_FIELD_NUMBER: _ClassVar[int]
    KINDS_FIELD_NUMBER: _ClassVar[int]
    PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    PAGE_SIZE_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    repository_id: str
    type_keys: _containers.RepeatedScalarFieldContainer[str]
    kinds: _containers.RepeatedScalarFieldContainer[ElementKind]
    page_token: str
    page_size: int
    def __init__(self, tenant_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., type_keys: _Optional[_Iterable[str]] = ..., kinds: _Optional[_Iterable[_Union[ElementKind, str]]] = ..., page_token: _Optional[str] = ..., page_size: _Optional[int] = ...) -> None: ...

class ListElementsResponse(_message.Message):
    __slots__ = ()
    ELEMENTS_FIELD_NUMBER: _ClassVar[int]
    NEXT_PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    elements: _containers.RepeatedCompositeFieldContainer[Element]
    next_page_token: str
    def __init__(self, elements: _Optional[_Iterable[_Union[Element, _Mapping]]] = ..., next_page_token: _Optional[str] = ...) -> None: ...

class DeleteElementRequest(_message.Message):
    __slots__ = ()
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    element_id: str
    def __init__(self, element_id: _Optional[str] = ...) -> None: ...

class CreateRelationshipRequest(_message.Message):
    __slots__ = ()
    RELATIONSHIP_FIELD_NUMBER: _ClassVar[int]
    relationship: ElementRelationship
    def __init__(self, relationship: _Optional[_Union[ElementRelationship, _Mapping]] = ...) -> None: ...

class CreateRelationshipResponse(_message.Message):
    __slots__ = ()
    RELATIONSHIP_FIELD_NUMBER: _ClassVar[int]
    relationship: ElementRelationship
    def __init__(self, relationship: _Optional[_Union[ElementRelationship, _Mapping]] = ...) -> None: ...

class GetRelationshipRequest(_message.Message):
    __slots__ = ()
    RELATIONSHIP_ID_FIELD_NUMBER: _ClassVar[int]
    relationship_id: str
    def __init__(self, relationship_id: _Optional[str] = ...) -> None: ...

class GetRelationshipResponse(_message.Message):
    __slots__ = ()
    RELATIONSHIP_FIELD_NUMBER: _ClassVar[int]
    relationship: ElementRelationship
    def __init__(self, relationship: _Optional[_Union[ElementRelationship, _Mapping]] = ...) -> None: ...

class ListRelationshipsRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    TYPE_KEYS_FIELD_NUMBER: _ClassVar[int]
    PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    PAGE_SIZE_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    repository_id: str
    type_keys: _containers.RepeatedScalarFieldContainer[str]
    page_token: str
    page_size: int
    def __init__(self, tenant_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., type_keys: _Optional[_Iterable[str]] = ..., page_token: _Optional[str] = ..., page_size: _Optional[int] = ...) -> None: ...

class ListRelationshipsResponse(_message.Message):
    __slots__ = ()
    RELATIONSHIPS_FIELD_NUMBER: _ClassVar[int]
    NEXT_PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    relationships: _containers.RepeatedCompositeFieldContainer[ElementRelationship]
    next_page_token: str
    def __init__(self, relationships: _Optional[_Iterable[_Union[ElementRelationship, _Mapping]]] = ..., next_page_token: _Optional[str] = ...) -> None: ...

class DeleteRelationshipRequest(_message.Message):
    __slots__ = ()
    RELATIONSHIP_ID_FIELD_NUMBER: _ClassVar[int]
    relationship_id: str
    def __init__(self, relationship_id: _Optional[str] = ...) -> None: ...

class GetElementVersionRequest(_message.Message):
    __slots__ = ()
    VERSION_ID_FIELD_NUMBER: _ClassVar[int]
    version_id: str
    def __init__(self, version_id: _Optional[str] = ...) -> None: ...

class GetElementVersionResponse(_message.Message):
    __slots__ = ()
    VERSION_FIELD_NUMBER: _ClassVar[int]
    version: ElementVersion
    def __init__(self, version: _Optional[_Union[ElementVersion, _Mapping]] = ...) -> None: ...

class ListElementVersionsRequest(_message.Message):
    __slots__ = ()
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    PAGE_SIZE_FIELD_NUMBER: _ClassVar[int]
    element_id: str
    page_token: str
    page_size: int
    def __init__(self, element_id: _Optional[str] = ..., page_token: _Optional[str] = ..., page_size: _Optional[int] = ...) -> None: ...

class ListElementVersionsResponse(_message.Message):
    __slots__ = ()
    VERSIONS_FIELD_NUMBER: _ClassVar[int]
    NEXT_PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    versions: _containers.RepeatedCompositeFieldContainer[ElementVersion]
    next_page_token: str
    def __init__(self, versions: _Optional[_Iterable[_Union[ElementVersion, _Mapping]]] = ..., next_page_token: _Optional[str] = ...) -> None: ...

class GetRelationshipVersionRequest(_message.Message):
    __slots__ = ()
    VERSION_ID_FIELD_NUMBER: _ClassVar[int]
    version_id: str
    def __init__(self, version_id: _Optional[str] = ...) -> None: ...

class GetRelationshipVersionResponse(_message.Message):
    __slots__ = ()
    VERSION_FIELD_NUMBER: _ClassVar[int]
    version: RelationshipVersion
    def __init__(self, version: _Optional[_Union[RelationshipVersion, _Mapping]] = ...) -> None: ...

class ListRelationshipVersionsRequest(_message.Message):
    __slots__ = ()
    RELATIONSHIP_ID_FIELD_NUMBER: _ClassVar[int]
    PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    PAGE_SIZE_FIELD_NUMBER: _ClassVar[int]
    relationship_id: str
    page_token: str
    page_size: int
    def __init__(self, relationship_id: _Optional[str] = ..., page_token: _Optional[str] = ..., page_size: _Optional[int] = ...) -> None: ...

class ListRelationshipVersionsResponse(_message.Message):
    __slots__ = ()
    VERSIONS_FIELD_NUMBER: _ClassVar[int]
    NEXT_PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    versions: _containers.RepeatedCompositeFieldContainer[RelationshipVersion]
    next_page_token: str
    def __init__(self, versions: _Optional[_Iterable[_Union[RelationshipVersion, _Mapping]]] = ..., next_page_token: _Optional[str] = ...) -> None: ...
