from google.protobuf import field_mask_pb2 as _field_mask_pb2
from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class Role(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    ROLE_UNSPECIFIED: _ClassVar[Role]
    ROLE_ADMIN: _ClassVar[Role]
    ROLE_CONTRIBUTOR: _ClassVar[Role]
    ROLE_SERVICE: _ClassVar[Role]
    ROLE_GUEST: _ClassVar[Role]
    ROLE_VIEWER: _ClassVar[Role]
ROLE_UNSPECIFIED: Role
ROLE_ADMIN: Role
ROLE_CONTRIBUTOR: Role
ROLE_SERVICE: Role
ROLE_GUEST: Role
ROLE_VIEWER: Role

class OrganizationRole(_message.Message):
    __slots__ = ()
    class PermissionsEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    METADATA_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    CODE_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    PERMISSIONS_FIELD_NUMBER: _ClassVar[int]
    IS_DEFAULT_FIELD_NUMBER: _ClassVar[int]
    metadata: _common_pb2.ResourceMetadata
    organization_id: str
    code: str
    name: str
    description: str
    permissions: _containers.ScalarMap[str, str]
    is_default: bool
    def __init__(self, metadata: _Optional[_Union[_common_pb2.ResourceMetadata, _Mapping]] = ..., organization_id: _Optional[str] = ..., code: _Optional[str] = ..., name: _Optional[str] = ..., description: _Optional[str] = ..., permissions: _Optional[_Mapping[str, str]] = ..., is_default: _Optional[bool] = ...) -> None: ...

class CreateOrganizationRoleRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ROLE_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    role: OrganizationRole
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., role: _Optional[_Union[OrganizationRole, _Mapping]] = ...) -> None: ...

class CreateOrganizationRoleResponse(_message.Message):
    __slots__ = ()
    ROLE_FIELD_NUMBER: _ClassVar[int]
    role: OrganizationRole
    def __init__(self, role: _Optional[_Union[OrganizationRole, _Mapping]] = ...) -> None: ...

class UpdateOrganizationRoleRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ROLE_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    role: OrganizationRole
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., role: _Optional[_Union[OrganizationRole, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateOrganizationRoleResponse(_message.Message):
    __slots__ = ()
    ROLE_FIELD_NUMBER: _ClassVar[int]
    role: OrganizationRole
    def __init__(self, role: _Optional[_Union[OrganizationRole, _Mapping]] = ...) -> None: ...

class DeleteOrganizationRoleRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ROLE_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_role_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_role_id: _Optional[str] = ...) -> None: ...

class DeleteOrganizationRoleResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class GetOrganizationRoleRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ROLE_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_role_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_role_id: _Optional[str] = ...) -> None: ...

class GetOrganizationRoleResponse(_message.Message):
    __slots__ = ()
    ROLE_FIELD_NUMBER: _ClassVar[int]
    role: OrganizationRole
    def __init__(self, role: _Optional[_Union[OrganizationRole, _Mapping]] = ...) -> None: ...

class ListOrganizationRolesRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListOrganizationRolesResponse(_message.Message):
    __slots__ = ()
    ROLES_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    roles: _containers.RepeatedCompositeFieldContainer[OrganizationRole]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, roles: _Optional[_Iterable[_Union[OrganizationRole, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...
