from google.protobuf import field_mask_pb2 as _field_mask_pb2
from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from ameide_core_proto.common.v1 import annotations_pb2 as _annotations_pb2
from ameide_core_proto.transformation.v1 import transformation_pb2 as _transformation_pb2
from ameide_core_proto.graph.v1 import graph_pb2 as _graph_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class ListTransformationsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    REPOSITORY_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    tenant_id: str
    repository_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., tenant_id: _Optional[str] = ..., repository_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListTransformationsResponse(_message.Message):
    __slots__ = ()
    TRANSFORMATIONS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    transformations: _containers.RepeatedCompositeFieldContainer[_transformation_pb2.Transformation]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, transformations: _Optional[_Iterable[_Union[_transformation_pb2.Transformation, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetTransformationRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    transformation_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., transformation_id: _Optional[str] = ...) -> None: ...

class GetTransformationResponse(_message.Message):
    __slots__ = ()
    TRANSFORMATION_FIELD_NUMBER: _ClassVar[int]
    transformation: _transformation_pb2.Transformation
    def __init__(self, transformation: _Optional[_Union[_transformation_pb2.Transformation, _Mapping]] = ...) -> None: ...

class CreateTransformationRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    transformation: _transformation_pb2.Transformation
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., transformation: _Optional[_Union[_transformation_pb2.Transformation, _Mapping]] = ...) -> None: ...

class CreateTransformationResponse(_message.Message):
    __slots__ = ()
    TRANSFORMATION_FIELD_NUMBER: _ClassVar[int]
    transformation: _transformation_pb2.Transformation
    def __init__(self, transformation: _Optional[_Union[_transformation_pb2.Transformation, _Mapping]] = ...) -> None: ...

class UpdateTransformationRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    transformation: _transformation_pb2.Transformation
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., transformation: _Optional[_Union[_transformation_pb2.Transformation, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateTransformationResponse(_message.Message):
    __slots__ = ()
    TRANSFORMATION_FIELD_NUMBER: _ClassVar[int]
    transformation: _transformation_pb2.Transformation
    def __init__(self, transformation: _Optional[_Union[_transformation_pb2.Transformation, _Mapping]] = ...) -> None: ...

class GetTransformationWorkspaceRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    transformation_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., transformation_id: _Optional[str] = ...) -> None: ...

class GetTransformationWorkspaceResponse(_message.Message):
    __slots__ = ()
    NODES_FIELD_NUMBER: _ClassVar[int]
    ELEMENTS_FIELD_NUMBER: _ClassVar[int]
    GRAPH_FIELD_NUMBER: _ClassVar[int]
    nodes: _containers.RepeatedCompositeFieldContainer[_transformation_pb2.TransformationWorkspaceNode]
    elements: _containers.RepeatedCompositeFieldContainer[_graph_pb2.Element]
    graph: _graph_pb2.Repository
    def __init__(self, nodes: _Optional[_Iterable[_Union[_transformation_pb2.TransformationWorkspaceNode, _Mapping]]] = ..., elements: _Optional[_Iterable[_Union[_graph_pb2.Element, _Mapping]]] = ..., graph: _Optional[_Union[_graph_pb2.Repository, _Mapping]] = ...) -> None: ...

class ListTransformationElementsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_ID_FIELD_NUMBER: _ClassVar[int]
    WORKSPACE_NODE_IDS_FIELD_NUMBER: _ClassVar[int]
    SEARCH_QUERY_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    transformation_id: str
    workspace_node_ids: _containers.RepeatedScalarFieldContainer[str]
    search_query: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., transformation_id: _Optional[str] = ..., workspace_node_ids: _Optional[_Iterable[str]] = ..., search_query: _Optional[str] = ...) -> None: ...

class ListTransformationElementsResponse(_message.Message):
    __slots__ = ()
    ELEMENTS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    elements: _containers.RepeatedCompositeFieldContainer[_graph_pb2.Element]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, elements: _Optional[_Iterable[_Union[_graph_pb2.Element, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class ListTransformationMilestonesRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    transformation_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., transformation_id: _Optional[str] = ...) -> None: ...

class ListTransformationMilestonesResponse(_message.Message):
    __slots__ = ()
    MILESTONES_FIELD_NUMBER: _ClassVar[int]
    milestones: _containers.RepeatedCompositeFieldContainer[_transformation_pb2.TransformationMilestone]
    def __init__(self, milestones: _Optional[_Iterable[_Union[_transformation_pb2.TransformationMilestone, _Mapping]]] = ...) -> None: ...

class ListTransformationMetricSnapshotsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    transformation_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., transformation_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListTransformationMetricSnapshotsResponse(_message.Message):
    __slots__ = ()
    SNAPSHOTS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    snapshots: _containers.RepeatedCompositeFieldContainer[_transformation_pb2.TransformationMetricSnapshot]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, snapshots: _Optional[_Iterable[_Union[_transformation_pb2.TransformationMetricSnapshot, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class ListTransformationAlertsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    transformation_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., transformation_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListTransformationAlertsResponse(_message.Message):
    __slots__ = ()
    ALERTS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    alerts: _containers.RepeatedCompositeFieldContainer[_transformation_pb2.TransformationAlert]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, alerts: _Optional[_Iterable[_Union[_transformation_pb2.TransformationAlert, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...
