from importlib import metadata as _metadata
import importlib
from pathlib import Path
import sys

# Ensure generated protos (which refer to the top-level package name
# "ameide_core_proto") are importable from the installed SDK.
_generated_path = Path(__file__).resolve().parent / "generated"
_generated_path_str = str(_generated_path)
if _generated_path.exists() and _generated_path_str not in sys.path:
    sys.path.append(_generated_path_str)

# Alias the generated package so imports inside stub modules resolve even when
# an older / placeholder ameide_core_proto package is on sys.path.
try:
    sys.modules["ameide_core_proto"] = importlib.import_module(
        "ameide_sdk.generated.ameide_core_proto"
    )
except ModuleNotFoundError:
    pass

from .config import SDKOptions, RetryConfig, TelemetryConfig
from .element_service import ElementService, create_element_service
from .errors import AmeideRpcError, RpcErrorCategory, normalize_error

try:
    __version__ = _metadata.version("ameide-sdk-python")
except _metadata.PackageNotFoundError:  # pragma: no cover - fallback for editable installs
    __version__ = "0.0.0"

def __getattr__(name: str):
    if name == "AmeideClient":
        from .client import AmeideClient
        return AmeideClient
    raise AttributeError(name)


__all__ = [
    "AmeideClient",
    "SDKOptions",
    "RetryConfig",
    "TelemetryConfig",
    "AmeideRpcError",
    "RpcErrorCategory",
    "normalize_error",
    "ElementService",
    "create_element_service",
    "__version__",
]
