#!/usr/bin/env python3

from pathlib import Path
import tomllib

from setuptools import find_namespace_packages, setup


def read_version() -> str:
    """Resolve the package version from pyproject.toml (defaulting to 0.0.0)."""
    pyproject = Path(__file__).resolve().parent / "pyproject.toml"
    try:
        data = tomllib.loads(pyproject.read_text(encoding="utf-8"))
        return data.get("project", {}).get("version", "0.0.0")
    except Exception:
        return "0.0.0"


setup(
    name="ameide-sdk-python",
    version=read_version(),
    description="Official AMEIDE Python SDK",
    author="AMEIDE Team",
    author_email="team@ameide.io",
    packages=find_namespace_packages(where="src", include=["ameide_sdk", "ameide_sdk.*"]),
    package_dir={"": "src"},
    include_package_data=True,
    install_requires=[
        "grpcio>=1.65.5",
        "protobuf>=5.28.0",
        "opentelemetry-api>=1.26.0",
    ],
    python_requires=">=3.12",
)
