from __future__ import annotations

from typing import Any


class ElementService:
    """Convenience wrapper around GraphService RPCs. Optional helper; core client already exposes graph stub."""

    def __init__(self, graph_stub: Any) -> None:
        self._graph = graph_stub

    def list_elements(self, request):
        return self._graph.ListElements(request)

    def list_relationships(self, request):
        return self._graph.ListRelationships(request)

    def create_element(self, request):
        return self._graph.CreateElement(request)

    def create_relationship(self, request):
        return self._graph.CreateRelationship(request)


def create_element_service(graph_stub: Any) -> ElementService:
    return ElementService(graph_stub)
