from ameide_core_proto.agents_runtime.v1 import agents_runtime_types_pb2 as _agents_runtime_types_pb2
from google.protobuf import struct_pb2 as _struct_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class InvocationContext(_message.Message):
    __slots__ = ()
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    AGENT_INSTANCE_ID_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    REQUEST_CONTEXT_FIELD_NUMBER: _ClassVar[int]
    UI_PAGE_FIELD_NUMBER: _ClassVar[int]
    USER_ROLE_FIELD_NUMBER: _ClassVar[int]
    HAS_GRAPH_FIELD_NUMBER: _ClassVar[int]
    HAS_SELECTION_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_KIND_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    agent_instance_id: str
    metadata: _containers.ScalarMap[str, str]
    request_context: _struct_pb2.Struct
    ui_page: str
    user_role: str
    has_graph: bool
    has_selection: bool
    element_kind: str
    def __init__(self, tenant_id: _Optional[str] = ..., agent_instance_id: _Optional[str] = ..., metadata: _Optional[_Mapping[str, str]] = ..., request_context: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., ui_page: _Optional[str] = ..., user_role: _Optional[str] = ..., has_graph: _Optional[bool] = ..., has_selection: _Optional[bool] = ..., element_kind: _Optional[str] = ...) -> None: ...

class InvokeRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    MESSAGES_FIELD_NUMBER: _ClassVar[int]
    OPTIONS_FIELD_NUMBER: _ClassVar[int]
    context: InvocationContext
    messages: _containers.RepeatedCompositeFieldContainer[_agents_runtime_types_pb2.Message]
    options: _agents_runtime_types_pb2.Options
    def __init__(self, context: _Optional[_Union[InvocationContext, _Mapping]] = ..., messages: _Optional[_Iterable[_Union[_agents_runtime_types_pb2.Message, _Mapping]]] = ..., options: _Optional[_Union[_agents_runtime_types_pb2.Options, _Mapping]] = ...) -> None: ...

class StreamRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    MESSAGES_FIELD_NUMBER: _ClassVar[int]
    OPTIONS_FIELD_NUMBER: _ClassVar[int]
    RESUME_TOKEN_FIELD_NUMBER: _ClassVar[int]
    context: InvocationContext
    messages: _containers.RepeatedCompositeFieldContainer[_agents_runtime_types_pb2.Message]
    options: _agents_runtime_types_pb2.Options
    resume_token: str
    def __init__(self, context: _Optional[_Union[InvocationContext, _Mapping]] = ..., messages: _Optional[_Iterable[_Union[_agents_runtime_types_pb2.Message, _Mapping]]] = ..., options: _Optional[_Union[_agents_runtime_types_pb2.Options, _Mapping]] = ..., resume_token: _Optional[str] = ...) -> None: ...

class InvokeResponse(_message.Message):
    __slots__ = ()
    OUTPUT_FIELD_NUMBER: _ClassVar[int]
    USAGE_FIELD_NUMBER: _ClassVar[int]
    TOOL_CALLS_FIELD_NUMBER: _ClassVar[int]
    FINAL_EVENT_FIELD_NUMBER: _ClassVar[int]
    output: _agents_runtime_types_pb2.Message
    usage: _agents_runtime_types_pb2.Usage
    tool_calls: _containers.RepeatedCompositeFieldContainer[_agents_runtime_types_pb2.ToolCall]
    final_event: _agents_runtime_types_pb2.StreamEventMeta
    def __init__(self, output: _Optional[_Union[_agents_runtime_types_pb2.Message, _Mapping]] = ..., usage: _Optional[_Union[_agents_runtime_types_pb2.Usage, _Mapping]] = ..., tool_calls: _Optional[_Iterable[_Union[_agents_runtime_types_pb2.ToolCall, _Mapping]]] = ..., final_event: _Optional[_Union[_agents_runtime_types_pb2.StreamEventMeta, _Mapping]] = ...) -> None: ...

class StreamEvent(_message.Message):
    __slots__ = ()
    META_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    TOKEN_FIELD_NUMBER: _ClassVar[int]
    TOOL_START_FIELD_NUMBER: _ClassVar[int]
    TOOL_END_FIELD_NUMBER: _ClassVar[int]
    USAGE_FIELD_NUMBER: _ClassVar[int]
    ERROR_FIELD_NUMBER: _ClassVar[int]
    HEARTBEAT_FIELD_NUMBER: _ClassVar[int]
    CONTENT_FIELD_NUMBER: _ClassVar[int]
    meta: _agents_runtime_types_pb2.StreamEventMeta
    status: _agents_runtime_types_pb2.Status
    token: _agents_runtime_types_pb2.TokenDelta
    tool_start: ToolCallStarted
    tool_end: ToolCallCompleted
    usage: _agents_runtime_types_pb2.Usage
    error: _agents_runtime_types_pb2.Error
    heartbeat: _agents_runtime_types_pb2.Heartbeat
    content: Content
    def __init__(self, meta: _Optional[_Union[_agents_runtime_types_pb2.StreamEventMeta, _Mapping]] = ..., status: _Optional[_Union[_agents_runtime_types_pb2.Status, _Mapping]] = ..., token: _Optional[_Union[_agents_runtime_types_pb2.TokenDelta, _Mapping]] = ..., tool_start: _Optional[_Union[ToolCallStarted, _Mapping]] = ..., tool_end: _Optional[_Union[ToolCallCompleted, _Mapping]] = ..., usage: _Optional[_Union[_agents_runtime_types_pb2.Usage, _Mapping]] = ..., error: _Optional[_Union[_agents_runtime_types_pb2.Error, _Mapping]] = ..., heartbeat: _Optional[_Union[_agents_runtime_types_pb2.Heartbeat, _Mapping]] = ..., content: _Optional[_Union[Content, _Mapping]] = ...) -> None: ...

class StreamResponse(_message.Message):
    __slots__ = ()
    EVENT_FIELD_NUMBER: _ClassVar[int]
    event: StreamEvent
    def __init__(self, event: _Optional[_Union[StreamEvent, _Mapping]] = ...) -> None: ...

class Content(_message.Message):
    __slots__ = ()
    BLOCKS_FIELD_NUMBER: _ClassVar[int]
    blocks: _containers.RepeatedCompositeFieldContainer[ContentBlock]
    def __init__(self, blocks: _Optional[_Iterable[_Union[ContentBlock, _Mapping]]] = ...) -> None: ...

class ContentBlock(_message.Message):
    __slots__ = ()
    TYPE_FIELD_NUMBER: _ClassVar[int]
    TEXT_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    type: str
    text: str
    metadata: _struct_pb2.Struct
    def __init__(self, type: _Optional[str] = ..., text: _Optional[str] = ..., metadata: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ...) -> None: ...

class ToolCallStarted(_message.Message):
    __slots__ = ()
    TOOL_FIELD_NUMBER: _ClassVar[int]
    tool: _agents_runtime_types_pb2.ToolCall
    def __init__(self, tool: _Optional[_Union[_agents_runtime_types_pb2.ToolCall, _Mapping]] = ...) -> None: ...

class ToolCallCompleted(_message.Message):
    __slots__ = ()
    TOOL_FIELD_NUMBER: _ClassVar[int]
    OUTPUT_FIELD_NUMBER: _ClassVar[int]
    ERROR_FIELD_NUMBER: _ClassVar[int]
    tool: _agents_runtime_types_pb2.ToolCall
    output: str
    error: bool
    def __init__(self, tool: _Optional[_Union[_agents_runtime_types_pb2.ToolCall, _Mapping]] = ..., output: _Optional[str] = ..., error: _Optional[bool] = ...) -> None: ...

class ListAgentsRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    CAPABILITIES_FIELD_NUMBER: _ClassVar[int]
    INCLUDE_DISABLED_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    capabilities: _containers.RepeatedScalarFieldContainer[str]
    include_disabled: bool
    def __init__(self, tenant_id: _Optional[str] = ..., capabilities: _Optional[_Iterable[str]] = ..., include_disabled: _Optional[bool] = ...) -> None: ...

class ListAgentsResponse(_message.Message):
    __slots__ = ()
    AGENTS_FIELD_NUMBER: _ClassVar[int]
    agents: _containers.RepeatedCompositeFieldContainer[AgentInfo]
    def __init__(self, agents: _Optional[_Iterable[_Union[AgentInfo, _Mapping]]] = ...) -> None: ...

class AgentInfo(_message.Message):
    __slots__ = ()
    ID_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
    MODEL_FIELD_NUMBER: _ClassVar[int]
    CAPABILITIES_FIELD_NUMBER: _ClassVar[int]
    ENABLED_FIELD_NUMBER: _ClassVar[int]
    MAX_TOKENS_FIELD_NUMBER: _ClassVar[int]
    TEMPERATURE_FIELD_NUMBER: _ClassVar[int]
    RATE_LIMITS_FIELD_NUMBER: _ClassVar[int]
    id: str
    name: str
    description: str
    model: str
    capabilities: _containers.RepeatedScalarFieldContainer[str]
    enabled: bool
    max_tokens: int
    temperature: float
    rate_limits: RateLimits
    def __init__(self, id: _Optional[str] = ..., name: _Optional[str] = ..., description: _Optional[str] = ..., model: _Optional[str] = ..., capabilities: _Optional[_Iterable[str]] = ..., enabled: _Optional[bool] = ..., max_tokens: _Optional[int] = ..., temperature: _Optional[float] = ..., rate_limits: _Optional[_Union[RateLimits, _Mapping]] = ...) -> None: ...

class RateLimits(_message.Message):
    __slots__ = ()
    REQUESTS_PER_MINUTE_FIELD_NUMBER: _ClassVar[int]
    TOKENS_PER_HOUR_FIELD_NUMBER: _ClassVar[int]
    CONCURRENT_STREAMS_FIELD_NUMBER: _ClassVar[int]
    requests_per_minute: int
    tokens_per_hour: int
    concurrent_streams: int
    def __init__(self, requests_per_minute: _Optional[int] = ..., tokens_per_hour: _Optional[int] = ..., concurrent_streams: _Optional[int] = ...) -> None: ...
