from google.protobuf import descriptor_pb2 as _descriptor_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class AuthLevel(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    AUTH_LEVEL_UNSPECIFIED: _ClassVar[AuthLevel]
    AUTH_LEVEL_NONE: _ClassVar[AuthLevel]
    AUTH_LEVEL_BASIC: _ClassVar[AuthLevel]
    AUTH_LEVEL_TOKEN: _ClassVar[AuthLevel]
    AUTH_LEVEL_OAUTH2: _ClassVar[AuthLevel]
    AUTH_LEVEL_MTLS: _ClassVar[AuthLevel]

class RateLimitScope(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    RATE_LIMIT_SCOPE_UNSPECIFIED: _ClassVar[RateLimitScope]
    RATE_LIMIT_SCOPE_GLOBAL: _ClassVar[RateLimitScope]
    RATE_LIMIT_SCOPE_USER: _ClassVar[RateLimitScope]
    RATE_LIMIT_SCOPE_IP: _ClassVar[RateLimitScope]
    RATE_LIMIT_SCOPE_TENANT: _ClassVar[RateLimitScope]
    RATE_LIMIT_SCOPE_API_KEY: _ClassVar[RateLimitScope]

class Priority(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    PRIORITY_UNSPECIFIED: _ClassVar[Priority]
    PRIORITY_LOW: _ClassVar[Priority]
    PRIORITY_MEDIUM: _ClassVar[Priority]
    PRIORITY_HIGH: _ClassVar[Priority]
    PRIORITY_CRITICAL: _ClassVar[Priority]

class AuditLevel(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    AUDIT_LEVEL_UNSPECIFIED: _ClassVar[AuditLevel]
    AUDIT_LEVEL_NONE: _ClassVar[AuditLevel]
    AUDIT_LEVEL_METADATA: _ClassVar[AuditLevel]
    AUDIT_LEVEL_SUMMARY: _ClassVar[AuditLevel]
    AUDIT_LEVEL_FULL: _ClassVar[AuditLevel]
AUTH_LEVEL_UNSPECIFIED: AuthLevel
AUTH_LEVEL_NONE: AuthLevel
AUTH_LEVEL_BASIC: AuthLevel
AUTH_LEVEL_TOKEN: AuthLevel
AUTH_LEVEL_OAUTH2: AuthLevel
AUTH_LEVEL_MTLS: AuthLevel
RATE_LIMIT_SCOPE_UNSPECIFIED: RateLimitScope
RATE_LIMIT_SCOPE_GLOBAL: RateLimitScope
RATE_LIMIT_SCOPE_USER: RateLimitScope
RATE_LIMIT_SCOPE_IP: RateLimitScope
RATE_LIMIT_SCOPE_TENANT: RateLimitScope
RATE_LIMIT_SCOPE_API_KEY: RateLimitScope
PRIORITY_UNSPECIFIED: Priority
PRIORITY_LOW: Priority
PRIORITY_MEDIUM: Priority
PRIORITY_HIGH: Priority
PRIORITY_CRITICAL: Priority
AUDIT_LEVEL_UNSPECIFIED: AuditLevel
AUDIT_LEVEL_NONE: AuditLevel
AUDIT_LEVEL_METADATA: AuditLevel
AUDIT_LEVEL_SUMMARY: AuditLevel
AUDIT_LEVEL_FULL: AuditLevel
AUTH_FIELD_NUMBER: _ClassVar[int]
auth: _descriptor.FieldDescriptor
RATE_LIMIT_FIELD_NUMBER: _ClassVar[int]
rate_limit: _descriptor.FieldDescriptor
SLA_FIELD_NUMBER: _ClassVar[int]
sla: _descriptor.FieldDescriptor
AUDIT_FIELD_NUMBER: _ClassVar[int]
audit: _descriptor.FieldDescriptor
CACHE_FIELD_NUMBER: _ClassVar[int]
cache: _descriptor.FieldDescriptor
RETRY_FIELD_NUMBER: _ClassVar[int]
retry: _descriptor.FieldDescriptor
FEATURES_FIELD_NUMBER: _ClassVar[int]
features: _descriptor.FieldDescriptor
DEPRECATED_USE_INSTEAD_FIELD_NUMBER: _ClassVar[int]
deprecated_use_instead: _descriptor.FieldDescriptor
BEHAVIOR_FIELD_NUMBER: _ClassVar[int]
behavior: _descriptor.FieldDescriptor
ENCRYPTED_FIELD_NUMBER: _ClassVar[int]
encrypted: _descriptor.FieldDescriptor
PII_FIELD_NUMBER: _ClassVar[int]
pii: _descriptor.FieldDescriptor
DEFAULT_EXPR_FIELD_NUMBER: _ClassVar[int]
default_expr: _descriptor.FieldDescriptor
SERVICE_VERSION_FIELD_NUMBER: _ClassVar[int]
service_version: _descriptor.FieldDescriptor
OWNER_TEAM_FIELD_NUMBER: _ClassVar[int]
owner_team: _descriptor.FieldDescriptor
DOCS_URL_FIELD_NUMBER: _ClassVar[int]
docs_url: _descriptor.FieldDescriptor
SLA_URL_FIELD_NUMBER: _ClassVar[int]
sla_url: _descriptor.FieldDescriptor
DEPENDENCIES_FIELD_NUMBER: _ClassVar[int]
dependencies: _descriptor.FieldDescriptor
SOFT_DELETE_FIELD_NUMBER: _ClassVar[int]
soft_delete: _descriptor.FieldDescriptor
VERSIONED_FIELD_NUMBER: _ClassVar[int]
versioned: _descriptor.FieldDescriptor
TRACK_CHANGES_FIELD_NUMBER: _ClassVar[int]
track_changes: _descriptor.FieldDescriptor
STORAGE_NAME_FIELD_NUMBER: _ClassVar[int]
storage_name: _descriptor.FieldDescriptor
RETENTION_DAYS_FIELD_NUMBER: _ClassVar[int]
retention_days: _descriptor.FieldDescriptor
ENUM_DEPRECATED_FIELD_NUMBER: _ClassVar[int]
enum_deprecated: _descriptor.FieldDescriptor
ALIASES_FIELD_NUMBER: _ClassVar[int]
aliases: _descriptor.FieldDescriptor

class AuthRequirement(_message.Message):
    __slots__ = ()
    AUTH_LEVEL_FIELD_NUMBER: _ClassVar[int]
    ROLES_FIELD_NUMBER: _ClassVar[int]
    PERMISSIONS_FIELD_NUMBER: _ClassVar[int]
    ALLOW_ANONYMOUS_FIELD_NUMBER: _ClassVar[int]
    SCOPES_FIELD_NUMBER: _ClassVar[int]
    auth_level: AuthLevel
    roles: _containers.RepeatedScalarFieldContainer[str]
    permissions: _containers.RepeatedScalarFieldContainer[str]
    allow_anonymous: bool
    scopes: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, auth_level: _Optional[_Union[AuthLevel, str]] = ..., roles: _Optional[_Iterable[str]] = ..., permissions: _Optional[_Iterable[str]] = ..., allow_anonymous: _Optional[bool] = ..., scopes: _Optional[_Iterable[str]] = ...) -> None: ...

class RateLimit(_message.Message):
    __slots__ = ()
    REQUESTS_FIELD_NUMBER: _ClassVar[int]
    WINDOW_SECONDS_FIELD_NUMBER: _ClassVar[int]
    SCOPE_FIELD_NUMBER: _ClassVar[int]
    CUSTOM_KEY_FIELD_NUMBER: _ClassVar[int]
    BURST_FIELD_NUMBER: _ClassVar[int]
    requests: int
    window_seconds: int
    scope: RateLimitScope
    custom_key: str
    burst: int
    def __init__(self, requests: _Optional[int] = ..., window_seconds: _Optional[int] = ..., scope: _Optional[_Union[RateLimitScope, str]] = ..., custom_key: _Optional[str] = ..., burst: _Optional[int] = ...) -> None: ...

class SLA(_message.Message):
    __slots__ = ()
    MAX_RESPONSE_TIME_MS_FIELD_NUMBER: _ClassVar[int]
    AVAILABILITY_TARGET_FIELD_NUMBER: _ClassVar[int]
    PRIORITY_FIELD_NUMBER: _ClassVar[int]
    MAX_CONCURRENT_REQUESTS_FIELD_NUMBER: _ClassVar[int]
    TIMEOUT_SECONDS_FIELD_NUMBER: _ClassVar[int]
    CIRCUIT_BREAKER_FIELD_NUMBER: _ClassVar[int]
    max_response_time_ms: int
    availability_target: float
    priority: Priority
    max_concurrent_requests: int
    timeout_seconds: int
    circuit_breaker: CircuitBreaker
    def __init__(self, max_response_time_ms: _Optional[int] = ..., availability_target: _Optional[float] = ..., priority: _Optional[_Union[Priority, str]] = ..., max_concurrent_requests: _Optional[int] = ..., timeout_seconds: _Optional[int] = ..., circuit_breaker: _Optional[_Union[CircuitBreaker, _Mapping]] = ...) -> None: ...

class CircuitBreaker(_message.Message):
    __slots__ = ()
    ERROR_THRESHOLD_FIELD_NUMBER: _ClassVar[int]
    VOLUME_THRESHOLD_FIELD_NUMBER: _ClassVar[int]
    SLEEP_WINDOW_SECONDS_FIELD_NUMBER: _ClassVar[int]
    error_threshold: float
    volume_threshold: int
    sleep_window_seconds: int
    def __init__(self, error_threshold: _Optional[float] = ..., volume_threshold: _Optional[int] = ..., sleep_window_seconds: _Optional[int] = ...) -> None: ...

class FieldBehavior(_message.Message):
    __slots__ = ()
    REQUIRED_FIELD_NUMBER: _ClassVar[int]
    IMMUTABLE_FIELD_NUMBER: _ClassVar[int]
    OUTPUT_ONLY_FIELD_NUMBER: _ClassVar[int]
    INPUT_ONLY_FIELD_NUMBER: _ClassVar[int]
    SENSITIVE_FIELD_NUMBER: _ClassVar[int]
    INDEXED_FIELD_NUMBER: _ClassVar[int]
    VALIDATION_REGEX_FIELD_NUMBER: _ClassVar[int]
    SEMANTIC_TYPE_FIELD_NUMBER: _ClassVar[int]
    required: bool
    immutable: bool
    output_only: bool
    input_only: bool
    sensitive: bool
    indexed: bool
    validation_regex: str
    semantic_type: str
    def __init__(self, required: _Optional[bool] = ..., immutable: _Optional[bool] = ..., output_only: _Optional[bool] = ..., input_only: _Optional[bool] = ..., sensitive: _Optional[bool] = ..., indexed: _Optional[bool] = ..., validation_regex: _Optional[str] = ..., semantic_type: _Optional[str] = ...) -> None: ...

class AuditConfig(_message.Message):
    __slots__ = ()
    ENABLED_FIELD_NUMBER: _ClassVar[int]
    LEVEL_FIELD_NUMBER: _ClassVar[int]
    INCLUDE_REQUEST_FIELD_NUMBER: _ClassVar[int]
    INCLUDE_RESPONSE_FIELD_NUMBER: _ClassVar[int]
    MASKED_FIELDS_FIELD_NUMBER: _ClassVar[int]
    enabled: bool
    level: AuditLevel
    include_request: bool
    include_response: bool
    masked_fields: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, enabled: _Optional[bool] = ..., level: _Optional[_Union[AuditLevel, str]] = ..., include_request: _Optional[bool] = ..., include_response: _Optional[bool] = ..., masked_fields: _Optional[_Iterable[str]] = ...) -> None: ...

class CacheConfig(_message.Message):
    __slots__ = ()
    ENABLED_FIELD_NUMBER: _ClassVar[int]
    TTL_SECONDS_FIELD_NUMBER: _ClassVar[int]
    KEY_PATTERN_FIELD_NUMBER: _ClassVar[int]
    CACHE_CONTROL_FIELD_NUMBER: _ClassVar[int]
    VARY_HEADERS_FIELD_NUMBER: _ClassVar[int]
    enabled: bool
    ttl_seconds: int
    key_pattern: str
    cache_control: _containers.RepeatedScalarFieldContainer[str]
    vary_headers: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, enabled: _Optional[bool] = ..., ttl_seconds: _Optional[int] = ..., key_pattern: _Optional[str] = ..., cache_control: _Optional[_Iterable[str]] = ..., vary_headers: _Optional[_Iterable[str]] = ...) -> None: ...

class RetryConfig(_message.Message):
    __slots__ = ()
    MAX_RETRIES_FIELD_NUMBER: _ClassVar[int]
    INITIAL_BACKOFF_MS_FIELD_NUMBER: _ClassVar[int]
    MAX_BACKOFF_MS_FIELD_NUMBER: _ClassVar[int]
    BACKOFF_MULTIPLIER_FIELD_NUMBER: _ClassVar[int]
    RETRYABLE_CODES_FIELD_NUMBER: _ClassVar[int]
    max_retries: int
    initial_backoff_ms: int
    max_backoff_ms: int
    backoff_multiplier: float
    retryable_codes: _containers.RepeatedScalarFieldContainer[int]
    def __init__(self, max_retries: _Optional[int] = ..., initial_backoff_ms: _Optional[int] = ..., max_backoff_ms: _Optional[int] = ..., backoff_multiplier: _Optional[float] = ..., retryable_codes: _Optional[_Iterable[int]] = ...) -> None: ...

class FeatureFlag(_message.Message):
    __slots__ = ()
    NAME_FIELD_NUMBER: _ClassVar[int]
    ENABLE_PERCENTAGE_FIELD_NUMBER: _ClassVar[int]
    ENABLED_USERS_FIELD_NUMBER: _ClassVar[int]
    ENABLED_TENANTS_FIELD_NUMBER: _ClassVar[int]
    name: str
    enable_percentage: int
    enabled_users: _containers.RepeatedScalarFieldContainer[str]
    enabled_tenants: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, name: _Optional[str] = ..., enable_percentage: _Optional[int] = ..., enabled_users: _Optional[_Iterable[str]] = ..., enabled_tenants: _Optional[_Iterable[str]] = ...) -> None: ...
