from ameide_core_proto.common.v1 import common_pb2 as _common_pb2
from ameide_core_proto.governance.v1 import governance_pb2 as _governance_pb2
from google.protobuf import field_mask_pb2 as _field_mask_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class ListPoliciesRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    STATUS_FILTER_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    pagination: _common_pb2.PaginationRequest
    status_filter: _governance_pb2.GovernancePolicyStatus
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ..., status_filter: _Optional[_Union[_governance_pb2.GovernancePolicyStatus, str]] = ...) -> None: ...

class ListPoliciesResponse(_message.Message):
    __slots__ = ()
    POLICIES_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    policies: _containers.RepeatedCompositeFieldContainer[_governance_pb2.GovernancePolicy]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, policies: _Optional[_Iterable[_Union[_governance_pb2.GovernancePolicy, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetPolicyRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    POLICY_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    policy_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., policy_id: _Optional[str] = ...) -> None: ...

class GetPolicyResponse(_message.Message):
    __slots__ = ()
    POLICY_FIELD_NUMBER: _ClassVar[int]
    policy: _governance_pb2.GovernancePolicy
    def __init__(self, policy: _Optional[_Union[_governance_pb2.GovernancePolicy, _Mapping]] = ...) -> None: ...

class CreatePolicyRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    POLICY_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    policy: _governance_pb2.GovernancePolicy
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., policy: _Optional[_Union[_governance_pb2.GovernancePolicy, _Mapping]] = ...) -> None: ...

class CreatePolicyResponse(_message.Message):
    __slots__ = ()
    POLICY_FIELD_NUMBER: _ClassVar[int]
    policy: _governance_pb2.GovernancePolicy
    def __init__(self, policy: _Optional[_Union[_governance_pb2.GovernancePolicy, _Mapping]] = ...) -> None: ...

class UpdatePolicyRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    POLICY_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    policy: _governance_pb2.GovernancePolicy
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., policy: _Optional[_Union[_governance_pb2.GovernancePolicy, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdatePolicyResponse(_message.Message):
    __slots__ = ()
    POLICY_FIELD_NUMBER: _ClassVar[int]
    policy: _governance_pb2.GovernancePolicy
    def __init__(self, policy: _Optional[_Union[_governance_pb2.GovernancePolicy, _Mapping]] = ...) -> None: ...

class ArchivePolicyRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    POLICY_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    policy_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., policy_id: _Optional[str] = ...) -> None: ...

class ArchivePolicyResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class ListGovernanceProfilesRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListGovernanceProfilesResponse(_message.Message):
    __slots__ = ()
    PROFILES_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    profiles: _containers.RepeatedCompositeFieldContainer[_governance_pb2.GovernanceProfile]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, profiles: _Optional[_Iterable[_Union[_governance_pb2.GovernanceProfile, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetGovernanceProfileRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    GOVERNANCE_PROFILE_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    governance_profile_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., governance_profile_id: _Optional[str] = ...) -> None: ...

class GetGovernanceProfileResponse(_message.Message):
    __slots__ = ()
    PROFILE_FIELD_NUMBER: _ClassVar[int]
    profile: _governance_pb2.GovernanceProfile
    def __init__(self, profile: _Optional[_Union[_governance_pb2.GovernanceProfile, _Mapping]] = ...) -> None: ...

class CreateGovernanceProfileRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    PROFILE_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    profile: _governance_pb2.GovernanceProfile
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., profile: _Optional[_Union[_governance_pb2.GovernanceProfile, _Mapping]] = ...) -> None: ...

class CreateGovernanceProfileResponse(_message.Message):
    __slots__ = ()
    PROFILE_FIELD_NUMBER: _ClassVar[int]
    profile: _governance_pb2.GovernanceProfile
    def __init__(self, profile: _Optional[_Union[_governance_pb2.GovernanceProfile, _Mapping]] = ...) -> None: ...

class UpdateGovernanceProfileRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    PROFILE_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    profile: _governance_pb2.GovernanceProfile
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., profile: _Optional[_Union[_governance_pb2.GovernanceProfile, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateGovernanceProfileResponse(_message.Message):
    __slots__ = ()
    PROFILE_FIELD_NUMBER: _ClassVar[int]
    profile: _governance_pb2.GovernanceProfile
    def __init__(self, profile: _Optional[_Union[_governance_pb2.GovernanceProfile, _Mapping]] = ...) -> None: ...

class ListOwnerGroupsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListOwnerGroupsResponse(_message.Message):
    __slots__ = ()
    OWNER_GROUPS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    owner_groups: _containers.RepeatedCompositeFieldContainer[_governance_pb2.GovernanceOwnerGroup]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, owner_groups: _Optional[_Iterable[_Union[_governance_pb2.GovernanceOwnerGroup, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetOwnerGroupRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    OWNER_GROUP_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    owner_group_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., owner_group_id: _Optional[str] = ...) -> None: ...

class GetOwnerGroupResponse(_message.Message):
    __slots__ = ()
    OWNER_GROUP_FIELD_NUMBER: _ClassVar[int]
    owner_group: _governance_pb2.GovernanceOwnerGroup
    def __init__(self, owner_group: _Optional[_Union[_governance_pb2.GovernanceOwnerGroup, _Mapping]] = ...) -> None: ...

class CreateOwnerGroupRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    OWNER_GROUP_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    owner_group: _governance_pb2.GovernanceOwnerGroup
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., owner_group: _Optional[_Union[_governance_pb2.GovernanceOwnerGroup, _Mapping]] = ...) -> None: ...

class CreateOwnerGroupResponse(_message.Message):
    __slots__ = ()
    OWNER_GROUP_FIELD_NUMBER: _ClassVar[int]
    owner_group: _governance_pb2.GovernanceOwnerGroup
    def __init__(self, owner_group: _Optional[_Union[_governance_pb2.GovernanceOwnerGroup, _Mapping]] = ...) -> None: ...

class UpdateOwnerGroupRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    OWNER_GROUP_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    owner_group: _governance_pb2.GovernanceOwnerGroup
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., owner_group: _Optional[_Union[_governance_pb2.GovernanceOwnerGroup, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateOwnerGroupResponse(_message.Message):
    __slots__ = ()
    OWNER_GROUP_FIELD_NUMBER: _ClassVar[int]
    owner_group: _governance_pb2.GovernanceOwnerGroup
    def __init__(self, owner_group: _Optional[_Union[_governance_pb2.GovernanceOwnerGroup, _Mapping]] = ...) -> None: ...

class ListRequiredChecksRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListRequiredChecksResponse(_message.Message):
    __slots__ = ()
    CHECKS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    checks: _containers.RepeatedCompositeFieldContainer[_governance_pb2.RequiredCheck]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, checks: _Optional[_Iterable[_Union[_governance_pb2.RequiredCheck, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetRequiredCheckRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    REQUIRED_CHECK_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    required_check_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., required_check_id: _Optional[str] = ...) -> None: ...

class GetRequiredCheckResponse(_message.Message):
    __slots__ = ()
    CHECK_FIELD_NUMBER: _ClassVar[int]
    check: _governance_pb2.RequiredCheck
    def __init__(self, check: _Optional[_Union[_governance_pb2.RequiredCheck, _Mapping]] = ...) -> None: ...

class CreateRequiredCheckRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    CHECK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    check: _governance_pb2.RequiredCheck
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., check: _Optional[_Union[_governance_pb2.RequiredCheck, _Mapping]] = ...) -> None: ...

class CreateRequiredCheckResponse(_message.Message):
    __slots__ = ()
    CHECK_FIELD_NUMBER: _ClassVar[int]
    check: _governance_pb2.RequiredCheck
    def __init__(self, check: _Optional[_Union[_governance_pb2.RequiredCheck, _Mapping]] = ...) -> None: ...

class UpdateRequiredCheckRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    CHECK_FIELD_NUMBER: _ClassVar[int]
    UPDATE_MASK_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    check: _governance_pb2.RequiredCheck
    update_mask: _field_mask_pb2.FieldMask
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., check: _Optional[_Union[_governance_pb2.RequiredCheck, _Mapping]] = ..., update_mask: _Optional[_Union[_field_mask_pb2.FieldMask, _Mapping]] = ...) -> None: ...

class UpdateRequiredCheckResponse(_message.Message):
    __slots__ = ()
    CHECK_FIELD_NUMBER: _ClassVar[int]
    check: _governance_pb2.RequiredCheck
    def __init__(self, check: _Optional[_Union[_governance_pb2.RequiredCheck, _Mapping]] = ...) -> None: ...

class ListGovernanceCasesRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    GRAPH_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    graph_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., graph_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListGovernanceCasesResponse(_message.Message):
    __slots__ = ()
    CASES_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    cases: _containers.RepeatedCompositeFieldContainer[_governance_pb2.GovernanceCase]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, cases: _Optional[_Iterable[_Union[_governance_pb2.GovernanceCase, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetGovernanceCaseRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    GOVERNANCE_CASE_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    governance_case_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., governance_case_id: _Optional[str] = ...) -> None: ...

class GetGovernanceCaseResponse(_message.Message):
    __slots__ = ()
    GOVERNANCE_CASE_FIELD_NUMBER: _ClassVar[int]
    governance_case: _governance_pb2.GovernanceCase
    def __init__(self, governance_case: _Optional[_Union[_governance_pb2.GovernanceCase, _Mapping]] = ...) -> None: ...

class ListCheckRunsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    GOVERNANCE_CASE_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    governance_case_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., governance_case_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListCheckRunsResponse(_message.Message):
    __slots__ = ()
    CHECK_RUNS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    check_runs: _containers.RepeatedCompositeFieldContainer[_governance_pb2.CheckRun]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, check_runs: _Optional[_Iterable[_Union[_governance_pb2.CheckRun, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...

class GetCheckRunRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    CHECK_RUN_ID_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    check_run_id: str
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., check_run_id: _Optional[str] = ...) -> None: ...

class GetCheckRunResponse(_message.Message):
    __slots__ = ()
    CHECK_RUN_FIELD_NUMBER: _ClassVar[int]
    check_run: _governance_pb2.CheckRun
    def __init__(self, check_run: _Optional[_Union[_governance_pb2.CheckRun, _Mapping]] = ...) -> None: ...

class ListGovernanceAlertsRequest(_message.Message):
    __slots__ = ()
    CONTEXT_FIELD_NUMBER: _ClassVar[int]
    ORGANIZATION_ID_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_ID_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    context: _common_pb2.RequestContext
    organization_id: str
    transformation_id: str
    pagination: _common_pb2.PaginationRequest
    def __init__(self, context: _Optional[_Union[_common_pb2.RequestContext, _Mapping]] = ..., organization_id: _Optional[str] = ..., transformation_id: _Optional[str] = ..., pagination: _Optional[_Union[_common_pb2.PaginationRequest, _Mapping]] = ...) -> None: ...

class ListGovernanceAlertsResponse(_message.Message):
    __slots__ = ()
    ALERTS_FIELD_NUMBER: _ClassVar[int]
    PAGINATION_FIELD_NUMBER: _ClassVar[int]
    alerts: _containers.RepeatedCompositeFieldContainer[_governance_pb2.GovernanceAlert]
    pagination: _common_pb2.PaginationResponse
    def __init__(self, alerts: _Optional[_Iterable[_Union[_governance_pb2.GovernanceAlert, _Mapping]]] = ..., pagination: _Optional[_Union[_common_pb2.PaginationResponse, _Mapping]] = ...) -> None: ...
