from __future__ import annotations

import sys
from importlib import metadata as _metadata

from .config import RetryConfig, SDKOptions, TelemetryConfig
from .element_service import ElementService, create_element_service
from .errors import AmeideRpcError, RpcErrorCategory, normalize_error


try:
    __version__ = _metadata.version("ameide-sdk-python")
except _metadata.PackageNotFoundError:  # pragma: no cover - fallback for editable installs
    __version__ = "0.0.0"


def __getattr__(name: str):
    if name == "AmeideClient":
        from .client import AmeideClient

        return AmeideClient
    raise AttributeError(name)


__all__ = [
    "AmeideClient",
    "SDKOptions",
    "RetryConfig",
    "TelemetryConfig",
    "AmeideRpcError",
    "RpcErrorCategory",
    "normalize_error",
    "ElementService",
    "create_element_service",
    "__version__",
]
