#!/usr/bin/env python3

from pathlib import Path

from setuptools import find_namespace_packages, setup

ROOT = Path(__file__).parent


def read_version() -> str:
    version_file = ROOT / "VERSION"
    if not version_file.exists():
        raise RuntimeError(f"VERSION file missing at {version_file}")
    return version_file.read_text(encoding="utf-8").strip()


setup(
    name="ameide-sdk-python",
    version=read_version(),
    description="Official AMEIDE Python SDK",
    author="AMEIDE Team",
    author_email="team@ameide.io",
    packages=find_namespace_packages(
        where="src",
        include=["ameide_sdk", "ameide_sdk.*", "buf", "buf.*"],
    ),
    package_dir={"": "src"},
    include_package_data=True,
    install_requires=[
        "grpcio>=1.65.5",
        "protobuf>=5.28.0",
        "opentelemetry-api>=1.26.0",
    ],
    python_requires=">=3.12",
)
