from importlib import metadata as _metadata

from .config import SDKOptions, RetryConfig, TelemetryConfig
from .errors import AmeideRpcError, RpcErrorCategory, normalize_error

try:
    __version__ = _metadata.version("ameide-sdk-python")
except _metadata.PackageNotFoundError:  # pragma: no cover - fallback for editable installs
    __version__ = "0.0.0"

def __getattr__(name: str):
    if name == "AmeideClient":
        from .client import AmeideClient
        return AmeideClient
    raise AttributeError(name)


__all__ = [
    "AmeideClient",
    "SDKOptions",
    "RetryConfig",
    "TelemetryConfig",
    "AmeideRpcError",
    "RpcErrorCategory",
    "normalize_error",
    "__version__",
]
