
import importlib
from typing import Any


def import_class(class_path):
    module_name, class_name = class_path.rsplit(".", 1)
    module = importlib.import_module(module_name)
    return getattr(module, class_name)

def document_loader(reader_type: str) -> Any:
    mapping = {
                "airtable": "dotagent.knowledgebase.document_loaders.airtable.base.AirtableReader",
                "apify_dataset": "dotagent.knowledgebase.document_loaders.apify.dataset.base.ApifyDataset",
                "asana": "dotagent.knowledgebase.document_loaders.asana.base.AsanaReader",
                "azcognitive_search": "dotagent.knowledgebase.document_loaders.azcognitive_search.base.AzCognitiveSearchReader",
                "bilibili": "dotagent.knowledgebase.document_loaders.bilibili.base.BilibiliTranscriptReader",
                "boarddocs": "dotagent.knowledgebase.document_loaders.boarddocs.base.BoardDocsReader",
                "chatgpt_plugin": "dotagent.knowledgebase.document_loaders.chatgpt_plugin.base.ChatGPTRetrievalPluginReader",
                "chroma": "dotagent.knowledgebase.document_loaders.chroma.base.ChromaReader",
                "confluence": "dotagent.knowledgebase.document_loaders.confluence.base.ConfluenceReader",
                "couchdb": "dotagent.knowledgebase.document_loaders.couchdb.base.SimpleCouchDBReader",
                "dad_jokes": "dotagent.knowledgebase.document_loaders.dad_jokes.base.DadJokesReader",
                "deep_lake": "dotagent.knowledgebase.document_loaders.deeplake.base.DeepLakeReader",
                "discord": "dotagent.knowledgebase.document_loaders.discord.base.DiscordReader",
                "docugami": "dotagent.knowledgebase.document_loaders.docugami.base.DocugamiReader",
                "elasticsearch": "dotagent.knowledgebase.document_loaders.elasticsearch.base.ElasticsearchReader",
                "faiss": "dotagent.knowledgebase.document_loaders.faiss.base.FaissReader",
                "feedly_rss": "dotagent.knowledgebase.document_loaders.feedly_rss.base.FeedlyRssReader",
                "feishu_docs": "dotagent.knowledgebase.document_loaders.feishu_docs.base.FeishuDocsReader",
                "file_directory": "dotagent.knowledgebase.document_loaders.file.base.SimpleDirectoryReader",
                "file_audio": "dotagent.knowledgebase.document_loaders.file.audio.base.AudioTranscriber",
                "gladia_audio": "dotagent.knowledgebase.document_loaders.file.audio_gladia.base.GladiaAudioTranscriber",
                "file_cjk_pdf": "dotagent.knowledgebase.document_loaders.file.cjk_pdf.base.CJKPDFReader",
                "deep_doctection": "dotagent.knowledgebase.document_loaders.file.deepdoctection.base.DeepDoctectionReader",
                "file_docx": "dotagent.knowledgebase.document_loaders.file.docx.base.DocxReader",
                "file_epub": "dotagent.knowledgebase.document_loaders.file.epub.base.EpubReader",
                "flat_pdf": "dotagent.knowledgebase.document_loaders.file.flat_pdf.base.FlatPdfReader",
                "image": "dotagent.knowledgebase.document_loaders.file.image.base.ImageReader",
                "image_caption": "dotagent.knowledgebase.document_loaders.file.image_blip.base.ImageCaptionReader",
                "image_vision": "dotagent.knowledgebase.document_loaders.file.image_blip2.base.ImageVisionLLMReader",
                "image_tabular_chart": "dotagent.knowledgebase.document_loaders.file.image_deplot.base.ImageTabularChartReader",
                "ipynb": "dotagent.knowledgebase.document_loaders.file.ipynb.base.IPYNBReader",
                "json": "dotagent.knowledgebase.document_loaders.file.json.base.JSONReader",
                "markdown": "dotagent.knowledgebase.document_loaders.file.markdown.base.MarkdownReader",
                "mbox": "dotagent.knowledgebase.document_loaders.file.mbox.base.MboxReader",
                "paged_csv": "dotagent.knowledgebase.document_loaders.file.paged_csv.base.PagedCSVReader",
                "pandas_csv": "dotagent.knowledgebase.document_loaders.file.pandas_csv.base.PandasCSVReader",
                "pandas_excel": "dotagent.knowledgebase.document_loaders.file.pandas_excel.base.PandasExcelReader",
                "pdf": "dotagent.knowledgebase.document_loaders.file.pdf.base.PDFReader",
                "pdf_miner": "dotagent.knowledgebase.document_loaders.file.pdf_miner.base.PDFMinerReader",
                "pptx": "dotagent.knowledgebase.document_loaders.file.pptx.base.PptxReader",
                "pymu_pdf": "dotagent.knowledgebase.document_loaders.file.pymu_pdf.base.PyMuPDFReader",
                "rdf": "dotagent.knowledgebase.document_loaders.file.rdf.base.RDFReader",
                "simple_csv": "dotagent.knowledgebase.document_loaders.file.simple_csv.base.SimpleCSVReader",
                "unstructured": "dotagent.knowledgebase.document_loaders.file.unstructured.base.UnstructuredReader",
                "firebase_realtimedb": "dotagent.knowledgebase.document_loaders.firebase_realtimedb.base.FirebaseRealtimeDatabaseReader",
                "firestore": "dotagent.knowledgebase.document_loaders.firestore.base.FirestoreReader",
                "github_repo_issues": "dotagent.knowledgebase.document_loaders.github_repo_issues.base.GitHubRepositoryIssuesReader",
                "gmail": "dotagent.knowledgebase.document_loaders.gmail.base.GmailReader",
                "google_calendar": "dotagent.knowledgebase.document_loaders.google_calendar.base.GoogleCalendarReader",
                "google_docs": "dotagent.knowledgebase.document_loaders.google_docs.base.GoogleDocsReader",
                "google_keep": "dotagent.knowledgebase.document_loaders.google_keep.base.GoogleKeepReader",
                "google_sheets": "dotagent.knowledgebase.document_loaders.google_sheets.base.GoogleSheetsReader",
                "gpt_repo": "dotagent.knowledgebase.document_loaders.gpt_repo.base.GPTRepoReader",
                "graphdb_cypher": "dotagent.knowledgebase.document_loaders.graphdb_cypher.base.GraphDBCypherReader",
                "graphql": "dotagent.knowledgebase.document_loaders.graphql.base.GraphQLReader",
                "hatena_blog": "dotagent.knowledgebase.document_loaders.hatena_blog.base.HatenaBlogReader",
                "hubspot": "dotagent.knowledgebase.document_loaders.hubspot.base.HubspotReader",
                "huggingface_fs": "dotagent.knowledgebase.document_loaders.huggingface.fs.base.HuggingFaceFSReader",
                "intercom": "dotagent.knowledgebase.document_loaders.intercom.base.IntercomReader",
                "jira": "dotagent.knowledgebase.document_loaders.jira.base.JiraReader",
                # "joplin": "dotagent.knowledgebase.document_loaders.joplin.base.JoplinReader",
                "jsondata": "dotagent.knowledgebase.document_loaders.jsondata.base.JSONDataReader",
                "kaltura_esearch": "dotagent.knowledgebase.document_loaders.kaltura.esearch.base.KalturaESearchReader",
                "kibela": "dotagent.knowledgebase.document_loaders.kibela.base.KibelaReader",
                # "make_com": "dotagent.knowledgebase.document_loaders.make_com.base.MakeWrapper",
                "mangoapps_guides": "dotagent.knowledgebase.document_loaders.mangoapps_guides.base.MangoppsGuidesReader",
                "maps": "dotagent.knowledgebase.document_loaders.maps.base.OpenMap",
                "memos": "dotagent.knowledgebase.document_loaders.memos.base.MemosReader",
                "metal": "dotagent.knowledgebase.document_loaders.metal.base.MetalReader",
                "milvus": "dotagent.knowledgebase.document_loaders.milvus.base.MilvusReader",
                "mondaydotcom": "dotagent.knowledgebase.document_loaders.mondaydotcom.base.MondayReader",
                "mongo": "dotagent.knowledgebase.document_loaders.mongo.base.SimpleMongoReader",
                "notion": "dotagent.knowledgebase.document_loaders.notion.base.NotionPageReader",
                "obsidian": "dotagent.knowledgebase.document_loaders.obsidian.base.ObsidianReader",
                "opendal": "dotagent.knowledgebase.document_loaders.opendal_reader.base.OpendalReader",
                "opendal_azblob": "dotagent.knowledgebase.document_loaders.opendal_reader.azblob.base.OpendalAzblobReader",
                "opendal_gcs": "dotagent.knowledgebase.document_loaders.opendal_reader.gcs.base.OpendalGcsReader",
                "opendal_s3": "dotagent.knowledgebase.document_loaders.opendal_reader.s3.base.OpendalS3Reader",
                "outlook_localcalendar": "dotagent.knowledgebase.document_loaders.outlook_localcalendar.base.OutlookLocalCalendarReader",
                "pubmed": "dotagent.knowledgebase.document_loaders.papers.pubmed.base.PubmedReader",
                "pinecone": "dotagent.knowledgebase.document_loaders.pinecone.base.PineconeReader",
                "qdrant": "dotagent.knowledgebase.document_loaders.qdrant.base.QdrantReader",
                "readwise": "dotagent.knowledgebase.document_loaders.readwise.base.ReadwiseReader",
                "reddit": "dotagent.knowledgebase.document_loaders.reddit.base.RedditReader",
                "slack": "dotagent.knowledgebase.document_loaders.slack.base.SlackReader",
                "snscrape_twitter": "dotagent.knowledgebase.document_loaders.snscrape_twitter.base.SnscrapeTwitterReader",
                "spotify": "dotagent.knowledgebase.document_loaders.spotify.base.SpotifyReader",
                "stackoverflow": "dotagent.knowledgebase.document_loaders.stackoverflow.base.StackoverflowReader",
                "steamship": "dotagent.knowledgebase.document_loaders.steamship.base.SteamshipFileReader",
                "string_iterable": "dotagent.knowledgebase.document_loaders.string_iterable.base.StringIterableReader",
                "trello": "dotagent.knowledgebase.document_loaders.trello.base.TrelloReader",
                "twitter": "dotagent.knowledgebase.document_loaders.twitter.base.TwitterTweetReader",
                "weather": "dotagent.knowledgebase.document_loaders.weather.base.WeatherReader",
                "weaviate": "dotagent.knowledgebase.document_loaders.weaviate.base.WeaviateReader",
                "async_web": "dotagent.knowledgebase.document_loaders.web.async_web.base.AsyncWebPageReader",
                "beautiful_soup_web": "dotagent.knowledgebase.document_loaders.web.beautiful_soup_web.base.BeautifulSoupWebReader",
                "knowledge_base_web": "dotagent.knowledgebase.document_loaders.web.knowledge_base.base.KnowledgeBaseWebReader",
                # "readability_web": "dotagent.knowledgebase.document_loaders.web.readability_web.base.ReadabilityWebPageReader",
                "rss": "dotagent.knowledgebase.document_loaders.web.rss.base.RssReader",
                "simple_web": "dotagent.knowledgebase.document_loaders.web.simple_web.base.SimpleWebPageReader",
                # "sitemap": "dotagent.knowledgebase.document_loaders.web.sitemap.base.SitemapReader",
                "trafilatura_web": "dotagent.knowledgebase.document_loaders.web.trafilatura_web.base.TrafilaturaWebReader",
                "unstructured_web": "dotagent.knowledgebase.document_loaders.web.unstructured_web.base.UnstructuredURLLoader",
                "whatsapp": "dotagent.knowledgebase.document_loaders.whatsapp.base.WhatsappChatLoader",
                "wikipedia": "dotagent.knowledgebase.document_loaders.wikipedia.base.WikipediaReader",
                "wordlift": "dotagent.knowledgebase.document_loaders.wordlift.base.WordLiftLoader",
                "wordpress": "dotagent.knowledgebase.document_loaders.wordpress.base.WordpressReader",
                "youtube_transcript": "dotagent.knowledgebase.document_loaders.youtube_transcript.base.YoutubeTranscriptReader",
                "zendesk": "dotagent.knowledgebase.document_loaders.zendesk.base.ZendeskReader",
                "zulip": "dotagent.knowledgebase.document_loaders.zulip.base.ZulipReader",
}
    reader_class = import_class(mapping[reader_type])
    return reader_class