from os import path

from setuptools import find_packages, setup

# Получаем длинное описание из README.md
this_directory = path.abspath(path.dirname(__file__))
with open(path.join(this_directory, 'README.md'), encoding = 'utf-8') as f:
    long_description = f.read()

setup(
        name = 'anb_python_components',
        version = '1.3.0',
        description = 'Набор компонентов Python, которые упрощают разработку / A set of Python components that simplify development',
        long_description = long_description,
        long_description_content_type = 'text/markdown',
        author = 'Александр Бабаев',
        author_email = 'contact_with_us@babaev-an.ru',
        url = 'https://gitflic.ru/project/babaev-an/anb-python-components',
        packages = find_packages(),
        install_requires = [],
        python_requires = '>=3.14.0',
        classifiers = [
                'Development Status :: 5 - Production/Stable',
                'Intended Audience :: Developers',
                'License :: OSI Approved :: MIT License',
                'Programming Language :: Python :: 3',
                'Programming Language :: Python :: 3.14',
                'Operating System :: OS Independent',
                'Topic :: Software Development :: Libraries :: Python Modules',
                ],
        keywords = 'python components development utils',
        project_urls = {
                'Documentation': 'https://gitflic.ru/project/babaev-an/anb-python-components/wiki',
                'Source': 'https://gitflic.ru/project/babaev-an/anb-python-components',
                'Tracker': 'https://gitflic.ru/project/babaev-an/anb-python-components/issue?page=0',
                },
        zip_safe = False,
        )