# anb_python_components/enums/not_bool_action.py

from enum import Enum

class NotBoolAction(Enum):
    """
    Перечисление типов действий, которые необходимо выполнить, если переменная не является булевым типом.
    - IGNORE: Игнорировать это утверждение.
    - IT_TRUE: Считать это утверждение истинным.
    - IT_FALSE: Считать это утверждение ложным.
    - RAISE: Вызвать исключение.
    """
    
    # Игнорировать это утверждение.
    IGNORE = 0
    
    # Считать это утверждение истинным.
    IT_TRUE = 1
    
    # Считать это утверждение ложным.
    IT_FALSE = 2
    
    # Вызвать исключение
    RAISE = 3