# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon5gmecvnspapi.api_helper import APIHelper
from verizon5gmecvnspapi.configuration import Server
from verizon5gmecvnspapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon5gmecvnspapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from apimatic_core.authentication.multiple.and_auth_group import And
from apimatic_core.authentication.multiple.or_auth_group import Or
from verizon5gmecvnspapi.models.edge_service_onboarding_delete_result import EdgeServiceOnboardingDeleteResult
from verizon5gmecvnspapi.models.csp_profile import CSPProfile
from verizon5gmecvnspapi.models.csp_profile_data import CSPProfileData
from verizon5gmecvnspapi.exceptions.edge_service_onboarding_result_error_exception import EdgeServiceOnboardingResultErrorException


class CSPProfilesController(BaseController):

    """A Controller to access Endpoints in the verizon5gmecvnspapi API."""
    def __init__(self, config):
        super(CSPProfilesController, self).__init__(config)

    def remove_cloud_credential(self,
                                account_name,
                                id,
                                correlation_id=None):
        """Does a DELETE request to /v1/cspProfiles/{id}.

        Remove a cloud credential from user's organization.

        Args:
            account_name (string): User account name.
            id (string): CSP Profile Id.
            correlation_id (string, optional): TODO: type description here.

        Returns:
            EdgeServiceOnboardingDeleteResult: Response from the API. OK.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVICES)
            .path('/v1/cspProfiles/{id}')
            .http_method(HttpMethodEnum.DELETE)
            .header_param(Parameter()
                          .key('AccountName')
                          .value(account_name))
            .template_param(Parameter()
                            .key('id')
                            .value(id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('correlationId')
                          .value(correlation_id))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('global'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(EdgeServiceOnboardingDeleteResult.from_dictionary)
            .local_error('401', 'Unauthorized.', EdgeServiceOnboardingResultErrorException)
            .local_error('404', 'Not Found.', EdgeServiceOnboardingResultErrorException)
            .local_error('500', 'Internal Server Error.', EdgeServiceOnboardingResultErrorException)
        ).execute()

    def create_cloud_credential(self,
                                account_name,
                                body,
                                correlation_id=None):
        """Does a POST request to /v1/cspProfiles/.

        Create a new cloud credential within user's organization.

        Args:
            account_name (string): User account name.
            body (CSPProfile): TODO: type description here.
            correlation_id (string, optional): TODO: type description here.

        Returns:
            CSPProfile: Response from the API. Created.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVICES)
            .path('/v1/cspProfiles/')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('AccountName')
                          .value(account_name))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('correlationId')
                          .value(correlation_id))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('global'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(CSPProfile.from_dictionary)
            .local_error('400', 'Bad Request.', EdgeServiceOnboardingResultErrorException)
            .local_error('401', 'Unauthorized.', EdgeServiceOnboardingResultErrorException)
            .local_error('403', 'Forbidden.', EdgeServiceOnboardingResultErrorException)
            .local_error('429', 'Too many requests.', EdgeServiceOnboardingResultErrorException)
            .local_error('500', 'Internal Server Error.', EdgeServiceOnboardingResultErrorException)
            .local_error('default', 'Forbidden.', EdgeServiceOnboardingResultErrorException)
        ).execute()

    def fetch_cloud_credential_details(self,
                                       account_name,
                                       correlation_id=None,
                                       q=None,
                                       limit=None,
                                       off_set=None):
        """Does a GET request to /v1/cspProfiles/.

        Fetch available cloud credentials within user's organization.

        Args:
            account_name (string): User account name.
            correlation_id (string, optional): TODO: type description here.
            q (string, optional): Use the coloumn (:) character to separate
                multiple query params eg
                type=AWS:awsCspProfile.credType=ACCESS_KEY,ROLE_ARN:state=UNVER
                IFIED,VERIFIED.
            limit (long|int, optional): Number of items to return.
            off_set (long|int, optional): Id of the last respose value in the
                previous list.

        Returns:
            CSPProfileData: Response from the API. OK.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVICES)
            .path('/v1/cspProfiles/')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('AccountName')
                          .value(account_name))
            .header_param(Parameter()
                          .key('correlationId')
                          .value(correlation_id))
            .query_param(Parameter()
                         .key('q')
                         .value(q))
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .query_param(Parameter()
                         .key('offSet')
                         .value(off_set))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('global'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(CSPProfileData.from_dictionary)
            .local_error('401', 'Unauthorized.', EdgeServiceOnboardingResultErrorException)
            .local_error('403', 'Forbidden.', EdgeServiceOnboardingResultErrorException)
            .local_error('404', 'Not found.', EdgeServiceOnboardingResultErrorException)
            .local_error('429', 'Too many requests.', EdgeServiceOnboardingResultErrorException)
            .local_error('500', 'Internal Server Error.', EdgeServiceOnboardingResultErrorException)
            .local_error('default', 'Forbidden.', EdgeServiceOnboardingResultErrorException)
        ).execute()
