# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon5gmecvnspapi.api_helper import APIHelper
from verizon5gmecvnspapi.configuration import Server
from verizon5gmecvnspapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon5gmecvnspapi.http.http_method_enum import HttpMethodEnum
from apimatic_core.authentication.multiple.single_auth import Single
from apimatic_core.authentication.multiple.and_auth_group import And
from apimatic_core.authentication.multiple.or_auth_group import Or
from verizon5gmecvnspapi.models.service_claims import ServiceClaims
from verizon5gmecvnspapi.models.associate_cloud_credential_result import AssociateCloudCredentialResult
from verizon5gmecvnspapi.exceptions.edge_service_onboarding_result_error_exception import EdgeServiceOnboardingResultErrorException


class ServiceClaimsController(BaseController):

    """A Controller to access Endpoints in the verizon5gmecvnspapi API."""
    def __init__(self, config):
        super(ServiceClaimsController, self).__init__(config)

    def list_service_claims(self,
                            account_name,
                            service_id,
                            correlation_id=None,
                            claim_status=None,
                            q=None,
                            limit=None,
                            off_set=None,
                            sort_key='createdDate',
                            sort_dir=None,
                            details_flag=True):
        """Does a GET request to /v1/service/{serviceId}/claims.

        Fetch all service's claim(s) associated with a service. Service claims
        are generated based on service's compatibility with different cloud
        service provider.

        Args:
            account_name (string): User account name.
            service_id (string): Auto-generated Id of the claim whose
                information needs to be fetched.
            correlation_id (string, optional): TODO: type description here.
            claim_status (string, optional): Queries with claim status on the
                claims.
            q (string, optional): Use the comma (,) character to separate
                multiple values,eg claimType=Public
                MEC:claims.sandBoxState=NOT_STARTED,STARTED.
            limit (long|int, optional): Number of items to return.
            off_set (long|int, optional): Id of the last respose value in the
                previous list.
            sort_key (string, optional): Sorts the response by an attribute.
                Default is createdDate.
            sort_dir (SortDirectionEnum, optional): Sorts the response. Use
                asc for ascending or desc for descending order. The default is
                desc.
            details_flag (bool, optional): Default as true. If it is true then
                it will return all details.

        Returns:
            ServiceClaims: Response from the API. OK.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVICES)
            .path('/v1/service/{serviceId}/claims')
            .http_method(HttpMethodEnum.GET)
            .header_param(Parameter()
                          .key('AccountName')
                          .value(account_name))
            .template_param(Parameter()
                            .key('serviceId')
                            .value(service_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('correlationId')
                          .value(correlation_id))
            .query_param(Parameter()
                         .key('claimStatus')
                         .value(claim_status))
            .query_param(Parameter()
                         .key('q')
                         .value(q))
            .query_param(Parameter()
                         .key('limit')
                         .value(limit))
            .query_param(Parameter()
                         .key('offSet')
                         .value(off_set))
            .query_param(Parameter()
                         .key('sortKey')
                         .value(sort_key))
            .query_param(Parameter()
                         .key('sortDir')
                         .value(sort_dir))
            .query_param(Parameter()
                         .key('detailsFlag')
                         .value(details_flag))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .auth(Single('global'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(ServiceClaims.from_dictionary)
            .local_error('400', 'Bad request.', EdgeServiceOnboardingResultErrorException)
            .local_error('401', 'Unauthorized.', EdgeServiceOnboardingResultErrorException)
            .local_error('404', 'Not found.', EdgeServiceOnboardingResultErrorException)
            .local_error('500', 'Internal Server Error.', EdgeServiceOnboardingResultErrorException)
        ).execute()

    def associate_cloud_credential_with_service_claim(self,
                                                      account_name,
                                                      service_id,
                                                      claim_id,
                                                      body,
                                                      correlation_id=None):
        """Does a POST request to /v1/services/{serviceId}/claims/{claimId}/associateCspProfile.

        Associate an existing cloud credential with a service's claim which
        will be used to connect to user's cloud provider.

        Args:
            account_name (string): User account name.
            service_id (string): System generated unique identifier of the
                service which user is using.
            claim_id (string): System generated unique identifier for the
                claim which user is using.
            body (CSPProfileIdRequest): TODO: type description here.
            correlation_id (string, optional): TODO: type description here.

        Returns:
            AssociateCloudCredentialResult: Response from the API. OK.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVICES)
            .path('/v1/services/{serviceId}/claims/{claimId}/associateCspProfile')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('AccountName')
                          .value(account_name))
            .template_param(Parameter()
                            .key('serviceId')
                            .value(service_id)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('claimId')
                            .value(claim_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('correlationId')
                          .value(correlation_id))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('global'))
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(AssociateCloudCredentialResult.from_dictionary)
            .local_error('400', 'Bad request.', EdgeServiceOnboardingResultErrorException)
            .local_error('401', 'Unauthorized.', EdgeServiceOnboardingResultErrorException)
            .local_error('404', 'Not Found.', EdgeServiceOnboardingResultErrorException)
            .local_error('500', 'Internal Server Error.', EdgeServiceOnboardingResultErrorException)
        ).execute()

    def update_service_claim_status(self,
                                    account_name,
                                    service_id,
                                    claim_id,
                                    body,
                                    correlation_id=None):
        """Does a POST request to /v1/services/{serviceId}/claims/{claimId}/claimStatus.

        Using this API user can update service's claim status as
        complete/verified etc.

        Args:
            account_name (string): User account name.
            service_id (string): System generated unique identifier of the
                service which user is using.
            claim_id (string): System generated unique identifier of the claim
                which user is using.
            body (ClaimStatusRequest): TODO: type description here.
            correlation_id (string, optional): TODO: type description here.

        Returns:
            void: Response from the API. OK.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVICES)
            .path('/v1/services/{serviceId}/claims/{claimId}/claimStatus')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('AccountName')
                          .value(account_name))
            .template_param(Parameter()
                            .key('serviceId')
                            .value(service_id)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('claimId')
                            .value(claim_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('Content-Type')
                          .value('application/json'))
            .body_param(Parameter()
                        .value(body))
            .header_param(Parameter()
                          .key('correlationId')
                          .value(correlation_id))
            .body_serializer(APIHelper.json_serialize)
            .auth(Single('global'))
        ).execute()

    def mark_service_claim_status_as_completed(self,
                                               account_name,
                                               service_id,
                                               claim_id,
                                               correlation_id=None):
        """Does a POST request to /v1/services/{serviceId}/claims/{claimId}/claimStatusCompleted.

        Mark a service's claim status as complete post successful verification
        of sandbox testing in the respective sandbox environment.

        Args:
            account_name (string): User account name.
            service_id (string): System generated unique identifier of the
                service which user is using.
            claim_id (string): System generated unique identifier of the claim
                which user is using.
            correlation_id (string, optional): TODO: type description here.

        Returns:
            void: Response from the API. OK.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.SERVICES)
            .path('/v1/services/{serviceId}/claims/{claimId}/claimStatusCompleted')
            .http_method(HttpMethodEnum.POST)
            .header_param(Parameter()
                          .key('AccountName')
                          .value(account_name))
            .template_param(Parameter()
                            .key('serviceId')
                            .value(service_id)
                            .should_encode(True))
            .template_param(Parameter()
                            .key('claimId')
                            .value(claim_id)
                            .should_encode(True))
            .header_param(Parameter()
                          .key('correlationId')
                          .value(correlation_id))
            .auth(Single('global'))
        ).execute()
