# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper


class AwsCspProfile(object):

    """Implementation of the 'AwsCspProfile' model.

    Information related to manage resources in AWS infrastructure.

    Attributes:
        cred_type (AwsCspProfileCredTypeEnum): Credential type of AWS CSP
            profile.
        access_key (string): AWS Access Key.
        secret_key (string): AWS Secret Key.
        role_arn (string): CSP AWS Role ARN.
        account_id (string): AWS account ID.
        external_id (string): AWS external ID.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "cred_type": 'credType',
        "access_key": 'accessKey',
        "secret_key": 'secretKey',
        "role_arn": 'roleARN',
        "account_id": 'accountId',
        "external_id": 'externalId'
    }

    _optionals = [
        'cred_type',
        'access_key',
        'secret_key',
        'role_arn',
        'account_id',
        'external_id',
    ]

    def __init__(self,
                 cred_type=APIHelper.SKIP,
                 access_key=APIHelper.SKIP,
                 secret_key=APIHelper.SKIP,
                 role_arn=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 external_id=APIHelper.SKIP):
        """Constructor for the AwsCspProfile class"""

        # Initialize members of the class
        if cred_type is not APIHelper.SKIP:
            self.cred_type = cred_type 
        if access_key is not APIHelper.SKIP:
            self.access_key = access_key 
        if secret_key is not APIHelper.SKIP:
            self.secret_key = secret_key 
        if role_arn is not APIHelper.SKIP:
            self.role_arn = role_arn 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if external_id is not APIHelper.SKIP:
            self.external_id = external_id 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        cred_type = dictionary.get("credType") if dictionary.get("credType") else APIHelper.SKIP
        access_key = dictionary.get("accessKey") if dictionary.get("accessKey") else APIHelper.SKIP
        secret_key = dictionary.get("secretKey") if dictionary.get("secretKey") else APIHelper.SKIP
        role_arn = dictionary.get("roleARN") if dictionary.get("roleARN") else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        external_id = dictionary.get("externalId") if dictionary.get("externalId") else APIHelper.SKIP
        # Return an object of this model
        return cls(cred_type,
                   access_key,
                   secret_key,
                   role_arn,
                   account_id,
                   external_id)
