# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper
from verizon5gmecvnspapi.models.csp_profile import CSPProfile


class CSPProfileData(object):

    """Implementation of the 'CSPProfileData' model.

    Response to CSP profile list.

    Attributes:
        count (int): Total number of records available.
        csp_profile_list (list of CSPProfile): List of all available CSP
            profile available within the user's organization.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "count": 'count',
        "csp_profile_list": 'cspProfileList'
    }

    _optionals = [
        'count',
        'csp_profile_list',
    ]

    def __init__(self,
                 count=APIHelper.SKIP,
                 csp_profile_list=APIHelper.SKIP):
        """Constructor for the CSPProfileData class"""

        # Initialize members of the class
        if count is not APIHelper.SKIP:
            self.count = count 
        if csp_profile_list is not APIHelper.SKIP:
            self.csp_profile_list = csp_profile_list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        count = dictionary.get("count") if dictionary.get("count") else APIHelper.SKIP
        csp_profile_list = None
        if dictionary.get('cspProfileList') is not None:
            csp_profile_list = [CSPProfile.from_dictionary(x) for x in dictionary.get('cspProfileList')]
        else:
            csp_profile_list = APIHelper.SKIP
        # Return an object of this model
        return cls(count,
                   csp_profile_list)
