# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper


class DefaultLocation(object):

    """Implementation of the 'DefaultLocation' model.

    Default location where service needs to be deployed.

    Attributes:
        region (string): CSP region where service needs to be deployed.
        zone (string): Zone within a region where service needs to be
            deployed.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "region": 'region',
        "zone": 'zone'
    }

    _optionals = [
        'region',
        'zone',
    ]

    def __init__(self,
                 region=APIHelper.SKIP,
                 zone=APIHelper.SKIP):
        """Constructor for the DefaultLocation class"""

        # Initialize members of the class
        if region is not APIHelper.SKIP:
            self.region = region 
        if zone is not APIHelper.SKIP:
            self.zone = zone 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        region = dictionary.get("region") if dictionary.get("region") else APIHelper.SKIP
        zone = dictionary.get("zone") if dictionary.get("zone") else APIHelper.SKIP
        # Return an object of this model
        return cls(region,
                   zone)
