# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper


class ServiceDependency(object):

    """Implementation of the 'ServiceDependency' model.

    Dependency of the service.

    Attributes:
        rank (int): The dependency rank.
        mtype (ServiceTypeEnum): Service Type e.g. Installation, Operations,
            Custom.
        service_name (string): Name of the dependent service.
        version (string): Version of the service being used.
        package_type (ServiceDependencyPackageTypeEnum): Deployment package
            type.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "rank": 'rank',
        "mtype": 'type',
        "service_name": 'serviceName',
        "version": 'version',
        "package_type": 'packageType'
    }

    _optionals = [
        'rank',
        'mtype',
        'service_name',
        'version',
        'package_type',
    ]

    _nullables = [
        'package_type',
    ]

    def __init__(self,
                 rank=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 service_name=APIHelper.SKIP,
                 version=APIHelper.SKIP,
                 package_type=APIHelper.SKIP):
        """Constructor for the ServiceDependency class"""

        # Initialize members of the class
        if rank is not APIHelper.SKIP:
            self.rank = rank 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if service_name is not APIHelper.SKIP:
            self.service_name = service_name 
        if version is not APIHelper.SKIP:
            self.version = version 
        if package_type is not APIHelper.SKIP:
            self.package_type = package_type 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        rank = dictionary.get("rank") if dictionary.get("rank") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        service_name = dictionary.get("serviceName") if dictionary.get("serviceName") else APIHelper.SKIP
        version = dictionary.get("version") if dictionary.get("version") else APIHelper.SKIP
        package_type = dictionary.get("packageType") if "packageType" in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(rank,
                   mtype,
                   service_name,
                   version,
                   package_type)
