# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper


class ServiceError(object):

    """Implementation of the 'ServiceError' model.

    Errors related to service.

    Attributes:
        error_category (string): Category defined under which the error
            falls.
        error_code (string): Error Code is required.
        error_desc (string): Error description is required.
        error_subcategory (string): Sub-category of the error defined.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "error_category": 'errorCategory',
        "error_code": 'errorCode',
        "error_desc": 'errorDesc',
        "error_subcategory": 'errorSubcategory'
    }

    _optionals = [
        'error_category',
        'error_code',
        'error_desc',
        'error_subcategory',
    ]

    def __init__(self,
                 error_category=APIHelper.SKIP,
                 error_code=APIHelper.SKIP,
                 error_desc=APIHelper.SKIP,
                 error_subcategory=APIHelper.SKIP):
        """Constructor for the ServiceError class"""

        # Initialize members of the class
        if error_category is not APIHelper.SKIP:
            self.error_category = error_category 
        if error_code is not APIHelper.SKIP:
            self.error_code = error_code 
        if error_desc is not APIHelper.SKIP:
            self.error_desc = error_desc 
        if error_subcategory is not APIHelper.SKIP:
            self.error_subcategory = error_subcategory 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        error_category = dictionary.get("errorCategory") if dictionary.get("errorCategory") else APIHelper.SKIP
        error_code = dictionary.get("errorCode") if dictionary.get("errorCode") else APIHelper.SKIP
        error_desc = dictionary.get("errorDesc") if dictionary.get("errorDesc") else APIHelper.SKIP
        error_subcategory = dictionary.get("errorSubcategory") if dictionary.get("errorSubcategory") else APIHelper.SKIP
        # Return an object of this model
        return cls(error_category,
                   error_code,
                   error_desc,
                   error_subcategory)
