# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper


class Tag(object):

    """Implementation of the 'Tag' model.

    Any name for the tag.

    Attributes:
        id (string): Id of the user creating the repository.
        key (string): Key properties/metadata attribute.
        description (string): Description for the repository being created.
        value (string): Properties/metadata value attribute.
        created_date (datetime): Date when the repository was created.
        last_modified_date (datetime): Date when the repository was updated.
        created_by (string): User information by whom the repository was
            created.
        updated_by (string): User information by whom the repository was
            updated.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "key": 'key',
        "id": 'id',
        "description": 'description',
        "value": 'value',
        "created_date": 'createdDate',
        "last_modified_date": 'lastModifiedDate',
        "created_by": 'createdBy',
        "updated_by": 'updatedBy'
    }

    _optionals = [
        'id',
        'description',
        'value',
        'created_date',
        'last_modified_date',
        'created_by',
        'updated_by',
    ]

    def __init__(self,
                 key=None,
                 id=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 value=APIHelper.SKIP,
                 created_date=APIHelper.SKIP,
                 last_modified_date=APIHelper.SKIP,
                 created_by=APIHelper.SKIP,
                 updated_by=APIHelper.SKIP):
        """Constructor for the Tag class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        self.key = key 
        if description is not APIHelper.SKIP:
            self.description = description 
        if value is not APIHelper.SKIP:
            self.value = value 
        if created_date is not APIHelper.SKIP:
            self.created_date = APIHelper.RFC3339DateTime(created_date) if created_date else None 
        if last_modified_date is not APIHelper.SKIP:
            self.last_modified_date = APIHelper.RFC3339DateTime(last_modified_date) if last_modified_date else None 
        if created_by is not APIHelper.SKIP:
            self.created_by = created_by 
        if updated_by is not APIHelper.SKIP:
            self.updated_by = updated_by 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        key = dictionary.get("key") if dictionary.get("key") else None
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        value = dictionary.get("value") if dictionary.get("value") else APIHelper.SKIP
        created_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("createdDate")).datetime if dictionary.get("createdDate") else APIHelper.SKIP
        last_modified_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("lastModifiedDate")).datetime if dictionary.get("lastModifiedDate") else APIHelper.SKIP
        created_by = dictionary.get("createdBy") if dictionary.get("createdBy") else APIHelper.SKIP
        updated_by = dictionary.get("updatedBy") if dictionary.get("updatedBy") else APIHelper.SKIP
        # Return an object of this model
        return cls(key,
                   id,
                   description,
                   value,
                   created_date,
                   last_modified_date,
                   created_by,
                   updated_by)
