# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from enum import Enum
from verizon5gmecvnspapi.api_helper import APIHelper
from apimatic_core.http.configurations.http_client_configuration import HttpClientConfiguration
from apimatic_requests_client_adapter.requests_client import RequestsClient
from verizon5gmecvnspapi.models.o_auth_token import OAuthToken


class Environment(Enum):
    """An enum for SDK environments"""
    PRODUCTION = 0
    STAGING = 1


class Server(Enum):
    """An enum for API servers"""
    SERVICES = 0
    OAUTH_SERVER = 1


class Configuration(HttpClientConfiguration):
    """A class used for configuring the SDK by a user.
    """

    @property
    def environment(self):
        return self._environment

    @property
    def o_auth_client_id(self):
        return self._o_auth_client_id

    @property
    def o_auth_client_secret(self):
        return self._o_auth_client_secret

    @property
    def o_auth_scopes(self):
        return self._o_auth_scopes

    @property
    def vz_m_2_m_token(self):
        return self._vz_m_2_m_token

    @property
    def o_auth_token(self):
        if type(self._o_auth_token) is OAuthToken:
            return OAuthToken.from_dictionary(APIHelper.to_dictionary(self._o_auth_token))
        else:
            return self._o_auth_token

    def __init__(
        self, http_client_instance=None,
        override_http_client_configuration=False, http_call_back=None,
        timeout=60, max_retries=0, backoff_factor=2,
        retry_statuses=[408, 413, 429, 500, 502, 503, 504, 521, 522, 524],
        retry_methods=['GET', 'PUT'], environment=Environment.PRODUCTION,
        o_auth_client_id='TODO: Replace', o_auth_client_secret='TODO: Replace',
        o_auth_token=None, o_auth_scopes=None, vz_m_2_m_token='TODO: Replace'
    ):
        super().__init__(http_client_instance, override_http_client_configuration, http_call_back, timeout, max_retries,
                         backoff_factor, retry_statuses, retry_methods)
        # Current API environment
        self._environment = environment

        # OAuth 2 Client ID
        self._o_auth_client_id = o_auth_client_id

        # OAuth 2 Client Secret
        self._o_auth_client_secret = o_auth_client_secret

        # Object for storing information about the OAuth token
        if type(o_auth_token) is OAuthToken:
            self._o_auth_token = OAuthToken.from_dictionary(APIHelper.to_dictionary(o_auth_token))
        else:
            self._o_auth_token = o_auth_token

        # TODO: Replace
        self._o_auth_scopes = o_auth_scopes

        # M2M Session Token
        self._vz_m_2_m_token = vz_m_2_m_token

        # The Http Client to use for making requests.
        super().set_http_client(self.create_http_client())

    def clone_with(self, http_client_instance=None,
                   override_http_client_configuration=None, http_call_back=None,
                   timeout=None, max_retries=None, backoff_factor=None,
                   retry_statuses=None, retry_methods=None, environment=None,
                   o_auth_client_id=None, o_auth_client_secret=None,
                   o_auth_token=None, o_auth_scopes=None, vz_m_2_m_token=None):
        http_client_instance = http_client_instance or super().http_client_instance
        override_http_client_configuration = override_http_client_configuration or super().override_http_client_configuration
        http_call_back = http_call_back or super().http_callback
        timeout = timeout or super().timeout
        max_retries = max_retries or super().max_retries
        backoff_factor = backoff_factor or super().backoff_factor
        retry_statuses = retry_statuses or super().retry_statuses
        retry_methods = retry_methods or super().retry_methods
        environment = environment or self.environment
        o_auth_client_id = o_auth_client_id or self.o_auth_client_id
        o_auth_client_secret = o_auth_client_secret or self.o_auth_client_secret
        o_auth_token = o_auth_token or self.o_auth_token
        o_auth_scopes = o_auth_scopes or self.o_auth_scopes
        vz_m_2_m_token = vz_m_2_m_token or self.vz_m_2_m_token
        return Configuration(
            http_client_instance=http_client_instance,
            override_http_client_configuration=override_http_client_configuration,
            http_call_back=http_call_back, timeout=timeout,
            max_retries=max_retries, backoff_factor=backoff_factor,
            retry_statuses=retry_statuses, retry_methods=retry_methods,
            environment=environment, o_auth_client_id=o_auth_client_id,
            o_auth_client_secret=o_auth_client_secret, o_auth_token=o_auth_token,
            o_auth_scopes=o_auth_scopes, vz_m_2_m_token=vz_m_2_m_token
        )

    def create_http_client(self):
        return RequestsClient(
            timeout=super().timeout, max_retries=super().max_retries,
            backoff_factor=super().backoff_factor, retry_statuses=super().retry_statuses,
            retry_methods=super().retry_methods,
            http_client_instance=super().http_client_instance,
            override_http_client_configuration=super().override_http_client_configuration,
            response_factory=super().http_response_factory
        )

    # All the environments the SDK can run in
    environments = {
        Environment.PRODUCTION: {
            Server.SERVICES: 'https://5gedge.verizon.com/api/mec/services',
            Server.OAUTH_SERVER: 'https://thingspace.verizon.com/api/ts/v1'
        },
        Environment.STAGING: {
            Server.SERVICES: 'https://staging.5gedge.verizon.com/api/mec/services',
            Server.OAUTH_SERVER: 'https://staging.thingspace.verizon.com/api/ts/v1'
        }
    }

    def get_base_uri(self, server=Server.SERVICES):
        """Generates the appropriate base URI for the environment and the
        server.

        Args:
            server (Configuration.Server): The server enum for which the base
            URI is required.

        Returns:
            String: The base URI.

        """
        return self.environments[self.environment][server]
