# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from verizon5gmecvnspapi.api_helper import APIHelper
from verizon5gmecvnspapi.configuration import Server
from verizon5gmecvnspapi.controllers.base_controller import BaseController
from apimatic_core.request_builder import RequestBuilder
from apimatic_core.response_handler import ResponseHandler
from apimatic_core.types.parameter import Parameter
from verizon5gmecvnspapi.http.http_method_enum import HttpMethodEnum
from verizon5gmecvnspapi.models.o_auth_token import OAuthToken
from verizon5gmecvnspapi.exceptions.o_auth_provider_exception import OAuthProviderException


class OAuthAuthorizationController(BaseController):

    """A Controller to access Endpoints in the verizon5gmecvnspapi API."""
    def __init__(self, config):
        super(OAuthAuthorizationController, self).__init__(config)

    def request_token(self,
                      authorization,
                      scope=None,
                      _optional_form_parameters=None):
        """Does a POST request to /oauth2/token.

        Create a new OAuth 2 token.

        Args:
            authorization (string): Authorization header in Basic auth format
            scope (string, optional): Requested scopes as a space-delimited
                list.
            _optional_form_parameters (Array, optional): Additional optional
                form parameters are supported by this endpoint

        Returns:
            OAuthToken: Response from the API.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        return super().new_api_call_builder.request(
            RequestBuilder().server(Server.OAUTH_SERVER)
            .path('/oauth2/token')
            .http_method(HttpMethodEnum.POST)
            .form_param(Parameter()
                        .key('grant_type')
                        .value('client_credentials'))
            .header_param(Parameter()
                          .key('Authorization')
                          .value(authorization))
            .form_param(Parameter()
                        .key('scope')
                        .value(scope))
            .header_param(Parameter()
                          .key('content-type')
                          .value('application/x-www-form-urlencoded'))
            .header_param(Parameter()
                          .key('accept')
                          .value('application/json'))
            .additional_form_params(_optional_form_parameters)
        ).response(
            ResponseHandler()
            .deserializer(APIHelper.json_deserialize)
            .deserialize_into(OAuthToken.from_dictionary)
            .local_error('400', 'OAuth 2 provider returned an error.', OAuthProviderException)
            .local_error('401', 'OAuth 2 provider says client authentication failed.', OAuthProviderException)
        ).execute()
