# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper


class AzureCspProfile(object):

    """Implementation of the 'AzureCspProfile' model.

    Information related to manage resources in Azure infrastructure.

    Attributes:
        tenant_id (string): Azure tenant ID.
        subscription_id (string): Azure subscription ID.
        client_id (string): Azure client ID.
        client_secret (string): Azure client secret.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tenant_id": 'tenantID',
        "subscription_id": 'subscriptionID',
        "client_id": 'clientId',
        "client_secret": 'clientSecret'
    }

    _optionals = [
        'tenant_id',
        'subscription_id',
        'client_id',
        'client_secret',
    ]

    def __init__(self,
                 tenant_id=APIHelper.SKIP,
                 subscription_id=APIHelper.SKIP,
                 client_id=APIHelper.SKIP,
                 client_secret=APIHelper.SKIP):
        """Constructor for the AzureCspProfile class"""

        # Initialize members of the class
        if tenant_id is not APIHelper.SKIP:
            self.tenant_id = tenant_id 
        if subscription_id is not APIHelper.SKIP:
            self.subscription_id = subscription_id 
        if client_id is not APIHelper.SKIP:
            self.client_id = client_id 
        if client_secret is not APIHelper.SKIP:
            self.client_secret = client_secret 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        tenant_id = dictionary.get("tenantID") if dictionary.get("tenantID") else APIHelper.SKIP
        subscription_id = dictionary.get("subscriptionID") if dictionary.get("subscriptionID") else APIHelper.SKIP
        client_id = dictionary.get("clientId") if dictionary.get("clientId") else APIHelper.SKIP
        client_secret = dictionary.get("clientSecret") if dictionary.get("clientSecret") else APIHelper.SKIP
        # Return an object of this model
        return cls(tenant_id,
                   subscription_id,
                   client_id,
                   client_secret)
