# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper


class ServiceFile(object):

    """Implementation of the 'ServiceFile' model.

    Response to get file of a service.

    Attributes:
        id (string): System generated unique UUID.
        service_name (string): Service name to which the file is going to be
            associated.
        service_version (string): Version of the service being used.
        file (string): File which is to be uploaded should be provided in
            formData.
        category_name (string): Name of the workload being used in the
            service.
        category_version (string): Version of the workload being used in the
            service.
        category_type (string): Type of the workload being used in the service
            eg: use WORKLOAD_TGZ to upload the workload file in tgz format.
        validation_status (string): Gives the success and failure response for
            the validation.
        created_date (datetime): System captured creation date and time when
            tag is created.
        last_modified_date (datetime): System captured date and time when the
            tag was last modified.
        created_by (string): User information who created the tag.
        updated_by (string): Last user information who made changes to tag.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "service_name": 'serviceName',
        "service_version": 'serviceVersion',
        "file": 'file',
        "category_name": 'categoryName',
        "category_version": 'categoryVersion',
        "category_type": 'categoryType',
        "validation_status": 'validationStatus',
        "created_date": 'createdDate',
        "last_modified_date": 'lastModifiedDate',
        "created_by": 'createdBy',
        "updated_by": 'updatedBy'
    }

    _optionals = [
        'id',
        'service_name',
        'service_version',
        'file',
        'category_name',
        'category_version',
        'category_type',
        'validation_status',
        'created_date',
        'last_modified_date',
        'created_by',
        'updated_by',
    ]

    def __init__(self,
                 id=APIHelper.SKIP,
                 service_name=APIHelper.SKIP,
                 service_version=APIHelper.SKIP,
                 file=APIHelper.SKIP,
                 category_name=APIHelper.SKIP,
                 category_version=APIHelper.SKIP,
                 category_type=APIHelper.SKIP,
                 validation_status=APIHelper.SKIP,
                 created_date=APIHelper.SKIP,
                 last_modified_date=APIHelper.SKIP,
                 created_by=APIHelper.SKIP,
                 updated_by=APIHelper.SKIP):
        """Constructor for the ServiceFile class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if service_name is not APIHelper.SKIP:
            self.service_name = service_name 
        if service_version is not APIHelper.SKIP:
            self.service_version = service_version 
        if file is not APIHelper.SKIP:
            self.file = file 
        if category_name is not APIHelper.SKIP:
            self.category_name = category_name 
        if category_version is not APIHelper.SKIP:
            self.category_version = category_version 
        if category_type is not APIHelper.SKIP:
            self.category_type = category_type 
        if validation_status is not APIHelper.SKIP:
            self.validation_status = validation_status 
        if created_date is not APIHelper.SKIP:
            self.created_date = APIHelper.RFC3339DateTime(created_date) if created_date else None 
        if last_modified_date is not APIHelper.SKIP:
            self.last_modified_date = APIHelper.RFC3339DateTime(last_modified_date) if last_modified_date else None 
        if created_by is not APIHelper.SKIP:
            self.created_by = created_by 
        if updated_by is not APIHelper.SKIP:
            self.updated_by = updated_by 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        service_name = dictionary.get("serviceName") if dictionary.get("serviceName") else APIHelper.SKIP
        service_version = dictionary.get("serviceVersion") if dictionary.get("serviceVersion") else APIHelper.SKIP
        file = dictionary.get("file") if dictionary.get("file") else APIHelper.SKIP
        category_name = dictionary.get("categoryName") if dictionary.get("categoryName") else APIHelper.SKIP
        category_version = dictionary.get("categoryVersion") if dictionary.get("categoryVersion") else APIHelper.SKIP
        category_type = dictionary.get("categoryType") if dictionary.get("categoryType") else APIHelper.SKIP
        validation_status = dictionary.get("validationStatus") if dictionary.get("validationStatus") else APIHelper.SKIP
        created_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("createdDate")).datetime if dictionary.get("createdDate") else APIHelper.SKIP
        last_modified_date = APIHelper.RFC3339DateTime.from_value(dictionary.get("lastModifiedDate")).datetime if dictionary.get("lastModifiedDate") else APIHelper.SKIP
        created_by = dictionary.get("createdBy") if dictionary.get("createdBy") else APIHelper.SKIP
        updated_by = dictionary.get("updatedBy") if dictionary.get("updatedBy") else APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   service_name,
                   service_version,
                   file,
                   category_name,
                   category_version,
                   category_type,
                   validation_status,
                   created_date,
                   last_modified_date,
                   created_by,
                   updated_by)
