# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper
from verizon5gmecvnspapi.models.resource_base import ResourceBase


class ServiceResource(object):

    """Implementation of the 'ServiceResource' model.

    Resource of the service.

    Attributes:
        compute_resources (ResourceBase): Resource Base of the service.
        gpu_required (bool): GPU required or not for onboarding service.
        gpu (ResourceBase): Resource Base of the service.
        storage (ResourceBase): Resource Base of the service.
        memory (ResourceBase): Resource Base of the service.
        latency (ResourceBase): Resource Base of the service.
        request_rate (ResourceBase): Resource Base of the service.
        bandwidth (ResourceBase): Resource Base of the service.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "compute_resources": 'computeResources',
        "gpu_required": 'gpuRequired',
        "gpu": 'gpu',
        "storage": 'storage',
        "memory": 'memory',
        "latency": 'latency',
        "request_rate": 'requestRate',
        "bandwidth": 'bandwidth'
    }

    _optionals = [
        'compute_resources',
        'gpu_required',
        'gpu',
        'storage',
        'memory',
        'latency',
        'request_rate',
        'bandwidth',
    ]

    def __init__(self,
                 compute_resources=APIHelper.SKIP,
                 gpu_required=False,
                 gpu=APIHelper.SKIP,
                 storage=APIHelper.SKIP,
                 memory=APIHelper.SKIP,
                 latency=APIHelper.SKIP,
                 request_rate=APIHelper.SKIP,
                 bandwidth=APIHelper.SKIP):
        """Constructor for the ServiceResource class"""

        # Initialize members of the class
        if compute_resources is not APIHelper.SKIP:
            self.compute_resources = compute_resources 
        self.gpu_required = gpu_required 
        if gpu is not APIHelper.SKIP:
            self.gpu = gpu 
        if storage is not APIHelper.SKIP:
            self.storage = storage 
        if memory is not APIHelper.SKIP:
            self.memory = memory 
        if latency is not APIHelper.SKIP:
            self.latency = latency 
        if request_rate is not APIHelper.SKIP:
            self.request_rate = request_rate 
        if bandwidth is not APIHelper.SKIP:
            self.bandwidth = bandwidth 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        compute_resources = ResourceBase.from_dictionary(dictionary.get('computeResources')) if 'computeResources' in dictionary.keys() else APIHelper.SKIP
        gpu_required = dictionary.get("gpuRequired") if dictionary.get("gpuRequired") else False
        gpu = ResourceBase.from_dictionary(dictionary.get('gpu')) if 'gpu' in dictionary.keys() else APIHelper.SKIP
        storage = ResourceBase.from_dictionary(dictionary.get('storage')) if 'storage' in dictionary.keys() else APIHelper.SKIP
        memory = ResourceBase.from_dictionary(dictionary.get('memory')) if 'memory' in dictionary.keys() else APIHelper.SKIP
        latency = ResourceBase.from_dictionary(dictionary.get('latency')) if 'latency' in dictionary.keys() else APIHelper.SKIP
        request_rate = ResourceBase.from_dictionary(dictionary.get('requestRate')) if 'requestRate' in dictionary.keys() else APIHelper.SKIP
        bandwidth = ResourceBase.from_dictionary(dictionary.get('bandwidth')) if 'bandwidth' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(compute_resources,
                   gpu_required,
                   gpu,
                   storage,
                   memory,
                   latency,
                   request_rate,
                   bandwidth)
