# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from verizon5gmecvnspapi.api_helper import APIHelper
from verizon5gmecvnspapi.models.service import Service


class Services(object):

    """Implementation of the 'Services' model.

    Response to get all services.

    Attributes:
        total_records (int): Will display the total number of records
            fetched.
        service_res_list (list of Service): Response to fetch all services.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "total_records": 'totalRecords',
        "service_res_list": 'serviceResList'
    }

    _optionals = [
        'total_records',
        'service_res_list',
    ]

    def __init__(self,
                 total_records=APIHelper.SKIP,
                 service_res_list=APIHelper.SKIP):
        """Constructor for the Services class"""

        # Initialize members of the class
        if total_records is not APIHelper.SKIP:
            self.total_records = total_records 
        if service_res_list is not APIHelper.SKIP:
            self.service_res_list = service_res_list 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        total_records = dictionary.get("totalRecords") if dictionary.get("totalRecords") else APIHelper.SKIP
        service_res_list = None
        if dictionary.get('serviceResList') is not None:
            service_res_list = [Service.from_dictionary(x) for x in dictionary.get('serviceResList')]
        else:
            service_res_list = APIHelper.SKIP
        # Return an object of this model
        return cls(total_records,
                   service_res_list)
