# -*- coding: utf-8 -*-

"""
verizon5gmecvnspapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from apimatic_core.configurations.global_configuration import GlobalConfiguration
from apimatic_core.decorators.lazy_property import LazyProperty
from verizon5gmecvnspapi.configuration import Configuration
from verizon5gmecvnspapi.controllers.base_controller import BaseController
from verizon5gmecvnspapi.configuration import Environment
from verizon5gmecvnspapi.http.auth.o_auth_2 import OAuth2
from verizon5gmecvnspapi.controllers.service_onboarding_controller\
    import ServiceOnboardingController
from verizon5gmecvnspapi.controllers.service_metadata_controller\
    import ServiceMetadataController
from verizon5gmecvnspapi.controllers.repositories_controller\
    import RepositoriesController
from verizon5gmecvnspapi.controllers.csp_profiles_controller\
    import CSPProfilesController
from verizon5gmecvnspapi.controllers.service_claims_controller\
    import ServiceClaimsController
from verizon5gmecvnspapi.controllers.o_auth_authorization_controller\
    import OAuthAuthorizationController


class Verizon5gmecvnspapiClient(object):

    @LazyProperty
    def service_onboarding(self):
        return ServiceOnboardingController(self.global_configuration)

    @LazyProperty
    def service_metadata(self):
        return ServiceMetadataController(self.global_configuration)

    @LazyProperty
    def repositories(self):
        return RepositoriesController(self.global_configuration)

    @LazyProperty
    def csp_profiles(self):
        return CSPProfilesController(self.global_configuration)

    @LazyProperty
    def service_claims(self):
        return ServiceClaimsController(self.global_configuration)

    @LazyProperty
    def o_auth_authorization(self):
        return OAuthAuthorizationController(self.global_configuration)

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, http_call_back=None,
                 timeout=60, max_retries=0, backoff_factor=2,
                 retry_statuses=[408, 413, 429, 500, 502, 503, 504, 521, 522, 524],
                 retry_methods=['GET', 'PUT'],
                 environment=Environment.PRODUCTION,
                 o_auth_client_id='TODO: Replace',
                 o_auth_client_secret='TODO: Replace', o_auth_token=None,
                 o_auth_scopes=None, vz_m_2_m_token='TODO: Replace',
                 config=None):
        if config is None:
            self.config = Configuration(
                                         http_client_instance=http_client_instance,
                                         override_http_client_configuration=override_http_client_configuration,
                                         http_call_back=http_call_back,
                                         timeout=timeout,
                                         max_retries=max_retries,
                                         backoff_factor=backoff_factor,
                                         retry_statuses=retry_statuses,
                                         retry_methods=retry_methods,
                                         environment=environment,
                                         o_auth_client_id=o_auth_client_id,
                                         o_auth_client_secret=o_auth_client_secret,
                                         o_auth_token=o_auth_token,
                                         o_auth_scopes=o_auth_scopes,
                                         vz_m_2_m_token=vz_m_2_m_token)
        else:
            self.config = config

        self.global_configuration = GlobalConfiguration(self.config)\
            .global_errors(BaseController.global_errors())\
            .base_uri_executor(self.config.get_base_uri)\
            .user_agent(BaseController.user_agent(), BaseController.user_agent_parameters())\
            .global_header('VZ-M2M-Token', self.config.vz_m_2_m_token)

        self.initialize_auth_managers(self.global_configuration)

        self.global_configuration = self.global_configuration.auth_managers(self.auth_managers)

    def initialize_auth_managers(self, global_config):
        http_client_config = global_config.get_http_client_configuration()
        self.auth_managers = { key: None for key in ['global']}
        self.auth_managers['global'] = OAuth2(http_client_config.o_auth_client_id, http_client_config.o_auth_client_secret, http_client_config.o_auth_token, global_config, http_client_config.o_auth_scopes)
        return self.auth_managers
