import numpy.typing
from ._apngasm_python import APNGAsm as APNGAsm, APNGFrame as APNGFrame, IAPNGAsmListener as IAPNGAsmListener, __version__ as __version__, create_frame_from_rgb as create_frame_from_rgb, create_frame_from_rgb_trns as create_frame_from_rgb_trns, create_frame_from_rgba as create_frame_from_rgba
from PIL import Image
from _typeshed import Incomplete
from typing import Optional

NUMPY_LOADED: bool
PILLOW_LOADED: bool

class APNGAsmBinder:
    color_type_dict: Incomplete
    apngasm: Incomplete
    def __init__(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: types.TracebackType | None) -> None: ...
    def frame_pixels_as_pillow(self, frame: int, new_value: Optional[Image.Image] = None) -> Optional[Image.Image]: ...
    def frame_pixels_as_numpy(self, frame: int, new_value: Optional[numpy.typing.NDArray] = None) -> Optional[numpy.typing.NDArray]: ...
    def frame_width(self, frame: int, new_value: Optional[int] = None) -> Optional[int]: ...
    def frame_height(self, frame: int, new_value: Optional[int] = None) -> Optional[int]: ...
    def frame_color_type(self, frame: int, new_value: Optional[int] = None) -> Optional[int]: ...
    def frame_palette(self, frame: int, new_value: Optional[numpy.typing.NDArray] = None) -> Optional[numpy.typing.NDArray]: ...
    def frame_transparency(self, frame: int, new_value: Optional[numpy.typing.NDArray] = None) -> Optional[numpy.typing.NDArray]: ...
    def frame_palette_size(self, frame: int, new_value: Optional[int] = None) -> Optional[int]: ...
    def frame_transparency_size(self, frame: int, new_value: Optional[int] = None) -> Optional[int]: ...
    def frame_delay_num(self, frame: int, new_value: Optional[int] = None) -> Optional[int]: ...
    def frame_delay_den(self, frame: int, new_value: Optional[int] = None) -> Optional[int]: ...
    def add_frame_from_file(self, file_path: str, delay_num: int = 100, delay_den: int = 1000) -> int: ...
    def add_frame_from_pillow(self, pillow_image: Image.Image, delay_num: int = 100, delay_den: int = 1000) -> int: ...
    def add_frame_from_numpy(self, numpy_data: numpy.typing.NDArray, width: Optional[int] = None, height: Optional[int] = None, trns_color: Optional[numpy.typing.NDArray] = None, mode: Optional[str] = None, delay_num: int = 100, delay_den: int = 1000) -> int: ...
    def assemble(self, output_path: str) -> bool: ...
    def disassemble_as_numpy(self, file_path: str) -> list[APNGFrame]: ...
    def disassemble_as_pillow(self, file_path: str) -> list[APNGFrame]: ...
    def save_pngs(self, output_dir: str) -> bool: ...
    def load_animation_spec(self, file_path: str) -> list[APNGFrame]: ...
    def save_json(self, output_path: str, image_dir: str) -> bool: ...
    def save_xml(self, output_path: str, image_dir: str) -> bool: ...
    def set_apng_asm_listener(self, listener: Optional[IAPNGAsmListener] = None): ...
    def set_loops(self, loops: int = 0): ...
    def set_skip_first(self, skip_first: bool): ...
    def get_frames(self) -> list[APNGFrame]: ...
    def get_loops(self) -> int: ...
    def is_skip_first(self) -> int: ...
    def frame_count(self) -> int: ...
    def reset(self) -> int: ...
    def version(self) -> str: ...
