#!/usr/bin/env python
#
# Copyright 2007 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
"""Build tool to generate ProtoRPC python modules from protobuf descriptors.

Reads a binary protocol buffer descriptor file from stdin.  Writes to stdout
a python file that when loaded is populated with ProtoRPC versions of the
objects defined in the descriptor file.

This can be deleted when gen_protorpc is capable of generating Python output
containing ProtoRPC services.

Usage:
  protoc -o my_service.descriptor my_service.proto
  descriptor2py.py < my_service.descriptor > my_service.py
"""



import sys

PYTHON_TEMPLATE = """# This file is automatically generated, do not modify.

from protorpc import definition
from protorpc import descriptor
from protorpc import protobuf

definition.import_file_set(protobuf.decode_message(descriptor.FileSet, %r))
"""




sys.stdout.write(PYTHON_TEMPLATE % (sys.stdin.buffer.read(),))
