"""Request Body Schemas for API Tools

DO NOT EDIT THIS MODULE DIRECTLY.

THIS MODULE WAS AUTO-GENERATED AND CONTAINS OpenAPI REQUEST BODY SCHEMAS
FOR TOOLS WITH COMPLEX REQUEST BODIES. ANY CHANGES TO THIS MODULE WILL
BE OVERWRITTEN BY THE TRANSPILER.
"""
from typing import Any

REQUEST_BODY_SCHEMAS: dict[str, Any] = {
    "CREATEPRERECEIVEHOOK": '{"properties": {"allow_downstream_configuration": {"description": "Whether enforcement can be overridden at the org or repo level. default: `false`", "type": "boolean"}, "enforcement": {"description": "The state of enforcement for this hook. default: `disabled`", "type": "string"}, "environment": {"additionalProperties": true, "description": "The pre-receive environment where the script is executed.", "properties": {}, "type": "object"}, "name": {"description": "The name of the hook.", "type": "string"}, "script": {"description": "The script that the hook runs.", "type": "string"}, "script_repository": {"additionalProperties": true, "description": "The GitHub repository where the script is kept.", "properties": {}, "type": "object"}}, "required": ["name", "script", "script_repository", "environment"], "type": "object"}',  # noqa: E501
    "UPDATEGITHUBPRERECEIVEHOOK": '{"properties": {"allow_downstream_configuration": {"description": "Whether enforcement can be overridden at the org or repo level.", "type": "boolean"}, "enforcement": {"description": "The state of enforcement for this hook.", "type": "string"}, "environment": {"additionalProperties": true, "description": "The pre-receive environment where the script is executed.", "properties": {}, "type": "object"}, "name": {"description": "The name of the hook.", "type": "string"}, "script": {"description": "The script that the hook runs.", "type": "string"}, "script_repository": {"additionalProperties": true, "description": "The GitHub repository where the script is kept.", "properties": {}, "type": "object"}}, "type": "object"}',  # noqa: E501
    "UPDATEGITHUBAPPWEBHOOKCONFIG": '{"properties": {"content_type": {"description": "The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.", "example": "\"json\"", "type": "string"}, "insecure_ssl": {"oneOf": [{"description": "Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**", "example": "\"0\"", "type": "string"}, {"type": "number"}]}, "secret": {"description": "If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads/#delivery-headers).", "example": "\"********\"", "type": "string"}, "url": {"description": "The URL to which the payloads will be delivered.", "example": "https://example.com/webhook", "format": "uri", "type": "string"}}, "type": "object"}',  # noqa: E501
    "CREATEGITHUBAPPINSTALLATIONTOKEN": '{"properties": {"permissions": {"description": "The permissions granted to the user-to-server access token.", "example": {"contents": "read", "deployments": "write", "issues": "read", "single_file": "read"}, "properties": {"actions": {"description": "The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.", "enum": ["read", "write"], "type": "string"}, "administration": {"description": "The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.", "enum": ["read", "write"], "type": "string"}, "checks": {"description": "The level of permission to grant the access token for checks on code.", "enum": ["read", "write"], "type": "string"}, "contents": {"description": "The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.", "enum": ["read", "write"], "type": "string"}, "deployments": {"description": "The level of permission to grant the access token for deployments and deployment statuses.", "enum": ["read", "write"], "type": "string"}, "environments": {"description": "The level of permission to grant the access token for managing repository environments.", "enum": ["read", "write"], "type": "string"}, "issues": {"description": "The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.", "enum": ["read", "write"], "type": "string"}, "members": {"description": "The level of permission to grant the access token for organization teams and members.", "enum": ["read", "write"], "type": "string"}, "metadata": {"description": "The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.", "enum": ["read", "write"], "type": "string"}, "organization_administration": {"description": "The level of permission to grant the access token to manage access to an organization.", "enum": ["read", "write"], "type": "string"}, "organization_announcement_banners": {"description": "The level of permission to grant the access token to view and manage announcement banners for an organization.", "enum": ["read", "write"], "type": "string"}, "organization_hooks": {"description": "The level of permission to grant the access token to manage the post-receive hooks for an organization.", "enum": ["read", "write"], "type": "string"}, "organization_packages": {"description": "The level of permission to grant the access token for organization packages published to GitHub Packages.", "enum": ["read", "write"], "type": "string"}, "organization_plan": {"description": "The level of permission to grant the access token for viewing an organization\'s plan.", "enum": ["read"], "type": "string"}, "organization_projects": {"description": "The level of permission to grant the access token to manage organization projects and projects beta (where available).", "enum": ["read", "write", "admin"], "type": "string"}, "organization_secrets": {"description": "The level of permission to grant the access token to manage organization secrets.", "enum": ["read", "write"], "type": "string"}, "organization_self_hosted_runners": {"description": "The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.", "enum": ["read", "write"], "type": "string"}, "organization_user_blocking": {"description": "The level of permission to grant the access token to view and manage users blocked by the organization.", "enum": ["read", "write"], "type": "string"}, "packages": {"description": "The level of permission to grant the access token for packages published to GitHub Packages.", "enum": ["read", "write"], "type": "string"}, "pages": {"description": "The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.", "enum": ["read", "write"], "type": "string"}, "pull_requests": {"description": "The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.", "enum": ["read", "write"], "type": "string"}, "repository_announcement_banners": {"description": "The level of permission to grant the access token to view and manage announcement banners for a repository.", "enum": ["read", "write"], "type": "string"}, "repository_hooks": {"description": "The level of permission to grant the access token to manage the post-receive hooks for a repository.", "enum": ["read", "write"], "type": "string"}, "repository_projects": {"description": "The level of permission to grant the access token to manage repository projects, columns, and cards.", "enum": ["read", "write", "admin"], "type": "string"}, "secret_scanning_alerts": {"description": "The level of permission to grant the access token to view and manage secret scanning alerts.", "enum": ["read", "write"], "type": "string"}, "secrets": {"description": "The level of permission to grant the access token to manage repository secrets.", "enum": ["read", "write"], "type": "string"}, "security_events": {"description": "The level of permission to grant the access token to view and manage security events like code scanning alerts.", "enum": ["read", "write"], "type": "string"}, "single_file": {"description": "The level of permission to grant the access token to manage just a single file.", "enum": ["read", "write"], "type": "string"}, "statuses": {"description": "The level of permission to grant the access token for commit statuses.", "enum": ["read", "write"], "type": "string"}, "team_discussions": {"description": "The level of permission to grant the access token to manage team discussions and related comments.", "enum": ["read", "write"], "type": "string"}, "vulnerability_alerts": {"description": "The level of permission to grant the access token to manage Dependabot alerts.", "enum": ["read", "write"], "type": "string"}, "workflows": {"description": "The level of permission to grant the access token to update GitHub Actions workflow files.", "enum": ["write"], "type": "string"}}, "title": "App Permissions", "type": "object"}, "repositories": {"description": "List of repository names that the token should have access to", "items": {"example": "rails", "type": "string"}, "type": "array"}, "repository_ids": {"description": "List of repository IDs that the token should have access to", "example": [1], "items": {"type": "integer"}, "type": "array"}}, "type": "object"}',  # noqa: E501
    "CREATEGITHUBSCOPEDTOKEN": '{"properties": {"access_token": {"description": "The access token used to authenticate to the GitHub API.", "example": "e72e16c7e42f292c6912e7710c838347ae178b4a", "type": "string"}, "permissions": {"description": "The permissions granted to the user-to-server access token.", "example": {"contents": "read", "deployments": "write", "issues": "read", "single_file": "read"}, "properties": {"actions": {"description": "The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.", "enum": ["read", "write"], "type": "string"}, "administration": {"description": "The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.", "enum": ["read", "write"], "type": "string"}, "checks": {"description": "The level of permission to grant the access token for checks on code.", "enum": ["read", "write"], "type": "string"}, "contents": {"description": "The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.", "enum": ["read", "write"], "type": "string"}, "deployments": {"description": "The level of permission to grant the access token for deployments and deployment statuses.", "enum": ["read", "write"], "type": "string"}, "environments": {"description": "The level of permission to grant the access token for managing repository environments.", "enum": ["read", "write"], "type": "string"}, "issues": {"description": "The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.", "enum": ["read", "write"], "type": "string"}, "members": {"description": "The level of permission to grant the access token for organization teams and members.", "enum": ["read", "write"], "type": "string"}, "metadata": {"description": "The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.", "enum": ["read", "write"], "type": "string"}, "organization_administration": {"description": "The level of permission to grant the access token to manage access to an organization.", "enum": ["read", "write"], "type": "string"}, "organization_announcement_banners": {"description": "The level of permission to grant the access token to view and manage announcement banners for an organization.", "enum": ["read", "write"], "type": "string"}, "organization_hooks": {"description": "The level of permission to grant the access token to manage the post-receive hooks for an organization.", "enum": ["read", "write"], "type": "string"}, "organization_packages": {"description": "The level of permission to grant the access token for organization packages published to GitHub Packages.", "enum": ["read", "write"], "type": "string"}, "organization_plan": {"description": "The level of permission to grant the access token for viewing an organization\'s plan.", "enum": ["read"], "type": "string"}, "organization_projects": {"description": "The level of permission to grant the access token to manage organization projects and projects beta (where available).", "enum": ["read", "write", "admin"], "type": "string"}, "organization_secrets": {"description": "The level of permission to grant the access token to manage organization secrets.", "enum": ["read", "write"], "type": "string"}, "organization_self_hosted_runners": {"description": "The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.", "enum": ["read", "write"], "type": "string"}, "organization_user_blocking": {"description": "The level of permission to grant the access token to view and manage users blocked by the organization.", "enum": ["read", "write"], "type": "string"}, "packages": {"description": "The level of permission to grant the access token for packages published to GitHub Packages.", "enum": ["read", "write"], "type": "string"}, "pages": {"description": "The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.", "enum": ["read", "write"], "type": "string"}, "pull_requests": {"description": "The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.", "enum": ["read", "write"], "type": "string"}, "repository_announcement_banners": {"description": "The level of permission to grant the access token to view and manage announcement banners for a repository.", "enum": ["read", "write"], "type": "string"}, "repository_hooks": {"description": "The level of permission to grant the access token to manage the post-receive hooks for a repository.", "enum": ["read", "write"], "type": "string"}, "repository_projects": {"description": "The level of permission to grant the access token to manage repository projects, columns, and cards.", "enum": ["read", "write", "admin"], "type": "string"}, "secret_scanning_alerts": {"description": "The level of permission to grant the access token to view and manage secret scanning alerts.", "enum": ["read", "write"], "type": "string"}, "secrets": {"description": "The level of permission to grant the access token to manage repository secrets.", "enum": ["read", "write"], "type": "string"}, "security_events": {"description": "The level of permission to grant the access token to view and manage security events like code scanning alerts.", "enum": ["read", "write"], "type": "string"}, "single_file": {"description": "The level of permission to grant the access token to manage just a single file.", "enum": ["read", "write"], "type": "string"}, "statuses": {"description": "The level of permission to grant the access token for commit statuses.", "enum": ["read", "write"], "type": "string"}, "team_discussions": {"description": "The level of permission to grant the access token to manage team discussions and related comments.", "enum": ["read", "write"], "type": "string"}, "vulnerability_alerts": {"description": "The level of permission to grant the access token to manage Dependabot alerts.", "enum": ["read", "write"], "type": "string"}, "workflows": {"description": "The level of permission to grant the access token to update GitHub Actions workflow files.", "enum": ["write"], "type": "string"}}, "title": "App Permissions", "type": "object"}, "repositories": {"description": "The list of repository names to scope the user-to-server access token to. `repositories` may not be specified if `repository_ids` is specified.", "items": {"example": "rails", "type": "string"}, "type": "array"}, "repository_ids": {"description": "The list of repository IDs to scope the user-to-server access token to. `repository_ids` may not be specified if `repositories` is specified.", "example": [1], "items": {"type": "integer"}, "type": "array"}, "target": {"description": "The name of the user or organization to scope the user-to-server access token to. **Required** unless `target_id` is specified.", "example": "octocat", "type": "string"}, "target_id": {"description": "The ID of the user or organization to scope the user-to-server access token to. **Required** unless `target` is specified.", "example": 1, "type": "integer"}}, "required": ["access_token"], "type": "object"}',  # noqa: E501
    "CREATEGIST": '{"properties": {"description": {"description": "Description of the gist", "example": "Example Ruby script", "type": "string"}, "files": {"additionalProperties": {"properties": {"content": {"description": "Content of the file", "readOnly": false, "type": "string"}}, "required": ["content"], "type": "object"}, "description": "Names and content for the files that make up the gist", "example": {"hello.rb": {"content": "puts \"Hello, World!\""}}, "type": "object"}, "public": {"oneOf": [{"default": false, "description": "Flag indicating whether the gist is public", "example": true, "type": "boolean"}, {"default": "false", "enum": ["true", "false"], "example": "true", "type": "string"}]}}, "required": ["files"], "type": "object"}',  # noqa: E501
    "UPDATEGITHUBGIST": '{"anyOf": [{"required": ["description"]}, {"required": ["files"]}], "nullable": true, "properties": {"description": {"description": "The description of the gist.", "example": "Example Ruby script", "type": "string"}, "files": {"additionalProperties": {"anyOf": [{"required": ["content"]}, {"required": ["filename"]}, {"maxProperties": 0, "type": "object"}], "nullable": true, "properties": {"content": {"description": "The new content of the file.", "type": "string"}, "filename": {"description": "The new filename for the file.", "nullable": true, "type": "string"}}, "type": "object"}, "description": "The gist files to be updated, renamed, or deleted. Each `key` must match the current filename\n(including extension) of the targeted gist file. For example: `hello.py`.\n\nTo delete a file, set the whole file to null. For example: `hello.py : null`.", "example": {"hello.rb": {"content": "blah", "filename": "goodbye.rb"}}, "type": "object"}}, "type": "object"}',  # noqa: E501
    "UPDATEGITHUBORGANIZATION": '{"properties": {"advanced_security_enabled_for_new_repositories": {"description": "Whether GitHub Advanced Security is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.8/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.", "type": "boolean"}, "billing_email": {"description": "Billing email address. This address is not publicized.", "type": "string"}, "blog": {"example": "\"http://github.blog\"", "type": "string"}, "company": {"description": "The company name.", "type": "string"}, "default_repository_permission": {"default": "read", "description": "Default permission level members have for organization repositories.", "enum": ["read", "write", "admin", "none"], "type": "string"}, "dependabot_alerts_enabled_for_new_repositories": {"description": "Whether Dependabot alerts is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.8/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.", "type": "boolean"}, "dependabot_security_updates_enabled_for_new_repositories": {"description": "Whether Dependabot security updates is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.8/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.", "type": "boolean"}, "dependency_graph_enabled_for_new_repositories": {"description": "Whether dependency graph is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.8/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.", "type": "boolean"}, "description": {"description": "The description of the company.", "type": "string"}, "email": {"description": "The publicly visible email address.", "type": "string"}, "has_organization_projects": {"description": "Whether an organization can use organization projects.", "type": "boolean"}, "has_repository_projects": {"description": "Whether repositories that belong to the organization can use repository projects.", "type": "boolean"}, "location": {"description": "The location.", "type": "string"}, "members_allowed_repository_creation_type": {"description": "Specifies which types of repositories non-admin organization members can create. \n**Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See the parameter deprecation notice in the operation description for details.", "enum": ["all", "private", "none"], "type": "string"}, "members_can_create_internal_repositories": {"description": "Whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see \"[Restricting repository creation in your organization](https://docs.github.com/enterprise-server@3.8/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)\" in the GitHub Help documentation.", "type": "boolean"}, "members_can_create_pages": {"default": true, "description": "Whether organization members can create GitHub Pages sites. Existing published sites will not be impacted.", "type": "boolean"}, "members_can_create_private_repositories": {"description": "Whether organization members can create private repositories, which are visible to organization members with permission. For more information, see \"[Restricting repository creation in your organization](https://docs.github.com/enterprise-server@3.8/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)\" in the GitHub Help documentation.", "type": "boolean"}, "members_can_create_public_repositories": {"description": "Whether organization members can create public repositories, which are visible to anyone. For more information, see \"[Restricting repository creation in your organization](https://docs.github.com/enterprise-server@3.8/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)\" in the GitHub Help documentation.", "type": "boolean"}, "members_can_create_repositories": {"default": true, "description": "Whether of non-admin organization members can create repositories. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.", "type": "boolean"}, "members_can_fork_private_repositories": {"default": false, "description": "Whether organization members can fork private organization repositories.", "type": "boolean"}, "name": {"description": "The shorthand name of the company.", "type": "string"}, "secret_scanning_enabled_for_new_repositories": {"description": "Whether secret scanning is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.8/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.", "type": "boolean"}, "secret_scanning_push_protection_custom_link": {"description": "If `secret_scanning_push_protection_custom_link_enabled` is true, the URL that will be displayed to contributors who are blocked from pushing a secret.", "type": "string"}, "secret_scanning_push_protection_custom_link_enabled": {"description": "Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.", "type": "boolean"}, "secret_scanning_push_protection_enabled_for_new_repositories": {"description": "Whether secret scanning push protection is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see \"[Managing security managers in your organization](https://docs.github.com/enterprise-server@3.8/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).\"\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.", "type": "boolean"}, "twitter_username": {"description": "The Twitter username of the company.", "type": "string"}, "web_commit_signoff_required": {"default": false, "description": "Whether contributors to organization repositories are required to sign off on commits they make through GitHub\'s web interface.", "type": "boolean"}}, "type": "object"}',  # noqa: E501
    "SETALLOWEDACTIONSFORORGANIZATION": '{"properties": {"github_owned_allowed": {"description": "Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.", "type": "boolean"}, "patterns_allowed": {"description": "Specifies a list of string-matching patterns to allow specific action(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`.", "items": {"type": "string"}, "type": "array"}}, "required": ["github_owned_allowed", "patterns_allowed"], "type": "object"}',  # noqa: E501
    "CREATEGITHUBORGWEBHOOK": '{"properties": {"active": {"default": true, "description": "Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.", "type": "boolean"}, "config": {"description": "Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/enterprise-server@3.8/rest/reference/orgs#create-hook-config-params).", "properties": {"content_type": {"description": "The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.", "example": "\"json\"", "type": "string"}, "insecure_ssl": {"oneOf": [{"description": "Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**", "example": "\"0\"", "type": "string"}, {"type": "number"}]}, "password": {"example": "\"password\"", "type": "string"}, "secret": {"description": "If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads/#delivery-headers).", "example": "\"********\"", "type": "string"}, "url": {"description": "The URL to which the payloads will be delivered.", "example": "https://example.com/webhook", "format": "uri", "type": "string"}, "username": {"example": "\"kdaigle\"", "type": "string"}}, "required": ["url"], "type": "object"}, "events": {"default": ["push"], "description": "Determines what [events](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads) the hook is triggered for. Set to `[\"*\"]` to receive all possible events.", "items": {"type": "string"}, "type": "array"}, "name": {"description": "Must be passed as \"web\".", "type": "string"}}, "required": ["name", "config"], "type": "object"}',  # noqa: E501
    "UPDATEGITHUBORGWEBHOOK": '{"properties": {"active": {"default": true, "description": "Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.", "type": "boolean"}, "config": {"description": "Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/enterprise-server@3.8/rest/reference/orgs#update-hook-config-params).", "properties": {"content_type": {"description": "The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.", "example": "\"json\"", "type": "string"}, "insecure_ssl": {"oneOf": [{"description": "Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**", "example": "\"0\"", "type": "string"}, {"type": "number"}]}, "secret": {"description": "If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads/#delivery-headers).", "example": "\"********\"", "type": "string"}, "url": {"description": "The URL to which the payloads will be delivered.", "example": "https://example.com/webhook", "format": "uri", "type": "string"}}, "required": ["url"], "type": "object"}, "events": {"default": ["push"], "description": "Determines what [events](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads) the hook is triggered for.", "items": {"type": "string"}, "type": "array"}, "name": {"example": "\"web\"", "type": "string"}}, "type": "object"}',  # noqa: E501
    "UPDATEORGWEBHOOKCONFIG": '{"properties": {"content_type": {"description": "The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.", "example": "\"json\"", "type": "string"}, "insecure_ssl": {"oneOf": [{"description": "Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**", "example": "\"0\"", "type": "string"}, {"type": "number"}]}, "secret": {"description": "If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads/#delivery-headers).", "example": "\"********\"", "type": "string"}, "url": {"description": "The URL to which the payloads will be delivered.", "example": "https://example.com/webhook", "format": "uri", "type": "string"}}, "type": "object"}',  # noqa: E501
    "CREATEGITHUBORGANIZATIONREPO": '{"properties": {"allow_auto_merge": {"default": false, "description": "Either `true` to allow auto-merge on pull requests, or `false` to disallow auto-merge.", "type": "boolean"}, "allow_merge_commit": {"default": true, "description": "Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.", "type": "boolean"}, "allow_rebase_merge": {"default": true, "description": "Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.", "type": "boolean"}, "allow_squash_merge": {"default": true, "description": "Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.", "type": "boolean"}, "auto_init": {"default": false, "description": "Pass `true` to create an initial commit with empty README.", "type": "boolean"}, "delete_branch_on_merge": {"default": false, "description": "Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion. **The authenticated user must be an organization owner to set this property to `true`.**", "type": "boolean"}, "description": {"description": "A short description of the repository.", "type": "string"}, "gitignore_template": {"description": "Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, \"Haskell\".", "type": "string"}, "has_downloads": {"default": true, "description": "Whether downloads are enabled.", "example": true, "type": "boolean"}, "has_issues": {"default": true, "description": "Either `true` to enable issues for this repository or `false` to disable them.", "type": "boolean"}, "has_projects": {"default": true, "description": "Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you\'re creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.", "type": "boolean"}, "has_wiki": {"default": true, "description": "Either `true` to enable the wiki for this repository or `false` to disable it.", "type": "boolean"}, "homepage": {"description": "A URL with more information about the repository.", "type": "string"}, "is_template": {"default": false, "description": "Either `true` to make this repo available as a template repository or `false` to prevent it.", "type": "boolean"}, "license_template": {"description": "Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://docs.github.com/enterprise-server@3.8/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, \"mit\" or \"mpl-2.0\".", "type": "string"}, "merge_commit_message": {"description": "The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request\'s title.\n- `PR_BODY` - default to the pull request\'s body.\n- `BLANK` - default to a blank commit message.", "enum": ["PR_BODY", "PR_TITLE", "BLANK"], "type": "string"}, "merge_commit_title": {"description": "The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request\'s title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).", "enum": ["PR_TITLE", "MERGE_MESSAGE"], "type": "string"}, "name": {"description": "The name of the repository.", "type": "string"}, "private": {"default": false, "description": "Whether the repository is private.", "type": "boolean"}, "squash_merge_commit_message": {"description": "The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request\'s body.\n- `COMMIT_MESSAGES` - default to the branch\'s commit messages.\n- `BLANK` - default to a blank commit message.", "enum": ["PR_BODY", "COMMIT_MESSAGES", "BLANK"], "type": "string"}, "squash_merge_commit_title": {"description": "The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request\'s title.\n- `COMMIT_OR_PR_TITLE` - default to the commit\'s title (if only one commit) or the pull request\'s title (when more than one commit).", "enum": ["PR_TITLE", "COMMIT_OR_PR_TITLE"], "type": "string"}, "team_id": {"description": "The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.", "type": "integer"}, "use_squash_pr_title_as_default": {"default": false, "deprecated": true, "description": "Either `true` to allow squash-merge commits to use pull request title, or `false` to use commit message. **This property has been deprecated. Please use `squash_merge_commit_title` instead.", "type": "boolean"}, "visibility": {"description": "The visibility of the repository. **Note**: For GitHub Enterprise Server, this endpoint will only list repositories available to all users on the enterprise. For more information, see \"[Creating an internal repository](https://docs.github.com/enterprise-server@3.8/github/creating-cloning-and-archiving-repositories/about-repository-visibility#about-internal-repositories)\" in the GitHub Help documentation.  \nThe `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.", "enum": ["public", "private", "internal"], "type": "string"}}, "required": ["name"], "type": "object"}',  # noqa: E501
    "CREATEGITHUBPROJECTCARD": '{"oneOf": [{"properties": {"note": {"description": "The project card\'s note", "example": "Update all gems", "nullable": true, "type": "string"}}, "required": ["note"], "type": "object"}, {"properties": {"content_id": {"description": "The unique identifier of the content associated with the card", "example": 42, "type": "integer"}, "content_type": {"description": "The piece of content associated with the card", "example": "PullRequest", "type": "string"}}, "required": ["content_id", "content_type"], "type": "object"}]}',  # noqa: E501
    "UPDATEGITHUBREPOSITORY": '{"properties": {"allow_forking": {"default": false, "description": "Either `true` to allow private forks, or `false` to prevent private forks.", "type": "boolean"}, "allow_merge_commit": {"default": true, "description": "Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.", "type": "boolean"}, "allow_rebase_merge": {"default": true, "description": "Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.", "type": "boolean"}, "allow_squash_merge": {"default": true, "description": "Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.", "type": "boolean"}, "allow_update_branch": {"default": false, "description": "Either `true` to always allow a pull request head branch that is behind its base branch to be updated even if it is not required to be up to date before merging, or false otherwise.", "type": "boolean"}, "archived": {"default": false, "description": "Whether to archive this repository. `false` will unarchive a previously archived repository.", "type": "boolean"}, "default_branch": {"description": "Updates the default branch for this repository.", "type": "string"}, "delete_branch_on_merge": {"default": false, "description": "Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.", "type": "boolean"}, "description": {"description": "A short description of the repository.", "type": "string"}, "has_issues": {"default": true, "description": "Either `true` to enable issues for this repository or `false` to disable them.", "type": "boolean"}, "has_projects": {"default": true, "description": "Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you\'re creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.", "type": "boolean"}, "has_wiki": {"default": true, "description": "Either `true` to enable the wiki for this repository or `false` to disable it.", "type": "boolean"}, "homepage": {"description": "A URL with more information about the repository.", "type": "string"}, "is_template": {"default": false, "description": "Either `true` to make this repo available as a template repository or `false` to prevent it.", "type": "boolean"}, "merge_commit_message": {"description": "The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request\'s title.\n- `PR_BODY` - default to the pull request\'s body.\n- `BLANK` - default to a blank commit message.", "enum": ["PR_BODY", "PR_TITLE", "BLANK"], "type": "string"}, "merge_commit_title": {"description": "The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request\'s title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).", "enum": ["PR_TITLE", "MERGE_MESSAGE"], "type": "string"}, "name": {"description": "The name of the repository.", "type": "string"}, "private": {"default": false, "description": "Either `true` to make the repository private or `false` to make it public. Default: `false`.  \n**Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://docs.github.com/enterprise-server@3.8/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private.", "type": "boolean"}, "squash_merge_commit_message": {"description": "The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request\'s body.\n- `COMMIT_MESSAGES` - default to the branch\'s commit messages.\n- `BLANK` - default to a blank commit message.", "enum": ["PR_BODY", "COMMIT_MESSAGES", "BLANK"], "type": "string"}, "squash_merge_commit_title": {"description": "The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request\'s title.\n- `COMMIT_OR_PR_TITLE` - default to the commit\'s title (if only one commit) or the pull request\'s title (when more than one commit).", "enum": ["PR_TITLE", "COMMIT_OR_PR_TITLE"], "type": "string"}, "use_squash_pr_title_as_default": {"default": false, "deprecated": true, "description": "Either `true` to allow squash-merge commits to use pull request title, or `false` to use commit message. **This property has been deprecated. Please use `squash_merge_commit_title` instead.", "type": "boolean"}, "visibility": {"description": "The visibility of the repository.", "enum": ["public", "private", "internal"], "type": "string"}, "web_commit_signoff_required": {"default": false, "description": "Either `true` to require contributors to sign off on web-based commits, or `false` to not require contributors to sign off on web-based commits.", "type": "boolean"}}, "type": "object"}',  # noqa: E501
    "SETGITHUBACTIONSALLOWEDINREPO": '{"properties": {"github_owned_allowed": {"description": "Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.", "type": "boolean"}, "patterns_allowed": {"description": "Specifies a list of string-matching patterns to allow specific action(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`.", "items": {"type": "string"}, "type": "array"}}, "required": ["github_owned_allowed", "patterns_allowed"], "type": "object"}',  # noqa: E501
    "UPDATEBRANCHPROTECTION": '{"properties": {"allow_deletions": {"description": "Allows deletion of the protected branch by anyone with write access to the repository. Set to `false` to prevent deletion of the protected branch. Default: `false`. For more information, see \"[Enabling force pushes to a protected branch](https://docs.github.com/enterprise-server@3.8/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)\" in the GitHub Help documentation.", "type": "boolean"}, "allow_force_pushes": {"description": "Permits force pushes to the protected branch by anyone with write access to the repository. Set to `true` to allow force pushes. Set to `false` or `null` to block force pushes. Default: `false`. For more information, see \"[Enabling force pushes to a protected branch](https://docs.github.com/enterprise-server@3.8/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)\" in the GitHub Help documentation.\"", "nullable": true, "type": "boolean"}, "allow_fork_syncing": {"default": false, "description": "Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing. Default: `false`.", "type": "boolean"}, "block_creations": {"description": "If set to `true`, the `restrictions` branch protection settings which limits who can push will also block pushes which create new branches, unless the push is initiated by a user, team, or app which has the ability to push. Set to `true` to restrict new branch creation. Default: `false`.", "type": "boolean"}, "enforce_admins": {"description": "Enforce all configured restrictions for administrators. Set to `true` to enforce required status checks for repository administrators. Set to `null` to disable.", "nullable": true, "type": "boolean"}, "lock_branch": {"default": false, "description": "Whether to set the branch as read-only. If this is true, users will not be able to push to the branch. Default: `false`.", "type": "boolean"}, "required_conversation_resolution": {"description": "Requires all conversations on code to be resolved before a pull request can be merged into a branch that matches this rule. Set to `false` to disable. Default: `false`.", "type": "boolean"}, "required_linear_history": {"description": "Enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch. Set to `true` to enforce a linear commit history. Set to `false` to disable a linear commit Git history. Your repository must allow squash merging or rebase merging before you can enable a linear commit history. Default: `false`. For more information, see \"[Requiring a linear commit history](https://docs.github.com/enterprise-server@3.8/github/administering-a-repository/requiring-a-linear-commit-history)\" in the GitHub Help documentation.", "type": "boolean"}, "required_pull_request_reviews": {"description": "Require at least one approving review on a pull request, before merging. Set to `null` to disable.", "nullable": true, "properties": {"bypass_pull_request_allowances": {"description": "Allow specific users, teams, or apps to bypass pull request requirements.", "properties": {"apps": {"description": "The list of app `slug`s allowed to bypass pull request requirements.", "items": {"type": "string"}, "type": "array"}, "teams": {"description": "The list of team `slug`s allowed to bypass pull request requirements.", "items": {"type": "string"}, "type": "array"}, "users": {"description": "The list of user `login`s allowed to bypass pull request requirements.", "items": {"type": "string"}, "type": "array"}}, "type": "object"}, "dismiss_stale_reviews": {"description": "Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.", "type": "boolean"}, "dismissal_restrictions": {"description": "Specify which users, teams, and apps can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.", "properties": {"apps": {"description": "The list of app `slug`s with dismissal access", "items": {"type": "string"}, "type": "array"}, "teams": {"description": "The list of team `slug`s with dismissal access", "items": {"type": "string"}, "type": "array"}, "users": {"description": "The list of user `login`s with dismissal access", "items": {"type": "string"}, "type": "array"}}, "type": "object"}, "require_code_owner_reviews": {"description": "Blocks merging pull requests until [code owners](https://docs.github.com/enterprise-server@3.8/articles/about-code-owners/) review them.", "type": "boolean"}, "require_last_push_approval": {"default": false, "description": "Whether the most recent push must be approved by someone other than the person who pushed it. Default: `false`.", "type": "boolean"}, "required_approving_review_count": {"description": "Specify the number of reviewers required to approve pull requests. Use a number between 1 and 6 or 0 to not require reviewers.", "type": "integer"}}, "type": "object"}, "required_status_checks": {"description": "Require status checks to pass before merging. Set to `null` to disable.", "nullable": true, "properties": {"checks": {"description": "The list of status checks to require in order to merge into this branch.", "items": {"properties": {"app_id": {"description": "The ID of the GitHub App that must provide this check. Omit this field to automatically select the GitHub App that has recently provided this check, or any app if it was not set by a GitHub App. Pass -1 to explicitly allow any app to set the status.", "type": "integer"}, "context": {"description": "The name of the required check", "type": "string"}}, "required": ["context"], "type": "object"}, "type": "array"}, "contexts": {"deprecated": true, "description": "**Deprecated**: The list of status checks to require in order to merge into this branch. If any of these checks have recently been set by a particular GitHub App, they will be required to come from that app in future for the branch to merge. Use `checks` instead of `contexts` for more fine-grained control.\n", "items": {"type": "string"}, "type": "array"}, "strict": {"description": "Require branches to be up to date before merging.", "type": "boolean"}}, "required": ["strict", "contexts"], "type": "object"}, "restrictions": {"description": "Restrict who can push to the protected branch. User, app, and team `restrictions` are only available for organization-owned repositories. Set to `null` to disable.", "nullable": true, "properties": {"apps": {"description": "The list of app `slug`s with push access", "items": {"type": "string"}, "type": "array"}, "teams": {"description": "The list of team `slug`s with push access", "items": {"type": "string"}, "type": "array"}, "users": {"description": "The list of user `login`s with push access", "items": {"type": "string"}, "type": "array"}}, "required": ["users", "teams"], "type": "object"}}, "required": ["required_status_checks", "enforce_admins", "required_pull_request_reviews", "restrictions"], "type": "object"}',  # noqa: E501
    "UPDATEPULLREQUESTREVIEWPROTECTION": '{"properties": {"bypass_pull_request_allowances": {"description": "Allow specific users, teams, or apps to bypass pull request requirements.", "properties": {"apps": {"description": "The list of app `slug`s allowed to bypass pull request requirements.", "items": {"type": "string"}, "type": "array"}, "teams": {"description": "The list of team `slug`s allowed to bypass pull request requirements.", "items": {"type": "string"}, "type": "array"}, "users": {"description": "The list of user `login`s allowed to bypass pull request requirements.", "items": {"type": "string"}, "type": "array"}}, "type": "object"}, "dismiss_stale_reviews": {"description": "Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.", "type": "boolean"}, "dismissal_restrictions": {"description": "Specify which users, teams, and apps can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.", "properties": {"apps": {"description": "The list of app `slug`s with dismissal access", "items": {"type": "string"}, "type": "array"}, "teams": {"description": "The list of team `slug`s with dismissal access", "items": {"type": "string"}, "type": "array"}, "users": {"description": "The list of user `login`s with dismissal access", "items": {"type": "string"}, "type": "array"}}, "type": "object"}, "require_code_owner_reviews": {"description": "Blocks merging pull requests until [code owners](https://docs.github.com/enterprise-server@3.8/articles/about-code-owners/) have reviewed.", "type": "boolean"}, "require_last_push_approval": {"default": false, "description": "Whether the most recent push must be approved by someone other than the person who pushed it. Default: `false`", "type": "boolean"}, "required_approving_review_count": {"description": "Specifies the number of reviewers required to approve pull requests. Use a number between 1 and 6 or 0 to not require reviewers.", "type": "integer"}}, "type": "object"}',  # noqa: E501
    "UPDATEBRANCHSTATUSCHECKPROTECTION": '{"properties": {"checks": {"description": "The list of status checks to require in order to merge into this branch.", "items": {"properties": {"app_id": {"description": "The ID of the GitHub App that must provide this check. Omit this field to automatically select the GitHub App that has recently provided this check, or any app if it was not set by a GitHub App. Pass -1 to explicitly allow any app to set the status.", "type": "integer"}, "context": {"description": "The name of the required check", "type": "string"}}, "required": ["context"], "type": "object"}, "type": "array"}, "contexts": {"deprecated": true, "description": "**Deprecated**: The list of status checks to require in order to merge into this branch. If any of these checks have recently been set by a particular GitHub App, they will be required to come from that app in future for the branch to merge. Use `checks` instead of `contexts` for more fine-grained control.\n", "items": {"type": "string"}, "type": "array"}, "strict": {"description": "Require branches to be up to date before merging.", "type": "boolean"}}, "type": "object"}',  # noqa: E501
    "REMOVEBRANCHSTATUSCHECKCONTEXTS": '{"description": "The name of the status checks", "items": {"type": "string"}, "oneOf": [{"example": {"contexts": ["contexts"]}, "properties": {"contexts": {"description": "The name of the status checks", "items": {"type": "string"}, "type": "array"}}, "required": ["contexts"], "type": "object"}, {"description": "The name of the status checks", "items": {"type": "string"}, "type": "array"}], "type": "array"}',  # noqa: E501
    "ADDSTATUSCHECKCONTEXTSTOBRANCH": '{"description": "The name of the status checks", "items": {"type": "string"}, "oneOf": [{"example": {"contexts": ["contexts"]}, "properties": {"contexts": {"description": "The name of the status checks", "items": {"type": "string"}, "type": "array"}}, "required": ["contexts"], "type": "object"}, {"description": "The name of the status checks", "items": {"type": "string"}, "type": "array"}], "type": "array"}',  # noqa: E501
    "SETBRANCHSTATUSCHECKCONTEXTS": '{"description": "The name of the status checks", "items": {"type": "string"}, "oneOf": [{"example": {"contexts": ["contexts"]}, "properties": {"contexts": {"description": "The name of the status checks", "items": {"type": "string"}, "type": "array"}}, "required": ["contexts"], "type": "object"}, {"description": "The name of the status checks", "items": {"type": "string"}, "type": "array"}], "type": "array"}',  # noqa: E501
    "REMOVEGITHUBAPPBRANCHACCESS": '{"oneOf": [{"example": {"apps": ["my-app"]}, "properties": {"apps": {"description": "The GitHub Apps that have push access to this branch. Use the slugified version of the app name. **Note**: The list of users, apps, and teams in total is limited to 100 items.", "items": {"type": "string"}, "type": "array"}}, "required": ["apps"], "type": "object"}, {"items": {"type": "string"}, "type": "array"}]}',  # noqa: E501
    "ADDAPPACCESSRESTRICTIONS": '{"oneOf": [{"example": {"apps": ["my-app"]}, "properties": {"apps": {"description": "The GitHub Apps that have push access to this branch. Use the slugified version of the app name. **Note**: The list of users, apps, and teams in total is limited to 100 items.", "items": {"type": "string"}, "type": "array"}}, "required": ["apps"], "type": "object"}, {"items": {"type": "string"}, "type": "array"}]}',  # noqa: E501
    "SETBRANCHAPPACCESSRESTRICTIONS": '{"oneOf": [{"example": {"apps": ["my-app"]}, "properties": {"apps": {"description": "The GitHub Apps that have push access to this branch. Use the slugified version of the app name. **Note**: The list of users, apps, and teams in total is limited to 100 items.", "items": {"type": "string"}, "type": "array"}}, "required": ["apps"], "type": "object"}, {"items": {"type": "string"}, "type": "array"}]}',  # noqa: E501
    "REMOVETEAMACCESSFROMBRANCH": '{"description": "The slug values for teams", "items": {"type": "string"}, "oneOf": [{"example": {"teams": ["my-team"]}, "properties": {"teams": {"description": "The slug values for teams", "items": {"type": "string"}, "type": "array"}}, "required": ["teams"], "type": "object"}, {"description": "The slug values for teams", "items": {"type": "string"}, "type": "array"}], "type": "array"}',  # noqa: E501
    "ADDTEAMACCESSTOBRANCH": '{"description": "The slug values for teams", "items": {"type": "string"}, "oneOf": [{"example": {"teams": ["my-team"]}, "properties": {"teams": {"description": "The slug values for teams", "items": {"type": "string"}, "type": "array"}}, "required": ["teams"], "type": "object"}, {"description": "The slug values for teams", "items": {"type": "string"}, "type": "array"}], "type": "array"}',  # noqa: E501
    "SETGITHUBBRANCHTEAMACCESS": '{"description": "The slug values for teams", "items": {"type": "string"}, "oneOf": [{"example": {"teams": ["justice-league"]}, "properties": {"teams": {"description": "The slug values for teams", "items": {"type": "string"}, "type": "array"}}, "required": ["teams"], "type": "object"}, {"description": "The slug values for teams", "items": {"type": "string"}, "type": "array"}], "type": "array"}',  # noqa: E501
    "REMOVEUSERACCESSFROMBRANCH": '{"oneOf": [{"example": {"users": ["mona"]}, "properties": {"users": {"description": "The username for users", "items": {"type": "string"}, "type": "array"}}, "required": ["users"], "type": "object"}, {"items": {"type": "string"}, "type": "array"}]}',  # noqa: E501
    "GRANTPUSHACCESSGITHUBBRANCH": '{"oneOf": [{"example": {"users": ["mona"]}, "properties": {"users": {"description": "The username for users", "items": {"type": "string"}, "type": "array"}}, "required": ["users"], "type": "object"}, {"items": {"type": "string"}, "type": "array"}]}',  # noqa: E501
    "SETBRANCHUSERACCESSRESTRICTIONS": '{"oneOf": [{"example": {"users": ["mona"]}, "properties": {"users": {"description": "The username for users", "items": {"type": "string"}, "type": "array"}}, "required": ["users"], "type": "object"}, {"items": {"type": "string"}, "type": "array"}]}',  # noqa: E501
    "CREATEGITHUBCHECKRUN": '{"oneOf": [{"additionalProperties": true, "properties": {"status": {"enum": ["completed"]}}, "required": ["status", "conclusion"]}, {"additionalProperties": true, "properties": {"status": {"enum": ["queued", "in_progress"]}}}], "properties": {"actions": {"description": "Displays a button on GitHub that can be clicked to alert your app to do additional tasks. For example, a code linting app can display a button that automatically fixes detected errors. The button created in this object is displayed after the check run completes. When a user clicks the button, GitHub sends the [`check_run.requested_action` webhook](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads/#check_run) to your app. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. To learn more about check runs and requested actions, see \"[Check runs and requested actions](https://docs.github.com/enterprise-server@3.8/rest/reference/checks#check-runs-and-requested-actions).\"", "items": {"properties": {"description": {"description": "A short explanation of what this action would do. The maximum size is 40 characters.", "maxLength": 40, "type": "string"}, "identifier": {"description": "A reference for the action on the integrator\'s system. The maximum size is 20 characters.", "maxLength": 20, "type": "string"}, "label": {"description": "The text to be displayed on a button in the web UI. The maximum size is 20 characters.", "maxLength": 20, "type": "string"}}, "required": ["label", "description", "identifier"], "type": "object"}, "maxItems": 3, "type": "array"}, "completed_at": {"description": "The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.", "format": "date-time", "type": "string"}, "conclusion": {"description": "**Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. \n**Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. You cannot change a check run conclusion to `stale`, only GitHub can set this.", "enum": ["action_required", "cancelled", "failure", "neutral", "success", "skipped", "stale", "timed_out"], "type": "string"}, "details_url": {"description": "The URL of the integrator\'s site that has the full details of the check. If the integrator does not provide this, then the homepage of the GitHub app is used.", "type": "string"}, "external_id": {"description": "A reference for the run on the integrator\'s system.", "type": "string"}, "head_sha": {"description": "The SHA of the commit.", "type": "string"}, "name": {"description": "The name of the check. For example, \"code-coverage\".", "type": "string"}, "output": {"description": "Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run.", "properties": {"annotations": {"description": "Adds information from your analysis to specific lines of code. Annotations are visible on GitHub in the **Checks** and **Files changed** tab of the pull request. The Checks API limits the number of annotations to a maximum of 50 per API request. To create more than 50 annotations, you have to make multiple requests to the [Update a check run](https://docs.github.com/enterprise-server@3.8/rest/reference/checks#update-a-check-run) endpoint. Each time you update the check run, annotations are appended to the list of annotations that already exist for the check run. For details about how you can view annotations on GitHub, see \"[About status checks](https://docs.github.com/enterprise-server@3.8/articles/about-status-checks#checks)\".", "items": {"properties": {"annotation_level": {"description": "The level of the annotation.", "enum": ["notice", "warning", "failure"], "type": "string"}, "end_column": {"description": "The end column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.", "type": "integer"}, "end_line": {"description": "The end line of the annotation.", "type": "integer"}, "message": {"description": "A short description of the feedback for these lines of code. The maximum size is 64 KB.", "type": "string"}, "path": {"description": "The path of the file to add an annotation to. For example, `assets/css/main.css`.", "type": "string"}, "raw_details": {"description": "Details about this annotation. The maximum size is 64 KB.", "type": "string"}, "start_column": {"description": "The start column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values. Column numbers start at 1.", "type": "integer"}, "start_line": {"description": "The start line of the annotation. Line numbers start at 1.", "type": "integer"}, "title": {"description": "The title that represents the annotation. The maximum size is 255 characters.", "type": "string"}}, "required": ["path", "start_line", "end_line", "annotation_level", "message"], "type": "object"}, "maxItems": 50, "type": "array"}, "images": {"description": "Adds images to the output displayed in the GitHub pull request UI.", "items": {"properties": {"alt": {"description": "The alternative text for the image.", "type": "string"}, "caption": {"description": "A short image description.", "type": "string"}, "image_url": {"description": "The full URL of the image.", "type": "string"}}, "required": ["alt", "image_url"], "type": "object"}, "type": "array"}, "summary": {"description": "The summary of the check run. This parameter supports Markdown. **Maximum length**: 65535 characters.", "maxLength": 65535, "type": "string"}, "text": {"description": "The details of the check run. This parameter supports Markdown. **Maximum length**: 65535 characters.", "maxLength": 65535, "type": "string"}, "title": {"description": "The title of the check run.", "type": "string"}}, "required": ["title", "summary"], "type": "object"}, "started_at": {"description": "The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.", "format": "date-time", "type": "string"}, "status": {"default": "queued", "description": "The current status.", "enum": ["queued", "in_progress", "completed"], "type": "string"}}, "required": ["name", "head_sha"], "type": "object"}',  # noqa: E501
    "UPDATECHECKRUNSTATUS": '{"anyOf": [{"additionalProperties": true, "properties": {"status": {"enum": ["completed"]}}, "required": ["conclusion"]}, {"additionalProperties": true, "properties": {"status": {"enum": ["queued", "in_progress"]}}}], "properties": {"actions": {"description": "Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://docs.github.com/enterprise-server@3.8/rest/reference/checks#actions-object) description. To learn more about check runs and requested actions, see \"[Check runs and requested actions](https://docs.github.com/enterprise-server@3.8/rest/reference/checks#check-runs-and-requested-actions).\"", "items": {"properties": {"description": {"description": "A short explanation of what this action would do. The maximum size is 40 characters.", "maxLength": 40, "type": "string"}, "identifier": {"description": "A reference for the action on the integrator\'s system. The maximum size is 20 characters.", "maxLength": 20, "type": "string"}, "label": {"description": "The text to be displayed on a button in the web UI. The maximum size is 20 characters.", "maxLength": 20, "type": "string"}}, "required": ["label", "description", "identifier"], "type": "object"}, "maxItems": 3, "type": "array"}, "completed_at": {"description": "The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.", "format": "date-time", "type": "string"}, "conclusion": {"description": "**Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. \n**Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. You cannot change a check run conclusion to `stale`, only GitHub can set this.", "enum": ["action_required", "cancelled", "failure", "neutral", "success", "skipped", "stale", "timed_out"], "type": "string"}, "details_url": {"description": "The URL of the integrator\'s site that has the full details of the check.", "type": "string"}, "external_id": {"description": "A reference for the run on the integrator\'s system.", "type": "string"}, "name": {"description": "The name of the check. For example, \"code-coverage\".", "type": "string"}, "output": {"description": "Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run.", "properties": {"annotations": {"description": "Adds information from your analysis to specific lines of code. Annotations are visible in GitHub\'s pull request UI. Annotations are visible in GitHub\'s pull request UI. The Checks API limits the number of annotations to a maximum of 50 per API request. To create more than 50 annotations, you have to make multiple requests to the [Update a check run](https://docs.github.com/enterprise-server@3.8/rest/reference/checks#update-a-check-run) endpoint. Each time you update the check run, annotations are appended to the list of annotations that already exist for the check run. For details about annotations in the UI, see \"[About status checks](https://docs.github.com/enterprise-server@3.8/articles/about-status-checks#checks)\".", "items": {"properties": {"annotation_level": {"description": "The level of the annotation.", "enum": ["notice", "warning", "failure"], "type": "string"}, "end_column": {"description": "The end column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.", "type": "integer"}, "end_line": {"description": "The end line of the annotation.", "type": "integer"}, "message": {"description": "A short description of the feedback for these lines of code. The maximum size is 64 KB.", "type": "string"}, "path": {"description": "The path of the file to add an annotation to. For example, `assets/css/main.css`.", "type": "string"}, "raw_details": {"description": "Details about this annotation. The maximum size is 64 KB.", "type": "string"}, "start_column": {"description": "The start column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values. Column numbers start at 1.", "type": "integer"}, "start_line": {"description": "The start line of the annotation. Line numbers start at 1.", "type": "integer"}, "title": {"description": "The title that represents the annotation. The maximum size is 255 characters.", "type": "string"}}, "required": ["path", "start_line", "end_line", "annotation_level", "message"], "type": "object"}, "maxItems": 50, "type": "array"}, "images": {"description": "Adds images to the output displayed in the GitHub pull request UI.", "items": {"properties": {"alt": {"description": "The alternative text for the image.", "type": "string"}, "caption": {"description": "A short image description.", "type": "string"}, "image_url": {"description": "The full URL of the image.", "type": "string"}}, "required": ["alt", "image_url"], "type": "object"}, "type": "array"}, "summary": {"description": "Can contain Markdown.", "maxLength": 65535, "type": "string"}, "text": {"description": "Can contain Markdown.", "maxLength": 65535, "type": "string"}, "title": {"description": "**Required**.", "type": "string"}}, "required": ["summary"], "type": "object"}, "started_at": {"description": "This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.", "format": "date-time", "type": "string"}, "status": {"description": "The current status.", "enum": ["queued", "in_progress", "completed"], "type": "string"}}, "type": "object"}',  # noqa: E501
    "SETCHECKSUITEPREFERENCES": '{"properties": {"auto_trigger_checks": {"description": "Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default.", "items": {"properties": {"app_id": {"description": "The `id` of the GitHub App.", "type": "integer"}, "setting": {"default": true, "description": "Set to `true` to enable automatic creation of CheckSuite events upon pushes to the repository, or `false` to disable them.", "type": "boolean"}}, "required": ["app_id", "setting"], "type": "object"}, "type": "array"}}, "type": "object"}',  # noqa: E501
    "UPDATEORCREATEGITHUBFILE": '{"properties": {"author": {"description": "The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.", "properties": {"date": {"example": "\"2013-01-15T17:13:22+05:00\"", "type": "string"}, "email": {"description": "The email of the author or committer of the commit. You\'ll receive a `422` status code if `email` is omitted.", "type": "string"}, "name": {"description": "The name of the author or committer of the commit. You\'ll receive a `422` status code if `name` is omitted.", "type": "string"}}, "required": ["name", "email"], "type": "object"}, "branch": {"description": "The branch name. Default: the repository\u2019s default branch (usually `master`)", "type": "string"}, "committer": {"description": "The person that committed the file. Default: the authenticated user.", "properties": {"date": {"example": "\"2013-01-05T13:13:22+05:00\"", "type": "string"}, "email": {"description": "The email of the author or committer of the commit. You\'ll receive a `422` status code if `email` is omitted.", "type": "string"}, "name": {"description": "The name of the author or committer of the commit. You\'ll receive a `422` status code if `name` is omitted.", "type": "string"}}, "required": ["name", "email"], "type": "object"}, "content": {"description": "The new file content, using Base64 encoding.", "type": "string"}, "message": {"description": "The commit message.", "type": "string"}, "sha": {"description": "**Required if you are updating a file**. The blob SHA of the file being replaced.", "type": "string"}}, "required": ["message", "content"], "type": "object"}',  # noqa: E501
    "CREATEREPODEPENDENCYSNAPSHOT": '{"additionalProperties": false, "description": "Create a new snapshot of a repository\'s dependencies.", "properties": {"detector": {"additionalProperties": false, "description": "A description of the detector used.", "properties": {"name": {"description": "The name of the detector used.", "example": "docker buildtime detector", "type": "string"}, "url": {"description": "The url of the detector used.", "example": "http://example.com/docker-buildtimer-detector", "type": "string"}, "version": {"description": "The version of the detector used.", "example": "1.0.0", "type": "string"}}, "required": ["name", "version", "url"], "type": "object"}, "job": {"additionalProperties": false, "properties": {"correlator": {"description": "Correlator provides a key that is used to group snapshots submitted over time. Only the \"latest\" submitted snapshot for a given combination of `job.correlator` and `detector.name` will be considered when calculating a repository\'s current dependencies. Correlator should be as unique as it takes to distinguish all detection runs for a given \"wave\" of CI workflow you run. If you\'re using GitHub Actions, a good default value for this could be the environment variables GITHUB_WORKFLOW and GITHUB_JOB concatenated together. If you\'re using a build matrix, then you\'ll also need to add additional key(s) to distinguish between each submission inside a matrix variation.", "example": "yourworkflowname_yourjobname", "type": "string"}, "html_url": {"description": "The url for the job.", "example": "http://example.com/build", "type": "string"}, "id": {"description": "The external ID of the job.", "example": "5622a2b0-63f6-4732-8c34-a1ab27e102a11", "type": "string"}}, "required": ["id", "correlator"], "type": "object"}, "manifests": {"additionalProperties": {"additionalProperties": false, "properties": {"file": {"additionalProperties": false, "properties": {"source_location": {"description": "The path of the manifest file relative to the root of the Git repository.", "example": "/src/build/package-lock.json", "type": "string"}}, "type": "object"}, "metadata": {"additionalProperties": {"anyOf": [{"type": "string"}, {"type": "number"}, {"type": "boolean"}], "nullable": true}, "description": "User-defined metadata to store domain-specific information limited to 8 keys with scalar values.", "maxProperties": 8, "title": "metadata", "type": "object"}, "name": {"description": "The name of the manifest.", "example": "package-lock.json", "type": "string"}, "resolved": {"additionalProperties": {"additionalProperties": false, "properties": {"dependencies": {"description": "Array of package-url (PURLs) of direct child dependencies.", "example": "@actions/http-client", "items": {"type": "string"}, "type": "array"}, "metadata": {"additionalProperties": {"anyOf": [{"type": "string"}, {"type": "number"}, {"type": "boolean"}], "nullable": true}, "description": "User-defined metadata to store domain-specific information limited to 8 keys with scalar values.", "maxProperties": 8, "title": "metadata", "type": "object"}, "package_url": {"description": "Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details.", "example": "pkg:/npm/%40actions/http-client@1.0.11", "pattern": "^pkg", "type": "string"}, "relationship": {"description": "A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.", "enum": ["direct", "indirect"], "example": "direct", "type": "string"}, "scope": {"description": "A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.", "enum": ["runtime", "development"], "example": "runtime", "type": "string"}}, "type": "object"}, "description": "A collection of resolved package dependencies.", "type": "object"}}, "required": ["name"], "type": "object"}, "description": "A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies.", "type": "object"}, "metadata": {"additionalProperties": {"anyOf": [{"type": "string"}, {"type": "number"}, {"type": "boolean"}], "nullable": true}, "description": "User-defined metadata to store domain-specific information limited to 8 keys with scalar values.", "maxProperties": 8, "title": "metadata", "type": "object"}, "ref": {"description": "The repository branch that triggered this snapshot.", "example": "refs/heads/main", "pattern": "^refs/", "type": "string"}, "scanned": {"description": "The time at which the snapshot was scanned.", "example": "2020-06-13T14:52:50-05:00", "format": "date-time", "type": "string"}, "sha": {"description": "The commit SHA associated with this dependency snapshot. Maximum length: 40 characters.", "example": "ddc951f4b1293222421f2c8df679786153acf689", "maxLength": 40, "minLength": 40, "type": "string"}, "version": {"description": "The version of the repository snapshot submission.", "type": "integer"}}, "required": ["detector", "version", "ref", "sha", "job", "scanned"], "title": "snapshot", "type": "object"}',  # noqa: E501
    "CREATEGITHUBDEPLOYMENT": '{"properties": {"auto_merge": {"default": true, "description": "Attempts to automatically merge the default branch into the requested ref, if it\'s behind the default branch.", "type": "boolean"}, "description": {"default": "", "description": "Short description of the deployment.", "nullable": true, "type": "string"}, "environment": {"default": "production", "description": "Name for the target deployment environment (e.g., `production`, `staging`, `qa`).", "type": "string"}, "payload": {"oneOf": [{"additionalProperties": true, "type": "object"}, {"default": "", "description": "JSON payload with extra information about the deployment.", "type": "string"}]}, "production_environment": {"description": "Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.", "type": "boolean"}, "ref": {"description": "The ref to deploy. This can be a branch, tag, or SHA.", "type": "string"}, "required_contexts": {"description": "The [status](https://docs.github.com/enterprise-server@3.8/rest/commits/statuses) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.", "items": {"type": "string"}, "type": "array"}, "task": {"default": "deploy", "description": "Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).", "type": "string"}, "transient_environment": {"default": false, "description": "Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`", "type": "boolean"}}, "required": ["ref"], "type": "object"}',  # noqa: E501
    "TRIGGERGITHUBDISPATCHEVENT": '{"properties": {"client_payload": {"additionalProperties": true, "description": "JSON payload with extra information about the webhook event that your action or workflow may use. The maximum number of top-level properties is 10.", "maxProperties": 10, "type": "object"}, "event_type": {"description": "A custom webhook event name. Must be 100 characters or fewer.", "maxLength": 100, "minLength": 1, "type": "string"}}, "required": ["event_type"], "type": "object"}',  # noqa: E501
    "GITHUBMANAGEENVIRONMENT": '{"additionalProperties": false, "nullable": true, "properties": {"deployment_branch_policy": {"description": "The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`.", "nullable": true, "properties": {"custom_branch_policies": {"description": "Whether only branches that match the specified name patterns can deploy to this environment.  If `custom_branch_policies` is `true`, `protected_branches` must be `false`; if `custom_branch_policies` is `false`, `protected_branches` must be `true`.", "type": "boolean"}, "protected_branches": {"description": "Whether only branches with branch protection rules can deploy to this environment. If `protected_branches` is `true`, `custom_branch_policies` must be `false`; if `protected_branches` is `false`, `custom_branch_policies` must be `true`.", "type": "boolean"}}, "required": ["protected_branches", "custom_branch_policies"], "type": "object"}, "reviewers": {"description": "The people or teams that may review jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.", "items": {"properties": {"id": {"description": "The id of the user or team who can review the deployment", "example": 4532992, "type": "integer"}, "type": {"description": "The type of reviewer.", "enum": ["User", "Team"], "example": "User", "type": "string"}}, "type": "object"}, "nullable": true, "type": "array"}, "wait_timer": {"description": "The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days).", "example": 30, "type": "integer"}}, "type": "object"}',  # noqa: E501
    "CREATEGITCOMMIT": '{"properties": {"author": {"description": "Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.", "properties": {"date": {"description": "Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.", "format": "date-time", "type": "string"}, "email": {"description": "The email of the author (or committer) of the commit", "type": "string"}, "name": {"description": "The name of the author (or committer) of the commit", "type": "string"}}, "required": ["name", "email"], "type": "object"}, "committer": {"description": "Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.", "properties": {"date": {"description": "Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.", "format": "date-time", "type": "string"}, "email": {"description": "The email of the author (or committer) of the commit", "type": "string"}, "name": {"description": "The name of the author (or committer) of the commit", "type": "string"}}, "type": "object"}, "message": {"description": "The commit message", "type": "string"}, "parents": {"description": "The SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.", "items": {"type": "string"}, "type": "array"}, "signature": {"description": "The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.", "type": "string"}, "tree": {"description": "The SHA of the tree object this commit points to", "type": "string"}}, "required": ["message", "tree"], "type": "object"}',  # noqa: E501
    "CREATEGITTREE": '{"properties": {"base_tree": {"description": "The SHA1 of an existing Git tree object which will be used as the base for the new tree. If provided, a new Git tree object will be created from entries in the Git tree object pointed to by `base_tree` and entries defined in the `tree` parameter. Entries defined in the `tree` parameter will overwrite items from `base_tree` with the same `path`. If you\'re creating new changes on a branch, then normally you\'d set `base_tree` to the SHA1 of the Git tree object of the current latest commit on the branch you\'re working on.\nIf not provided, GitHub will create a new Git tree object from only the entries defined in the `tree` parameter. If you create a new commit pointing to such a tree, then all files which were a part of the parent commit\'s tree and were not defined in the `tree` parameter will be listed as deleted by the new commit.\n", "type": "string"}, "tree": {"description": "Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.", "items": {"properties": {"content": {"description": "The content you want this file to have. GitHub will write this blob out and use that SHA for this entry. Use either this, or `tree.sha`.  \n  \n**Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.", "type": "string"}, "mode": {"description": "The file mode; one of `100644` for file (blob), `100755` for executable (blob), `040000` for subdirectory (tree), `160000` for submodule (commit), or `120000` for a blob that specifies the path of a symlink.", "enum": ["100644", "100755", "040000", "160000", "120000"], "type": "string"}, "path": {"description": "The file referenced in the tree.", "type": "string"}, "sha": {"description": "The SHA1 checksum ID of the object in the tree. Also called `tree.sha`. If the value is `null` then the file will be deleted.  \n  \n**Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.", "nullable": true, "type": "string"}, "type": {"description": "Either `blob`, `tree`, or `commit`.", "enum": ["blob", "tree", "commit"], "type": "string"}}, "type": "object"}, "type": "array"}}, "required": ["tree"], "type": "object"}',  # noqa: E501
    "CREATEGITHUBREPOWEBHOOK": '{"additionalProperties": false, "nullable": true, "properties": {"active": {"default": true, "description": "Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.", "type": "boolean"}, "config": {"description": "Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/enterprise-server@3.8/rest/reference/repos#create-hook-config-params).", "properties": {"content_type": {"description": "The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.", "example": "\"json\"", "type": "string"}, "digest": {"example": "\"sha256\"", "type": "string"}, "insecure_ssl": {"oneOf": [{"description": "Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**", "example": "\"0\"", "type": "string"}, {"type": "number"}]}, "secret": {"description": "If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads/#delivery-headers).", "example": "\"********\"", "type": "string"}, "token": {"example": "\"abc\"", "type": "string"}, "url": {"description": "The URL to which the payloads will be delivered.", "example": "https://example.com/webhook", "format": "uri", "type": "string"}}, "type": "object"}, "events": {"default": ["push"], "description": "Determines what [events](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads) the hook is triggered for.", "items": {"type": "string"}, "type": "array"}, "name": {"description": "Use `web` to create a webhook. Default: `web`. This parameter only accepts the value `web`.", "type": "string"}}, "type": "object"}',  # noqa: E501
    "UPDATEGITHUBREPOWEBHOOK": '{"properties": {"active": {"default": true, "description": "Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.", "type": "boolean"}, "add_events": {"description": "Determines a list of events to be added to the list of events that the Hook triggers for.", "items": {"type": "string"}, "type": "array"}, "config": {"description": "Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/enterprise-server@3.8/rest/reference/repos#create-hook-config-params).", "properties": {"address": {"example": "\"bar@example.com\"", "type": "string"}, "content_type": {"description": "The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.", "example": "\"json\"", "type": "string"}, "insecure_ssl": {"oneOf": [{"description": "Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**", "example": "\"0\"", "type": "string"}, {"type": "number"}]}, "room": {"example": "\"The Serious Room\"", "type": "string"}, "secret": {"description": "If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads/#delivery-headers).", "example": "\"********\"", "type": "string"}, "url": {"description": "The URL to which the payloads will be delivered.", "example": "https://example.com/webhook", "format": "uri", "type": "string"}}, "required": ["url"], "type": "object"}, "events": {"default": ["push"], "description": "Determines what [events](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads) the hook is triggered for. This replaces the entire array of events.", "items": {"type": "string"}, "type": "array"}, "remove_events": {"description": "Determines a list of events to be removed from the list of events that the Hook triggers for.", "items": {"type": "string"}, "type": "array"}}, "type": "object"}',  # noqa: E501
    "UPDATEREPOWEBHOOKCONFIG": '{"additionalProperties": false, "properties": {"content_type": {"description": "The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.", "example": "\"json\"", "type": "string"}, "insecure_ssl": {"oneOf": [{"description": "Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**", "example": "\"0\"", "type": "string"}, {"type": "number"}]}, "secret": {"description": "If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/enterprise-server@3.8/webhooks/event-payloads/#delivery-headers).", "example": "\"********\"", "type": "string"}, "url": {"description": "The URL to which the payloads will be delivered.", "example": "https://example.com/webhook", "format": "uri", "type": "string"}}, "type": "object"}',  # noqa: E501
    "CREATEGITHUBISSUE": '{"properties": {"assignee": {"description": "Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is deprecated.**_", "nullable": true, "type": "string"}, "assignees": {"description": "Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._", "items": {"type": "string"}, "type": "array"}, "body": {"description": "The contents of the issue.", "type": "string"}, "labels": {"description": "Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._", "items": {"oneOf": [{"type": "string"}, {"properties": {"color": {"nullable": true, "type": "string"}, "description": {"nullable": true, "type": "string"}, "id": {"type": "integer"}, "name": {"type": "string"}}, "type": "object"}]}, "type": "array"}, "milestone": {"nullable": true, "oneOf": [{"type": "string"}, {"description": "The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._", "type": "integer"}]}, "title": {"description": "The title of the issue.", "oneOf": [{"type": "string"}, {"type": "integer"}]}}, "required": ["title"], "type": "object"}',  # noqa: E501
    "UPDATEGITHUBISSUE": '{"properties": {"assignee": {"description": "Username to assign to this issue. **This field is deprecated.**", "nullable": true, "type": "string"}, "assignees": {"description": "Usernames to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this issue. Send an empty array (`[]`) to clear all assignees from the issue. Only users with push access can set assignees for new issues. Without push access to the repository, assignee changes are silently dropped.", "items": {"type": "string"}, "type": "array"}, "body": {"description": "The contents of the issue.", "nullable": true, "type": "string"}, "labels": {"description": "Labels to associate with this issue. Pass one or more labels to _replace_ the set of labels on this issue. Send an empty array (`[]`) to clear all labels from the issue. Only users with push access can set labels for issues. Without push access to the repository, label changes are silently dropped.", "items": {"oneOf": [{"type": "string"}, {"properties": {"color": {"nullable": true, "type": "string"}, "description": {"nullable": true, "type": "string"}, "id": {"type": "integer"}, "name": {"type": "string"}}, "type": "object"}]}, "type": "array"}, "milestone": {"nullable": true, "oneOf": [{"type": "string"}, {"description": "The `number` of the milestone to associate this issue with or use `null` to remove the current milestone. Only users with push access can set the milestone for issues. Without push access to the repository, milestone changes are silently dropped.", "type": "integer"}]}, "state": {"description": "The open or closed state of the issue.", "enum": ["open", "closed"], "type": "string"}, "state_reason": {"description": "The reason for the state change. Ignored unless `state` is changed.", "enum": ["completed", "not_planned", "reopened"], "example": "not_planned", "nullable": true, "type": "string"}, "title": {"description": "The title of the issue.", "nullable": true, "oneOf": [{"type": "string"}, {"type": "integer"}]}}, "type": "object"}',  # noqa: E501
    "ADDLABELSTOGITHUBISSUE": '{"oneOf": [{"properties": {"labels": {"description": "The names of the labels to add to the issue\'s existing labels. You can pass an empty array to remove all labels. Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key. You can also replace all of the labels for an issue. For more information, see \"[Set labels for an issue](https://docs.github.com/enterprise-server@3.8/rest/reference/issues#set-labels-for-an-issue).\"", "items": {"type": "string"}, "minItems": 1, "type": "array"}}, "type": "object"}, {"items": {"type": "string"}, "minItems": 1, "type": "array"}, {"properties": {"labels": {"items": {"properties": {"name": {"type": "string"}}, "required": ["name"], "type": "object"}, "minItems": 1, "type": "array"}}, "type": "object"}, {"items": {"properties": {"name": {"type": "string"}}, "required": ["name"], "type": "object"}, "minItems": 1, "type": "array"}, {"type": "string"}]}',  # noqa: E501
    "SETGITHUBISSUELABELS": '{"oneOf": [{"properties": {"labels": {"description": "The names of the labels to set for the issue. The labels you set replace any existing labels. You can pass an empty array to remove all labels. Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key. You can also add labels to the existing labels for an issue. For more information, see \"[Add labels to an issue](https://docs.github.com/enterprise-server@3.8/rest/reference/issues#add-labels-to-an-issue).\"", "items": {"type": "string"}, "minItems": 1, "type": "array"}}, "type": "object"}, {"items": {"type": "string"}, "minItems": 1, "type": "array"}, {"properties": {"labels": {"items": {"properties": {"name": {"type": "string"}}, "required": ["name"], "type": "object"}, "minItems": 1, "type": "array"}}, "type": "object"}, {"items": {"properties": {"name": {"type": "string"}}, "required": ["name"], "type": "object"}, "minItems": 1, "type": "array"}, {"type": "string"}]}',  # noqa: E501
    "CONFIGUREGITHUBPAGESSITE": '{"anyOf": [{"required": ["source"]}, {"required": ["build_type"]}], "description": "The source branch and directory used to publish your Pages site.", "nullable": true, "properties": {"build_type": {"description": "The process in which the Page will be built. Possible values are `\"legacy\"` and `\"workflow\"`.", "enum": ["legacy", "workflow"], "type": "string"}, "source": {"description": "The source branch and directory used to publish your Pages site.", "properties": {"branch": {"description": "The repository branch used to publish your site\'s source files.", "type": "string"}, "path": {"default": "/", "description": "The repository directory that includes the source files for the Pages site. Allowed paths are `/` or `/docs`. Default: `/`", "enum": ["/", "/docs"], "type": "string"}}, "required": ["branch"], "type": "object"}}, "type": "object"}',  # noqa: E501
    "UPDATEGITHUBPAGESINFO": '{"anyOf": [{"required": ["build_type"]}, {"required": ["source"]}, {"required": ["cname"]}, {"required": ["public"]}, {"required": ["https_enforced"]}], "properties": {"build_type": {"description": "The process by which the GitHub Pages site will be built. `workflow` means that the site is built by a custom GitHub Actions workflow. `legacy` means that the site is built by GitHub when changes are pushed to a specific branch.", "enum": ["legacy", "workflow"], "type": "string"}, "cname": {"description": "Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see \"[Using a custom domain with GitHub Pages](https://docs.github.com/enterprise-server@3.8/articles/using-a-custom-domain-with-github-pages/).\"", "nullable": true, "type": "string"}, "https_enforced": {"description": "Specify whether HTTPS should be enforced for the repository.", "type": "boolean"}, "source": {"anyOf": [{"description": "Update the source for the repository. Must include the branch name, and may optionally specify the subdirectory `/docs`. Possible values are `\"gh-pages\"`, `\"master\"`, and `\"master /docs\"`.", "enum": ["gh-pages", "master", "master /docs"], "type": "string"}, {"description": "Update the source for the repository. Must include the branch name and path.", "properties": {"branch": {"description": "The repository branch used to publish your site\'s source files.", "type": "string"}, "path": {"description": "The repository directory that includes the source files for the Pages site. Allowed paths are `/` or `/docs`.", "enum": ["/", "/docs"], "type": "string"}}, "required": ["branch", "path"], "type": "object"}]}}, "type": "object"}',  # noqa: E501
    "CREATEPULLREQUESTREVIEWCOMMENT": '{"properties": {"body": {"description": "The text of the review comment.", "type": "string"}, "commit_id": {"description": "The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.", "type": "string"}, "in_reply_to": {"description": "The ID of the review comment to reply to. To find the ID of a review comment with [\"List review comments on a pull request\"](#list-review-comments-on-a-pull-request). When specified, all parameters other than `body` in the request body are ignored.", "example": 2, "type": "integer"}, "line": {"description": "The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.", "type": "integer"}, "path": {"description": "The relative path to the file that necessitates a comment.", "type": "string"}, "position": {"deprecated": true, "description": "**This parameter is deprecated. Use `line` instead**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.", "type": "integer", "x-github": {"deprecationDate": "2022-11-01"}}, "side": {"description": "In a split diff view, the side of the diff that the pull request\'s changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see \"[Diff view options](https://docs.github.com/enterprise-server@3.8/articles/about-comparing-branches-in-pull-requests#diff-view-options)\" in the GitHub Help documentation.", "enum": ["LEFT", "RIGHT"], "type": "string"}, "start_line": {"description": "**Required when using multi-line comments unless using `in_reply_to`**. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see \"[Commenting on a pull request](https://docs.github.com/enterprise-server@3.8/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)\" in the GitHub Help documentation.", "type": "integer"}, "start_side": {"description": "**Required when using multi-line comments unless using `in_reply_to`**. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see \"[Commenting on a pull request](https://docs.github.com/enterprise-server@3.8/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)\" in the GitHub Help documentation. See `side` in this table for additional context.", "enum": ["LEFT", "RIGHT", "side"], "type": "string"}}, "required": ["body", "commit_id", "path", "line"], "type": "object"}',  # noqa: E501
    "REQUESTGITHUBPULLREQUESTREVIEWERS": '{"anyOf": [{"required": ["reviewers"]}, {"required": ["team_reviewers"]}], "properties": {"reviewers": {"description": "An array of user `login`s that will be requested.", "items": {"type": "string"}, "type": "array"}, "team_reviewers": {"description": "An array of team `slug`s that will be requested.", "items": {"type": "string"}, "type": "array"}}, "type": "object"}',  # noqa: E501
    "CREATEGITHUBPULLREQUESTREVIEW": '{"properties": {"body": {"description": "**Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.", "type": "string"}, "comments": {"description": "Use the following table to specify the location, destination, and contents of the draft review comment.", "items": {"properties": {"body": {"description": "Text of the review comment.", "type": "string"}, "line": {"example": 28, "type": "integer"}, "path": {"description": "The relative path to the file that necessitates a review comment.", "type": "string"}, "position": {"description": "The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note below.", "type": "integer"}, "side": {"example": "RIGHT", "type": "string"}, "start_line": {"example": 26, "type": "integer"}, "start_side": {"example": "LEFT", "type": "string"}}, "required": ["path", "body"], "type": "object"}, "type": "array"}, "commit_id": {"description": "The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.", "type": "string"}, "event": {"description": "The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://docs.github.com/enterprise-server@3.8/rest/pulls#submit-a-review-for-a-pull-request) when you are ready.", "enum": ["APPROVE", "REQUEST_CHANGES", "COMMENT"], "type": "string"}}, "type": "object"}',  # noqa: E501
    "CREATEENTERPRISESCIMGROUP": '{"properties": {"displayName": {"description": "A human-readable name for a security group.", "example": "Engineering", "type": "string"}, "externalId": {"description": "A unique identifier for the resource as defined by the provisioning client.", "example": "8aa1a0c0-c4c3-4bc0-b4a5-2ef676900159", "type": "string"}, "members": {"description": "The group members.", "items": {"properties": {"displayName": {"description": "The display name associated with the member", "example": "Monalisa Octocat", "type": "string"}, "value": {"description": "The local unique identifier for the member", "example": "23a35c27-23d3-4c03-b4c5-6443c09e7173", "type": "string"}}, "required": ["value", "displayName"], "type": "object"}, "type": "array"}, "schemas": {"description": "The URIs that are used to indicate the namespaces of the SCIM schemas.", "example": ["urn:ietf:params:scim:schemas:core:2.0:Group"], "items": {"enum": ["urn:ietf:params:scim:schemas:core:2.0:Group"], "type": "string"}, "type": "array"}}, "required": ["schemas", "externalId", "displayName", "members"], "type": "object"}',  # noqa: E501
    "UPDATEENTERPRISEGROUPATTRIBUTES": '{"properties": {"Operations": {"description": "patch operations list", "items": {"properties": {"op": {"enum": ["add", "replace", "remove"], "type": "string"}, "path": {"type": "string"}, "value": {"description": "Corresponding \'value\' of that field specified by \'path\'", "type": "string"}}, "required": ["op"], "type": "object"}, "type": "array"}, "schemas": {"items": {"enum": ["urn:ietf:params:scim:api:messages:2.0:PatchOp"], "type": "string"}, "type": "array"}}, "required": ["Operations", "schemas"], "type": "object"}',  # noqa: E501
    "UPDATEENTERPRISEGROUPINFO": '{"properties": {"displayName": {"description": "A human-readable name for a security group.", "example": "Engineering", "type": "string"}, "externalId": {"description": "A unique identifier for the resource as defined by the provisioning client.", "example": "8aa1a0c0-c4c3-4bc0-b4a5-2ef676900159", "type": "string"}, "members": {"description": "The group members.", "items": {"properties": {"displayName": {"description": "The display name associated with the member", "example": "Monalisa Octocat", "type": "string"}, "value": {"description": "The local unique identifier for the member", "example": "23a35c27-23d3-4c03-b4c5-6443c09e7173", "type": "string"}}, "required": ["value", "displayName"], "type": "object"}, "type": "array"}, "schemas": {"description": "The URIs that are used to indicate the namespaces of the SCIM schemas.", "example": ["urn:ietf:params:scim:schemas:core:2.0:Group"], "items": {"enum": ["urn:ietf:params:scim:schemas:core:2.0:Group"], "type": "string"}, "type": "array"}}, "required": ["schemas", "externalId", "displayName", "members"], "type": "object"}',  # noqa: E501
    "PROVISIONENTERPRISEUSER": '{"properties": {"active": {"description": "Whether the user active in the IdP.", "example": true, "type": "boolean"}, "displayName": {"description": "A human-readable name for the user.", "example": "Mona Lisa", "type": "string"}, "emails": {"description": "The emails for the user.", "items": {"properties": {"primary": {"description": "Whether this email address is the primary address.", "example": true, "type": "boolean"}, "type": {"description": "The type of email address.", "example": "work", "type": "string"}, "value": {"description": "The email address.", "example": "mlisa@example.com", "type": "string"}}, "required": ["value", "type", "primary"], "type": "object"}, "type": "array"}, "externalId": {"description": "A unique identifier for the resource as defined by the provisioning client.", "example": "E012345", "type": "string"}, "name": {"properties": {"familyName": {"description": "The family name of the user.", "example": "Octocat", "type": "string"}, "formatted": {"description": "The full name, including all middle names, titles, and suffixes as appropriate, formatted for display.", "example": "Ms. Mona Lisa Octocat", "type": "string"}, "givenName": {"description": "The given name of the user.", "example": "Mona", "type": "string"}, "middleName": {"description": "The middle name(s) of the user.", "example": "Lisa", "type": "string"}}, "required": ["familyName", "givenName"], "type": "object"}, "roles": {"description": "The roles assigned to the user.", "items": {"properties": {"display": {"type": "string"}, "primary": {"description": "Is the role a primary role for the user.", "example": false, "type": "boolean"}, "type": {"type": "string"}, "value": {"description": "The role value representing a user role in GitHub.", "enum": ["User", "user", "27d9891d-2c17-4f45-a262-781a0e55c80a", "Restricted User", "restricted_user", "1ebc4a02-e56c-43a6-92a5-02ee09b90824", "Enterprise Owner", "enterprise_owner", "981df190-8801-4618-a08a-d91f6206c954", "ba4987ab-a1c3-412a-b58c-360fc407cb10", "Billing Manager", "billing_manager", "0e338b8c-cc7f-498a-928d-ea3470d7e7e3", "e6be2762-e4ad-4108-b72d-1bbe884a0f91"], "example": "user", "type": "string"}}, "required": ["value"], "type": "object"}, "type": "array"}, "schemas": {"description": "The URIs that are used to indicate the namespaces of the SCIM schemas.", "example": ["urn:ietf:params:scim:schemas:core:2.0:User"], "items": {"enum": ["urn:ietf:params:scim:schemas:core:2.0:User"], "type": "string"}, "type": "array"}, "userName": {"description": "The username for the user.", "example": "E012345", "type": "string"}}, "required": ["schemas", "externalId", "userName", "active", "displayName", "emails"], "type": "object"}',  # noqa: E501
    "UPDATEENTERPRISEUSERATTRIBUTE": '{"properties": {"Operations": {"description": "patch operations list", "items": {"properties": {"op": {"enum": ["add", "replace", "remove"], "type": "string"}, "path": {"type": "string"}, "value": {"description": "Corresponding \'value\' of that field specified by \'path\'", "type": "string"}}, "required": ["op"], "type": "object"}, "type": "array"}, "schemas": {"items": {"enum": ["urn:ietf:params:scim:api:messages:2.0:PatchOp"], "type": "string"}, "type": "array"}}, "required": ["Operations", "schemas"], "type": "object"}',  # noqa: E501
    "UPDATEPROVISIONEDENTERPRISEUSERINFO": '{"properties": {"active": {"description": "Whether the user active in the IdP.", "example": true, "type": "boolean"}, "displayName": {"description": "A human-readable name for the user.", "example": "Mona Lisa", "type": "string"}, "emails": {"description": "The emails for the user.", "items": {"properties": {"primary": {"description": "Whether this email address is the primary address.", "example": true, "type": "boolean"}, "type": {"description": "The type of email address.", "example": "work", "type": "string"}, "value": {"description": "The email address.", "example": "mlisa@example.com", "type": "string"}}, "required": ["value", "type", "primary"], "type": "object"}, "type": "array"}, "externalId": {"description": "A unique identifier for the resource as defined by the provisioning client.", "example": "E012345", "type": "string"}, "name": {"properties": {"familyName": {"description": "The family name of the user.", "example": "Octocat", "type": "string"}, "formatted": {"description": "The full name, including all middle names, titles, and suffixes as appropriate, formatted for display.", "example": "Ms. Mona Lisa Octocat", "type": "string"}, "givenName": {"description": "The given name of the user.", "example": "Mona", "type": "string"}, "middleName": {"description": "The middle name(s) of the user.", "example": "Lisa", "type": "string"}}, "required": ["familyName", "givenName"], "type": "object"}, "roles": {"description": "The roles assigned to the user.", "items": {"properties": {"display": {"type": "string"}, "primary": {"description": "Is the role a primary role for the user.", "example": false, "type": "boolean"}, "type": {"type": "string"}, "value": {"description": "The role value representing a user role in GitHub.", "enum": ["User", "user", "27d9891d-2c17-4f45-a262-781a0e55c80a", "Restricted User", "restricted_user", "1ebc4a02-e56c-43a6-92a5-02ee09b90824", "Enterprise Owner", "enterprise_owner", "981df190-8801-4618-a08a-d91f6206c954", "ba4987ab-a1c3-412a-b58c-360fc407cb10", "Billing Manager", "billing_manager", "0e338b8c-cc7f-498a-928d-ea3470d7e7e3", "e6be2762-e4ad-4108-b72d-1bbe884a0f91"], "example": "user", "type": "string"}}, "required": ["value"], "type": "object"}, "type": "array"}, "schemas": {"description": "The URIs that are used to indicate the namespaces of the SCIM schemas.", "example": ["urn:ietf:params:scim:schemas:core:2.0:User"], "items": {"enum": ["urn:ietf:params:scim:schemas:core:2.0:User"], "type": "string"}, "type": "array"}, "userName": {"description": "The username for the user.", "example": "E012345", "type": "string"}}, "required": ["schemas", "externalId", "userName", "active", "displayName", "emails"], "type": "object"}',  # noqa: E501
    "DELETEUSEREMAIL": '{"oneOf": [{"description": "Deletes one or more email addresses from your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.", "example": {"emails": ["octocat@github.com", "mona@github.com"]}, "properties": {"emails": {"description": "Email addresses associated with the GitHub user account.", "items": {"example": "username@example.com", "minItems": 1, "type": "string"}, "type": "array"}}, "required": ["emails"], "type": "object"}, {"items": {"example": "username@example.com", "minItems": 1, "type": "string"}, "type": "array"}, {"type": "string"}]}',  # noqa: E501
    "ADDEMAILTOGITHUBACCOUNT": '{"oneOf": [{"example": {"emails": ["octocat@github.com", "mona@github.com"]}, "properties": {"emails": {"description": "Adds one or more email addresses to your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.", "example": [], "items": {"example": "username@example.com", "minItems": 1, "type": "string"}, "type": "array"}}, "required": ["emails"], "type": "object"}, {"items": {"example": "username@example.com", "minItems": 1, "type": "string"}, "type": "array"}, {"type": "string"}]}',  # noqa: E501
    "CREATEGITHUBREPOFORUSER": '{"properties": {"allow_auto_merge": {"default": false, "description": "Whether to allow Auto-merge to be used on pull requests.", "example": false, "type": "boolean"}, "allow_merge_commit": {"default": true, "description": "Whether to allow merge commits for pull requests.", "example": true, "type": "boolean"}, "allow_rebase_merge": {"default": true, "description": "Whether to allow rebase merges for pull requests.", "example": true, "type": "boolean"}, "allow_squash_merge": {"default": true, "description": "Whether to allow squash merges for pull requests.", "example": true, "type": "boolean"}, "auto_init": {"default": false, "description": "Whether the repository is initialized with a minimal README.", "type": "boolean"}, "delete_branch_on_merge": {"default": false, "description": "Whether to delete head branches when pull requests are merged", "example": false, "type": "boolean"}, "description": {"description": "A short description of the repository.", "type": "string"}, "gitignore_template": {"description": "The desired language or platform to apply to the .gitignore.", "example": "Haskell", "type": "string"}, "has_discussions": {"default": false, "description": "Whether discussions are enabled.", "example": true, "type": "boolean"}, "has_downloads": {"default": true, "description": "Whether downloads are enabled.", "example": true, "type": "boolean"}, "has_issues": {"default": true, "description": "Whether issues are enabled.", "example": true, "type": "boolean"}, "has_projects": {"default": true, "description": "Whether projects are enabled.", "example": true, "type": "boolean"}, "has_wiki": {"default": true, "description": "Whether the wiki is enabled.", "example": true, "type": "boolean"}, "homepage": {"description": "A URL with more information about the repository.", "type": "string"}, "is_template": {"default": false, "description": "Whether this repository acts as a template that can be used to generate new repositories.", "example": true, "type": "boolean"}, "license_template": {"description": "The license keyword of the open source license for this repository.", "example": "mit", "type": "string"}, "merge_commit_message": {"description": "The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request\'s title.\n- `PR_BODY` - default to the pull request\'s body.\n- `BLANK` - default to a blank commit message.", "enum": ["PR_BODY", "PR_TITLE", "BLANK"], "type": "string"}, "merge_commit_title": {"description": "The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request\'s title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).", "enum": ["PR_TITLE", "MERGE_MESSAGE"], "type": "string"}, "name": {"description": "The name of the repository.", "example": "Team Environment", "type": "string"}, "private": {"default": false, "description": "Whether the repository is private.", "type": "boolean"}, "squash_merge_commit_message": {"description": "The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request\'s body.\n- `COMMIT_MESSAGES` - default to the branch\'s commit messages.\n- `BLANK` - default to a blank commit message.", "enum": ["PR_BODY", "COMMIT_MESSAGES", "BLANK"], "type": "string"}, "squash_merge_commit_title": {"description": "The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request\'s title.\n- `COMMIT_OR_PR_TITLE` - default to the commit\'s title (if only one commit) or the pull request\'s title (when more than one commit).", "enum": ["PR_TITLE", "COMMIT_OR_PR_TITLE"], "type": "string"}, "team_id": {"description": "The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.", "type": "integer"}}, "required": ["name"], "type": "object"}',  # noqa: E501
}
