from pprint import pprint

import pandas as pd

_letters = list("abcdefghijklmnopqrstuvw")
_lst = list("abcdefghijklmnopqrstuvw")

for letter1 in _letters:
    for letter2 in _letters:
        _lst.append(letter1 + letter2)

for letter1 in _letters[0:8]:
    for letter2 in _letters:
        for letter3 in _letters:
            _lst.append(letter1 + letter2 + letter3)


REPLACEMENT_NAMES = _lst


def full_print(df: pd.DataFrame) -> None:
    """Prints the full DataFrame

    Example:
        >>> import archimedes
        >>> import pandas as pd
        >>> df_ap = archimedes.get(
        ...     "NP/AreaPrices",
        ...     price_areas=["NO1", "SE1", "DK1", "FI"],
        ...     start=pd.Timestamp.now() - pd.Timedelta(days=1)
        ... )
        >>> archimedes.full_print(df_ap)
            series_id                 NP/AreaPrices
            price_area                          DK1      FI     NO1    SE1
            from_dt
            2022-09-26 15:00:00+00:00        309.08  180.01  307.70  56.29
            2022-09-26 16:00:00+00:00        389.01  187.85  325.02  63.87
            2022-09-26 17:00:00+00:00        419.01  188.18  331.80  63.57
            2022-09-26 18:00:00+00:00        396.58  163.21  337.31  53.48
            2022-09-26 19:00:00+00:00        329.70  103.81  324.57  42.39
            2022-09-26 20:00:00+00:00        303.08  110.02  291.56  31.59
            2022-09-26 21:00:00+00:00        263.91   18.77  280.57  18.77
            2022-09-26 22:00:00+00:00        190.95   13.93  296.58  13.93
            2022-09-26 23:00:00+00:00        180.24   13.00  236.88  13.00
            2022-09-27 00:00:00+00:00        169.80   12.66  174.87  12.66
            2022-09-27 01:00:00+00:00        151.30   12.97  155.82  12.97
            2022-09-27 02:00:00+00:00        167.35   14.32  207.07  14.32
            2022-09-27 03:00:00+00:00        209.97   47.78  291.55  16.20
            2022-09-27 04:00:00+00:00        327.48  170.55  303.94  24.72
            2022-09-27 05:00:00+00:00        415.95   89.92  320.60  59.41
            2022-09-27 06:00:00+00:00        443.51  132.50  328.86  72.01
            2022-09-27 07:00:00+00:00        412.29  162.78  327.27  69.95
            2022-09-27 08:00:00+00:00        366.86  187.77  327.16  69.29
            2022-09-27 09:00:00+00:00        351.37  201.01  324.32  68.76
            2022-09-27 10:00:00+00:00        301.37  210.01  319.66  62.06
            2022-09-27 11:00:00+00:00        293.27  200.01  303.72  60.86
            2022-09-27 12:00:00+00:00        288.65  214.86  297.28  58.48
            2022-09-27 13:00:00+00:00        295.21  200.01  311.20  57.42
            2022-09-27 14:00:00+00:00        308.29  214.82  315.58  58.05
            2022-09-27 15:00:00+00:00        365.30  203.91  322.48  62.05
            2022-09-27 16:00:00+00:00        381.50  214.83  329.87  66.33
            2022-09-27 17:00:00+00:00        418.99  199.49  332.77  65.16
            2022-09-27 18:00:00+00:00        400.52  177.12  335.20  60.39
            2022-09-27 19:00:00+00:00        351.43  148.35  326.39  52.37
            2022-09-27 20:00:00+00:00        333.69  119.98  316.23  46.10
            2022-09-27 21:00:00+00:00        319.71   86.26  310.44  34.73
            2022-09-27 22:00:00+00:00        306.42   97.15  296.92  45.57
            2022-09-27 23:00:00+00:00        275.78   85.48  267.23  45.17
            2022-09-28 00:00:00+00:00        245.94   78.04  238.31  45.81
            2022-09-28 01:00:00+00:00        242.98   80.45  235.45  46.70
            2022-09-28 02:00:00+00:00        273.77  120.75  265.28  47.04
            2022-09-28 03:00:00+00:00        307.13  233.08  296.56  50.63
            2022-09-28 04:00:00+00:00        383.17  322.70  301.81  56.48
            2022-09-28 05:00:00+00:00        472.63  313.36  302.30  69.02
            2022-09-28 06:00:00+00:00        500.38  350.00  314.09  76.26
            2022-09-28 07:00:00+00:00        429.91  373.91  322.15  77.24
            2022-09-28 08:00:00+00:00        409.97  358.62  317.20  76.49
            2022-09-28 09:00:00+00:00        394.60  381.49  313.26  76.34
            2022-09-28 10:00:00+00:00        353.76  361.88  314.84  76.09
            2022-09-28 11:00:00+00:00        346.45  349.04  317.98  76.43
            2022-09-28 12:00:00+00:00        331.80  321.72  319.34  76.81
            2022-09-28 13:00:00+00:00        357.91  356.92  318.83  76.88
            2022-09-28 14:00:00+00:00        384.98  346.17  309.53  72.22
            2022-09-28 15:00:00+00:00        435.59  303.19  305.03  75.92
            2022-09-28 16:00:00+00:00        510.79  369.00  309.50  75.72
            2022-09-28 17:00:00+00:00        640.42  250.57  310.12  75.61
            2022-09-28 18:00:00+00:00        510.00  189.66  306.21  76.76
            2022-09-28 19:00:00+00:00        419.99  167.26  301.83  70.25
            2022-09-28 20:00:00+00:00        372.61  119.93  283.95  70.00
            2022-09-28 21:00:00+00:00        361.80   60.17  282.81  60.17

    Args:
        df (pd.DataFrame): The dataframe that you want to print
    """
    pd.set_option("display.max_rows", None)
    print(df)
    # print(df.tail(1))
    pd.set_option("display.max_rows", 10)


def compact_print(
    df: pd.DataFrame, show_mapping: bool = False, all_rows: bool = False
) -> None:
    """Prints a compact version of the DataFrame

    Example:
        >>> import archimedes
        >>> import pandas as pd
        >>> df_ap = archimedes.get(
        ...     "NP/AreaPrices",
        ...     price_areas=["NO1", "SE1", "DK1", "FI"]
        ...     start=pd.Timestamp.now() - pd.Timedelta(days=1),
        ... )
        >>> archimedes.compact_print(df_ap, True, False)
                                            a       b       c      d
            from_dt
            2022-09-26 15:00:00+00:00  309.08  180.01  307.70  56.29
            2022-09-26 16:00:00+00:00  389.01  187.85  325.02  63.87
            2022-09-26 17:00:00+00:00  419.01  188.18  331.80  63.57
            2022-09-26 18:00:00+00:00  396.58  163.21  337.31  53.48
            2022-09-26 19:00:00+00:00  329.70  103.81  324.57  42.39
            2022-09-26 20:00:00+00:00  303.08  110.02  291.56  31.59
            2022-09-26 21:00:00+00:00  263.91   18.77  280.57  18.77
            2022-09-26 22:00:00+00:00  190.95   13.93  296.58  13.93
            2022-09-26 23:00:00+00:00  180.24   13.00  236.88  13.00
            2022-09-27 00:00:00+00:00  169.80   12.66  174.87  12.66
            2022-09-27 01:00:00+00:00  151.30   12.97  155.82  12.97
            2022-09-27 02:00:00+00:00  167.35   14.32  207.07  14.32
            2022-09-27 03:00:00+00:00  209.97   47.78  291.55  16.20
            2022-09-27 04:00:00+00:00  327.48  170.55  303.94  24.72
            2022-09-27 05:00:00+00:00  415.95   89.92  320.60  59.41
            2022-09-27 06:00:00+00:00  443.51  132.50  328.86  72.01
            2022-09-27 07:00:00+00:00  412.29  162.78  327.27  69.95
            2022-09-27 08:00:00+00:00  366.86  187.77  327.16  69.29
            2022-09-27 09:00:00+00:00  351.37  201.01  324.32  68.76
            2022-09-27 10:00:00+00:00  301.37  210.01  319.66  62.06
            2022-09-27 11:00:00+00:00  293.27  200.01  303.72  60.86
            2022-09-27 12:00:00+00:00  288.65  214.86  297.28  58.48
            2022-09-27 13:00:00+00:00  295.21  200.01  311.20  57.42
            2022-09-27 14:00:00+00:00  308.29  214.82  315.58  58.05
            2022-09-27 15:00:00+00:00  365.30  203.91  322.48  62.05
            2022-09-27 16:00:00+00:00  381.50  214.83  329.87  66.33
            2022-09-27 17:00:00+00:00  418.99  199.49  332.77  65.16
            2022-09-27 18:00:00+00:00  400.52  177.12  335.20  60.39
            2022-09-27 19:00:00+00:00  351.43  148.35  326.39  52.37
            2022-09-27 20:00:00+00:00  333.69  119.98  316.23  46.10
            2022-09-27 21:00:00+00:00  319.71   86.26  310.44  34.73
            2022-09-27 22:00:00+00:00  306.42   97.15  296.92  45.57
            2022-09-27 23:00:00+00:00  275.78   85.48  267.23  45.17
            2022-09-28 00:00:00+00:00  245.94   78.04  238.31  45.81
            2022-09-28 01:00:00+00:00  242.98   80.45  235.45  46.70
            2022-09-28 02:00:00+00:00  273.77  120.75  265.28  47.04
            2022-09-28 03:00:00+00:00  307.13  233.08  296.56  50.63
            2022-09-28 04:00:00+00:00  383.17  322.70  301.81  56.48
            2022-09-28 05:00:00+00:00  472.63  313.36  302.30  69.02
            2022-09-28 06:00:00+00:00  500.38  350.00  314.09  76.26
            2022-09-28 07:00:00+00:00  429.91  373.91  322.15  77.24
            2022-09-28 08:00:00+00:00  409.97  358.62  317.20  76.49
            2022-09-28 09:00:00+00:00  394.60  381.49  313.26  76.34
            2022-09-28 10:00:00+00:00  353.76  361.88  314.84  76.09
            2022-09-28 11:00:00+00:00  346.45  349.04  317.98  76.43
            2022-09-28 12:00:00+00:00  331.80  321.72  319.34  76.81
            2022-09-28 13:00:00+00:00  357.91  356.92  318.83  76.88
            2022-09-28 14:00:00+00:00  384.98  346.17  309.53  72.22
            2022-09-28 15:00:00+00:00  435.59  303.19  305.03  75.92
            2022-09-28 16:00:00+00:00  510.79  369.00  309.50  75.72
            2022-09-28 17:00:00+00:00  640.42  250.57  310.12  75.61
            2022-09-28 18:00:00+00:00  510.00  189.66  306.21  76.76
            2022-09-28 19:00:00+00:00  419.99  167.26  301.83  70.25
            2022-09-28 20:00:00+00:00  372.61  119.93  283.95  70.00
            2022-09-28 21:00:00+00:00  361.80   60.17  282.81  60.17
            This is a compact version of the dataframe, with columns:
            {'a': ('NP/AreaPrices', 'DK1'),
             'b': ('NP/AreaPrices', 'FI'),
             'c': ('NP/AreaPrices', 'NO1'),
             'd': ('NP/AreaPrices', 'SE1')}

    Args:
        df (pd.DataFrame): The dataframe that you want to print
        show_mapping (bool, optional):
            Set to True to print the column name mapping.
            Defaults to False.
        all_rows (bool, optional):
            Set to True if you want to print all rows.
            Defaults to False.
    """
    df_ = df.copy()
    num_columns = len(df_.columns)
    actual_columns = df_.columns
    compact_columns = REPLACEMENT_NAMES[0:num_columns]
    mapping = dict(zip(compact_columns, actual_columns))
    df_.columns = compact_columns
    if all_rows:
        pd.set_option("display.max_rows", None)
        print(df_)
        pd.set_option("display.max_rows", 10)
    else:
        print(df_)
    if show_mapping:
        print("This is a compact version of the dataframe, with columns:")
        pprint(mapping)
