"""
    Consolidate Services

    Description of all APIs  # noqa: E501

    The version of the OpenAPI document: version not set
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from argocd_python_client.api_client import ApiClient, Endpoint as _Endpoint
from argocd_python_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from argocd_python_client.model.application_application_patch_request import ApplicationApplicationPatchRequest
from argocd_python_client.model.application_application_resource_response import ApplicationApplicationResourceResponse
from argocd_python_client.model.application_application_rollback_request import ApplicationApplicationRollbackRequest
from argocd_python_client.model.application_application_sync_request import ApplicationApplicationSyncRequest
from argocd_python_client.model.application_application_sync_windows_response import ApplicationApplicationSyncWindowsResponse
from argocd_python_client.model.application_managed_resources_response import ApplicationManagedResourcesResponse
from argocd_python_client.model.application_resource_actions_list_response import ApplicationResourceActionsListResponse
from argocd_python_client.model.repository_manifest_response import RepositoryManifestResponse
from argocd_python_client.model.runtime_error import RuntimeError
from argocd_python_client.model.stream_result_of_application_log_entry import StreamResultOfApplicationLogEntry
from argocd_python_client.model.stream_result_of_v1alpha1_application_tree import StreamResultOfV1alpha1ApplicationTree
from argocd_python_client.model.stream_result_of_v1alpha1_application_watch_event import StreamResultOfV1alpha1ApplicationWatchEvent
from argocd_python_client.model.v1_event_list import V1EventList
from argocd_python_client.model.v1alpha1_application import V1alpha1Application
from argocd_python_client.model.v1alpha1_application_list import V1alpha1ApplicationList
from argocd_python_client.model.v1alpha1_application_spec import V1alpha1ApplicationSpec
from argocd_python_client.model.v1alpha1_application_tree import V1alpha1ApplicationTree
from argocd_python_client.model.v1alpha1_revision_metadata import V1alpha1RevisionMetadata


class ApplicationServiceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __application_service_create(
            self,
            body,
            **kwargs
        ):
            """Create creates an application  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_create(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (V1alpha1Application):

            Keyword Args:
                upsert (bool): [optional]
                validate (bool): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1Application
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.application_service_create = _Endpoint(
            settings={
                'response_type': (V1alpha1Application,),
                'auth': [],
                'endpoint_path': '/api/v1/applications',
                'operation_id': 'application_service_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                    'upsert',
                    'validate',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (V1alpha1Application,),
                    'upsert':
                        (bool,),
                    'validate':
                        (bool,),
                },
                'attribute_map': {
                    'upsert': 'upsert',
                    'validate': 'validate',
                },
                'location_map': {
                    'body': 'body',
                    'upsert': 'query',
                    'validate': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__application_service_create
        )

        def __application_service_delete(
            self,
            name,
            **kwargs
        ):
            """Delete deletes an application  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_delete(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):

            Keyword Args:
                cascade (bool): [optional]
                propagation_policy (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                bool, date, datetime, dict, float, int, list, str, none_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.application_service_delete = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}',
                'operation_id': 'application_service_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'cascade',
                    'propagation_policy',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'cascade':
                        (bool,),
                    'propagation_policy':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'cascade': 'cascade',
                    'propagation_policy': 'propagationPolicy',
                },
                'location_map': {
                    'name': 'path',
                    'cascade': 'query',
                    'propagation_policy': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_delete
        )

        def __application_service_delete_resource(
            self,
            name,
            **kwargs
        ):
            """DeleteResource deletes a single application resource  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_delete_resource(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):

            Keyword Args:
                namespace (str): [optional]
                resource_name (str): [optional]
                version (str): [optional]
                group (str): [optional]
                kind (str): [optional]
                force (bool): [optional]
                orphan (bool): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                bool, date, datetime, dict, float, int, list, str, none_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.application_service_delete_resource = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/resource',
                'operation_id': 'application_service_delete_resource',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'namespace',
                    'resource_name',
                    'version',
                    'group',
                    'kind',
                    'force',
                    'orphan',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'namespace':
                        (str,),
                    'resource_name':
                        (str,),
                    'version':
                        (str,),
                    'group':
                        (str,),
                    'kind':
                        (str,),
                    'force':
                        (bool,),
                    'orphan':
                        (bool,),
                },
                'attribute_map': {
                    'name': 'name',
                    'namespace': 'namespace',
                    'resource_name': 'resourceName',
                    'version': 'version',
                    'group': 'group',
                    'kind': 'kind',
                    'force': 'force',
                    'orphan': 'orphan',
                },
                'location_map': {
                    'name': 'path',
                    'namespace': 'query',
                    'resource_name': 'query',
                    'version': 'query',
                    'group': 'query',
                    'kind': 'query',
                    'force': 'query',
                    'orphan': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_delete_resource
        )

        def __application_service_get(
            self,
            name,
            **kwargs
        ):
            """Get returns an application by name  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_get(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str): the application's name

            Keyword Args:
                refresh (str): forces application reconciliation if set to true.. [optional]
                project ([str]): the project names to restrict returned list applications.. [optional]
                resource_version (str): when specified with a watch call, shows changes that occur after that particular version of a resource.. [optional]
                selector (str): the selector to to restrict returned list to applications only with matched labels.. [optional]
                repo (str): the repoURL to restrict returned list applications.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1Application
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.application_service_get = _Endpoint(
            settings={
                'response_type': (V1alpha1Application,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}',
                'operation_id': 'application_service_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'refresh',
                    'project',
                    'resource_version',
                    'selector',
                    'repo',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'refresh':
                        (str,),
                    'project':
                        ([str],),
                    'resource_version':
                        (str,),
                    'selector':
                        (str,),
                    'repo':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'refresh': 'refresh',
                    'project': 'project',
                    'resource_version': 'resourceVersion',
                    'selector': 'selector',
                    'repo': 'repo',
                },
                'location_map': {
                    'name': 'path',
                    'refresh': 'query',
                    'project': 'query',
                    'resource_version': 'query',
                    'selector': 'query',
                    'repo': 'query',
                },
                'collection_format_map': {
                    'project': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_get
        )

        def __application_service_get_application_sync_windows(
            self,
            name,
            **kwargs
        ):
            """Get returns sync windows of the application  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_get_application_sync_windows(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApplicationApplicationSyncWindowsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.application_service_get_application_sync_windows = _Endpoint(
            settings={
                'response_type': (ApplicationApplicationSyncWindowsResponse,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/syncwindows',
                'operation_id': 'application_service_get_application_sync_windows',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_get_application_sync_windows
        )

        def __application_service_get_manifests(
            self,
            name,
            **kwargs
        ):
            """GetManifests returns application manifests  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_get_manifests(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):

            Keyword Args:
                revision (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RepositoryManifestResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.application_service_get_manifests = _Endpoint(
            settings={
                'response_type': (RepositoryManifestResponse,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/manifests',
                'operation_id': 'application_service_get_manifests',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'revision',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'revision':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'revision': 'revision',
                },
                'location_map': {
                    'name': 'path',
                    'revision': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_get_manifests
        )

        def __application_service_get_resource(
            self,
            name,
            **kwargs
        ):
            """GetResource returns single application resource  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_get_resource(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):

            Keyword Args:
                namespace (str): [optional]
                resource_name (str): [optional]
                version (str): [optional]
                group (str): [optional]
                kind (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApplicationApplicationResourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.application_service_get_resource = _Endpoint(
            settings={
                'response_type': (ApplicationApplicationResourceResponse,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/resource',
                'operation_id': 'application_service_get_resource',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'namespace',
                    'resource_name',
                    'version',
                    'group',
                    'kind',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'namespace':
                        (str,),
                    'resource_name':
                        (str,),
                    'version':
                        (str,),
                    'group':
                        (str,),
                    'kind':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'namespace': 'namespace',
                    'resource_name': 'resourceName',
                    'version': 'version',
                    'group': 'group',
                    'kind': 'kind',
                },
                'location_map': {
                    'name': 'path',
                    'namespace': 'query',
                    'resource_name': 'query',
                    'version': 'query',
                    'group': 'query',
                    'kind': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_get_resource
        )

        def __application_service_list(
            self,
            **kwargs
        ):
            """List returns list of applications  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                name (str): the application's name.. [optional]
                refresh (str): forces application reconciliation if set to true.. [optional]
                project ([str]): the project names to restrict returned list applications.. [optional]
                resource_version (str): when specified with a watch call, shows changes that occur after that particular version of a resource.. [optional]
                selector (str): the selector to to restrict returned list to applications only with matched labels.. [optional]
                repo (str): the repoURL to restrict returned list applications.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1ApplicationList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.application_service_list = _Endpoint(
            settings={
                'response_type': (V1alpha1ApplicationList,),
                'auth': [],
                'endpoint_path': '/api/v1/applications',
                'operation_id': 'application_service_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'refresh',
                    'project',
                    'resource_version',
                    'selector',
                    'repo',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'refresh':
                        (str,),
                    'project':
                        ([str],),
                    'resource_version':
                        (str,),
                    'selector':
                        (str,),
                    'repo':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'refresh': 'refresh',
                    'project': 'project',
                    'resource_version': 'resourceVersion',
                    'selector': 'selector',
                    'repo': 'repo',
                },
                'location_map': {
                    'name': 'query',
                    'refresh': 'query',
                    'project': 'query',
                    'resource_version': 'query',
                    'selector': 'query',
                    'repo': 'query',
                },
                'collection_format_map': {
                    'project': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_list
        )

        def __application_service_list_resource_actions(
            self,
            name,
            **kwargs
        ):
            """ListResourceActions returns list of resource actions  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_list_resource_actions(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):

            Keyword Args:
                namespace (str): [optional]
                resource_name (str): [optional]
                version (str): [optional]
                group (str): [optional]
                kind (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApplicationResourceActionsListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.application_service_list_resource_actions = _Endpoint(
            settings={
                'response_type': (ApplicationResourceActionsListResponse,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/resource/actions',
                'operation_id': 'application_service_list_resource_actions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'namespace',
                    'resource_name',
                    'version',
                    'group',
                    'kind',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'namespace':
                        (str,),
                    'resource_name':
                        (str,),
                    'version':
                        (str,),
                    'group':
                        (str,),
                    'kind':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'namespace': 'namespace',
                    'resource_name': 'resourceName',
                    'version': 'version',
                    'group': 'group',
                    'kind': 'kind',
                },
                'location_map': {
                    'name': 'path',
                    'namespace': 'query',
                    'resource_name': 'query',
                    'version': 'query',
                    'group': 'query',
                    'kind': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_list_resource_actions
        )

        def __application_service_list_resource_events(
            self,
            name,
            **kwargs
        ):
            """ListResourceEvents returns a list of event resources  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_list_resource_events(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):

            Keyword Args:
                resource_namespace (str): [optional]
                resource_name (str): [optional]
                resource_uid (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1EventList
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.application_service_list_resource_events = _Endpoint(
            settings={
                'response_type': (V1EventList,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/events',
                'operation_id': 'application_service_list_resource_events',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'resource_namespace',
                    'resource_name',
                    'resource_uid',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'resource_namespace':
                        (str,),
                    'resource_name':
                        (str,),
                    'resource_uid':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'resource_namespace': 'resourceNamespace',
                    'resource_name': 'resourceName',
                    'resource_uid': 'resourceUID',
                },
                'location_map': {
                    'name': 'path',
                    'resource_namespace': 'query',
                    'resource_name': 'query',
                    'resource_uid': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_list_resource_events
        )

        def __application_service_managed_resources(
            self,
            application_name,
            **kwargs
        ):
            """ManagedResources returns list of managed resources  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_managed_resources(application_name, async_req=True)
            >>> result = thread.get()

            Args:
                application_name (str):

            Keyword Args:
                namespace (str): [optional]
                name (str): [optional]
                version (str): [optional]
                group (str): [optional]
                kind (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApplicationManagedResourcesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['application_name'] = \
                application_name
            return self.call_with_http_info(**kwargs)

        self.application_service_managed_resources = _Endpoint(
            settings={
                'response_type': (ApplicationManagedResourcesResponse,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{applicationName}/managed-resources',
                'operation_id': 'application_service_managed_resources',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'application_name',
                    'namespace',
                    'name',
                    'version',
                    'group',
                    'kind',
                ],
                'required': [
                    'application_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'application_name':
                        (str,),
                    'namespace':
                        (str,),
                    'name':
                        (str,),
                    'version':
                        (str,),
                    'group':
                        (str,),
                    'kind':
                        (str,),
                },
                'attribute_map': {
                    'application_name': 'applicationName',
                    'namespace': 'namespace',
                    'name': 'name',
                    'version': 'version',
                    'group': 'group',
                    'kind': 'kind',
                },
                'location_map': {
                    'application_name': 'path',
                    'namespace': 'query',
                    'name': 'query',
                    'version': 'query',
                    'group': 'query',
                    'kind': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_managed_resources
        )

        def __application_service_patch(
            self,
            name,
            body,
            **kwargs
        ):
            """Patch patch an application  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_patch(name, body, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):
                body (ApplicationApplicationPatchRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1Application
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.application_service_patch = _Endpoint(
            settings={
                'response_type': (V1alpha1Application,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}',
                'operation_id': 'application_service_patch',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'body',
                ],
                'required': [
                    'name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'body':
                        (ApplicationApplicationPatchRequest,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__application_service_patch
        )

        def __application_service_patch_resource(
            self,
            name,
            body,
            **kwargs
        ):
            """PatchResource patch single application resource  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_patch_resource(name, body, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):
                body (str):

            Keyword Args:
                namespace (str): [optional]
                resource_name (str): [optional]
                version (str): [optional]
                group (str): [optional]
                kind (str): [optional]
                patch_type (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApplicationApplicationResourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.application_service_patch_resource = _Endpoint(
            settings={
                'response_type': (ApplicationApplicationResourceResponse,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/resource',
                'operation_id': 'application_service_patch_resource',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'body',
                    'namespace',
                    'resource_name',
                    'version',
                    'group',
                    'kind',
                    'patch_type',
                ],
                'required': [
                    'name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'body':
                        (str,),
                    'namespace':
                        (str,),
                    'resource_name':
                        (str,),
                    'version':
                        (str,),
                    'group':
                        (str,),
                    'kind':
                        (str,),
                    'patch_type':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'namespace': 'namespace',
                    'resource_name': 'resourceName',
                    'version': 'version',
                    'group': 'group',
                    'kind': 'kind',
                    'patch_type': 'patchType',
                },
                'location_map': {
                    'name': 'path',
                    'body': 'body',
                    'namespace': 'query',
                    'resource_name': 'query',
                    'version': 'query',
                    'group': 'query',
                    'kind': 'query',
                    'patch_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__application_service_patch_resource
        )

        def __application_service_pod_logs(
            self,
            name,
            pod_name,
            **kwargs
        ):
            """PodLogs returns stream of log entries for the specified pod. Pod  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_pod_logs(name, pod_name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):
                pod_name (str):

            Keyword Args:
                namespace (str): [optional]
                container (str): [optional]
                since_seconds (str): [optional]
                since_time_seconds (str): Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.. [optional]
                since_time_nanos (int): Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive. This field may be limited in precision depending on context.. [optional]
                tail_lines (str): [optional]
                follow (bool): [optional]
                until_time (str): [optional]
                filter (str): [optional]
                kind (str): [optional]
                group (str): [optional]
                resource_name (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StreamResultOfApplicationLogEntry
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            kwargs['pod_name'] = \
                pod_name
            return self.call_with_http_info(**kwargs)

        self.application_service_pod_logs = _Endpoint(
            settings={
                'response_type': (StreamResultOfApplicationLogEntry,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/pods/{podName}/logs',
                'operation_id': 'application_service_pod_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'pod_name',
                    'namespace',
                    'container',
                    'since_seconds',
                    'since_time_seconds',
                    'since_time_nanos',
                    'tail_lines',
                    'follow',
                    'until_time',
                    'filter',
                    'kind',
                    'group',
                    'resource_name',
                ],
                'required': [
                    'name',
                    'pod_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'pod_name':
                        (str,),
                    'namespace':
                        (str,),
                    'container':
                        (str,),
                    'since_seconds':
                        (str,),
                    'since_time_seconds':
                        (str,),
                    'since_time_nanos':
                        (int,),
                    'tail_lines':
                        (str,),
                    'follow':
                        (bool,),
                    'until_time':
                        (str,),
                    'filter':
                        (str,),
                    'kind':
                        (str,),
                    'group':
                        (str,),
                    'resource_name':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'pod_name': 'podName',
                    'namespace': 'namespace',
                    'container': 'container',
                    'since_seconds': 'sinceSeconds',
                    'since_time_seconds': 'sinceTime.seconds',
                    'since_time_nanos': 'sinceTime.nanos',
                    'tail_lines': 'tailLines',
                    'follow': 'follow',
                    'until_time': 'untilTime',
                    'filter': 'filter',
                    'kind': 'kind',
                    'group': 'group',
                    'resource_name': 'resourceName',
                },
                'location_map': {
                    'name': 'path',
                    'pod_name': 'path',
                    'namespace': 'query',
                    'container': 'query',
                    'since_seconds': 'query',
                    'since_time_seconds': 'query',
                    'since_time_nanos': 'query',
                    'tail_lines': 'query',
                    'follow': 'query',
                    'until_time': 'query',
                    'filter': 'query',
                    'kind': 'query',
                    'group': 'query',
                    'resource_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_pod_logs
        )

        def __application_service_pod_logs2(
            self,
            name,
            **kwargs
        ):
            """PodLogs returns stream of log entries for the specified pod. Pod  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_pod_logs2(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):

            Keyword Args:
                namespace (str): [optional]
                pod_name (str): [optional]
                container (str): [optional]
                since_seconds (str): [optional]
                since_time_seconds (str): Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.. [optional]
                since_time_nanos (int): Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive. This field may be limited in precision depending on context.. [optional]
                tail_lines (str): [optional]
                follow (bool): [optional]
                until_time (str): [optional]
                filter (str): [optional]
                kind (str): [optional]
                group (str): [optional]
                resource_name (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StreamResultOfApplicationLogEntry
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.application_service_pod_logs2 = _Endpoint(
            settings={
                'response_type': (StreamResultOfApplicationLogEntry,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/logs',
                'operation_id': 'application_service_pod_logs2',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'namespace',
                    'pod_name',
                    'container',
                    'since_seconds',
                    'since_time_seconds',
                    'since_time_nanos',
                    'tail_lines',
                    'follow',
                    'until_time',
                    'filter',
                    'kind',
                    'group',
                    'resource_name',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'namespace':
                        (str,),
                    'pod_name':
                        (str,),
                    'container':
                        (str,),
                    'since_seconds':
                        (str,),
                    'since_time_seconds':
                        (str,),
                    'since_time_nanos':
                        (int,),
                    'tail_lines':
                        (str,),
                    'follow':
                        (bool,),
                    'until_time':
                        (str,),
                    'filter':
                        (str,),
                    'kind':
                        (str,),
                    'group':
                        (str,),
                    'resource_name':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'namespace': 'namespace',
                    'pod_name': 'podName',
                    'container': 'container',
                    'since_seconds': 'sinceSeconds',
                    'since_time_seconds': 'sinceTime.seconds',
                    'since_time_nanos': 'sinceTime.nanos',
                    'tail_lines': 'tailLines',
                    'follow': 'follow',
                    'until_time': 'untilTime',
                    'filter': 'filter',
                    'kind': 'kind',
                    'group': 'group',
                    'resource_name': 'resourceName',
                },
                'location_map': {
                    'name': 'path',
                    'namespace': 'query',
                    'pod_name': 'query',
                    'container': 'query',
                    'since_seconds': 'query',
                    'since_time_seconds': 'query',
                    'since_time_nanos': 'query',
                    'tail_lines': 'query',
                    'follow': 'query',
                    'until_time': 'query',
                    'filter': 'query',
                    'kind': 'query',
                    'group': 'query',
                    'resource_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_pod_logs2
        )

        def __application_service_resource_tree(
            self,
            application_name,
            **kwargs
        ):
            """ResourceTree returns resource tree  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_resource_tree(application_name, async_req=True)
            >>> result = thread.get()

            Args:
                application_name (str):

            Keyword Args:
                namespace (str): [optional]
                name (str): [optional]
                version (str): [optional]
                group (str): [optional]
                kind (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1ApplicationTree
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['application_name'] = \
                application_name
            return self.call_with_http_info(**kwargs)

        self.application_service_resource_tree = _Endpoint(
            settings={
                'response_type': (V1alpha1ApplicationTree,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{applicationName}/resource-tree',
                'operation_id': 'application_service_resource_tree',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'application_name',
                    'namespace',
                    'name',
                    'version',
                    'group',
                    'kind',
                ],
                'required': [
                    'application_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'application_name':
                        (str,),
                    'namespace':
                        (str,),
                    'name':
                        (str,),
                    'version':
                        (str,),
                    'group':
                        (str,),
                    'kind':
                        (str,),
                },
                'attribute_map': {
                    'application_name': 'applicationName',
                    'namespace': 'namespace',
                    'name': 'name',
                    'version': 'version',
                    'group': 'group',
                    'kind': 'kind',
                },
                'location_map': {
                    'application_name': 'path',
                    'namespace': 'query',
                    'name': 'query',
                    'version': 'query',
                    'group': 'query',
                    'kind': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_resource_tree
        )

        def __application_service_revision_metadata(
            self,
            name,
            revision,
            **kwargs
        ):
            """Get the meta-data (author, date, tags, message) for a specific revision of the application  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_revision_metadata(name, revision, async_req=True)
            >>> result = thread.get()

            Args:
                name (str): the application's name
                revision (str): the revision of the app

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1RevisionMetadata
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            kwargs['revision'] = \
                revision
            return self.call_with_http_info(**kwargs)

        self.application_service_revision_metadata = _Endpoint(
            settings={
                'response_type': (V1alpha1RevisionMetadata,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/revisions/{revision}/metadata',
                'operation_id': 'application_service_revision_metadata',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'revision',
                ],
                'required': [
                    'name',
                    'revision',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'revision':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'revision': 'revision',
                },
                'location_map': {
                    'name': 'path',
                    'revision': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_revision_metadata
        )

        def __application_service_rollback(
            self,
            name,
            body,
            **kwargs
        ):
            """Rollback syncs an application to its target state  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_rollback(name, body, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):
                body (ApplicationApplicationRollbackRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1Application
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.application_service_rollback = _Endpoint(
            settings={
                'response_type': (V1alpha1Application,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/rollback',
                'operation_id': 'application_service_rollback',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'body',
                ],
                'required': [
                    'name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'body':
                        (ApplicationApplicationRollbackRequest,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__application_service_rollback
        )

        def __application_service_run_resource_action(
            self,
            name,
            body,
            **kwargs
        ):
            """RunResourceAction run resource action  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_run_resource_action(name, body, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):
                body (str):

            Keyword Args:
                namespace (str): [optional]
                resource_name (str): [optional]
                version (str): [optional]
                group (str): [optional]
                kind (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                bool, date, datetime, dict, float, int, list, str, none_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.application_service_run_resource_action = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/resource/actions',
                'operation_id': 'application_service_run_resource_action',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'body',
                    'namespace',
                    'resource_name',
                    'version',
                    'group',
                    'kind',
                ],
                'required': [
                    'name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'body':
                        (str,),
                    'namespace':
                        (str,),
                    'resource_name':
                        (str,),
                    'version':
                        (str,),
                    'group':
                        (str,),
                    'kind':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'namespace': 'namespace',
                    'resource_name': 'resourceName',
                    'version': 'version',
                    'group': 'group',
                    'kind': 'kind',
                },
                'location_map': {
                    'name': 'path',
                    'body': 'body',
                    'namespace': 'query',
                    'resource_name': 'query',
                    'version': 'query',
                    'group': 'query',
                    'kind': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__application_service_run_resource_action
        )

        def __application_service_sync(
            self,
            name,
            body,
            **kwargs
        ):
            """Sync syncs an application to its target state  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_sync(name, body, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):
                body (ApplicationApplicationSyncRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1Application
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.application_service_sync = _Endpoint(
            settings={
                'response_type': (V1alpha1Application,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/sync',
                'operation_id': 'application_service_sync',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'body',
                ],
                'required': [
                    'name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'body':
                        (ApplicationApplicationSyncRequest,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__application_service_sync
        )

        def __application_service_terminate_operation(
            self,
            name,
            **kwargs
        ):
            """TerminateOperation terminates the currently running operation  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_terminate_operation(name, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                bool, date, datetime, dict, float, int, list, str, none_type
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            return self.call_with_http_info(**kwargs)

        self.application_service_terminate_operation = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/operation',
                'operation_id': 'application_service_terminate_operation',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                ],
                'required': [
                    'name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                },
                'location_map': {
                    'name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_terminate_operation
        )

        def __application_service_update(
            self,
            application_metadata_name,
            body,
            **kwargs
        ):
            """Update updates an application  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_update(application_metadata_name, body, async_req=True)
            >>> result = thread.get()

            Args:
                application_metadata_name (str): Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names +optional
                body (V1alpha1Application):

            Keyword Args:
                validate (bool): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1Application
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['application_metadata_name'] = \
                application_metadata_name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.application_service_update = _Endpoint(
            settings={
                'response_type': (V1alpha1Application,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{application.metadata.name}',
                'operation_id': 'application_service_update',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'application_metadata_name',
                    'body',
                    'validate',
                ],
                'required': [
                    'application_metadata_name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'application_metadata_name':
                        (str,),
                    'body':
                        (V1alpha1Application,),
                    'validate':
                        (bool,),
                },
                'attribute_map': {
                    'application_metadata_name': 'application.metadata.name',
                    'validate': 'validate',
                },
                'location_map': {
                    'application_metadata_name': 'path',
                    'body': 'body',
                    'validate': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__application_service_update
        )

        def __application_service_update_spec(
            self,
            name,
            body,
            **kwargs
        ):
            """UpdateSpec updates an application spec  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_update_spec(name, body, async_req=True)
            >>> result = thread.get()

            Args:
                name (str):
                body (V1alpha1ApplicationSpec):

            Keyword Args:
                validate (bool): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                V1alpha1ApplicationSpec
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['name'] = \
                name
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.application_service_update_spec = _Endpoint(
            settings={
                'response_type': (V1alpha1ApplicationSpec,),
                'auth': [],
                'endpoint_path': '/api/v1/applications/{name}/spec',
                'operation_id': 'application_service_update_spec',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'body',
                    'validate',
                ],
                'required': [
                    'name',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'body':
                        (V1alpha1ApplicationSpec,),
                    'validate':
                        (bool,),
                },
                'attribute_map': {
                    'name': 'name',
                    'validate': 'validate',
                },
                'location_map': {
                    'name': 'path',
                    'body': 'body',
                    'validate': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__application_service_update_spec
        )

        def __application_service_watch(
            self,
            **kwargs
        ):
            """Watch returns stream of application change events  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_watch(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                name (str): the application's name.. [optional]
                refresh (str): forces application reconciliation if set to true.. [optional]
                project ([str]): the project names to restrict returned list applications.. [optional]
                resource_version (str): when specified with a watch call, shows changes that occur after that particular version of a resource.. [optional]
                selector (str): the selector to to restrict returned list to applications only with matched labels.. [optional]
                repo (str): the repoURL to restrict returned list applications.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StreamResultOfV1alpha1ApplicationWatchEvent
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.application_service_watch = _Endpoint(
            settings={
                'response_type': (StreamResultOfV1alpha1ApplicationWatchEvent,),
                'auth': [],
                'endpoint_path': '/api/v1/stream/applications',
                'operation_id': 'application_service_watch',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'refresh',
                    'project',
                    'resource_version',
                    'selector',
                    'repo',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'refresh':
                        (str,),
                    'project':
                        ([str],),
                    'resource_version':
                        (str,),
                    'selector':
                        (str,),
                    'repo':
                        (str,),
                },
                'attribute_map': {
                    'name': 'name',
                    'refresh': 'refresh',
                    'project': 'project',
                    'resource_version': 'resourceVersion',
                    'selector': 'selector',
                    'repo': 'repo',
                },
                'location_map': {
                    'name': 'query',
                    'refresh': 'query',
                    'project': 'query',
                    'resource_version': 'query',
                    'selector': 'query',
                    'repo': 'query',
                },
                'collection_format_map': {
                    'project': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_watch
        )

        def __application_service_watch_resource_tree(
            self,
            application_name,
            **kwargs
        ):
            """Watch returns stream of application resource tree  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.application_service_watch_resource_tree(application_name, async_req=True)
            >>> result = thread.get()

            Args:
                application_name (str):

            Keyword Args:
                namespace (str): [optional]
                name (str): [optional]
                version (str): [optional]
                group (str): [optional]
                kind (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StreamResultOfV1alpha1ApplicationTree
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['application_name'] = \
                application_name
            return self.call_with_http_info(**kwargs)

        self.application_service_watch_resource_tree = _Endpoint(
            settings={
                'response_type': (StreamResultOfV1alpha1ApplicationTree,),
                'auth': [],
                'endpoint_path': '/api/v1/stream/applications/{applicationName}/resource-tree',
                'operation_id': 'application_service_watch_resource_tree',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'application_name',
                    'namespace',
                    'name',
                    'version',
                    'group',
                    'kind',
                ],
                'required': [
                    'application_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'application_name':
                        (str,),
                    'namespace':
                        (str,),
                    'name':
                        (str,),
                    'version':
                        (str,),
                    'group':
                        (str,),
                    'kind':
                        (str,),
                },
                'attribute_map': {
                    'application_name': 'applicationName',
                    'namespace': 'namespace',
                    'name': 'name',
                    'version': 'version',
                    'group': 'group',
                    'kind': 'kind',
                },
                'location_map': {
                    'application_name': 'path',
                    'namespace': 'query',
                    'name': 'query',
                    'version': 'query',
                    'group': 'query',
                    'kind': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__application_service_watch_resource_tree
        )
