# array-api-extra

[![docs - here!][docs-badge]][docs-link]
[![PyPI version][pypi-version]][pypi-link]
[![Conda-Forge][conda-badge]][conda-link]
[![PyPI platforms][pypi-platforms]][pypi-link]
[![All Contributors](https://img.shields.io/github/all-contributors/data-apis/array-api-extra?color=ee8449&style=flat-square)](#contributors)

[![Pixi Badge](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/prefix-dev/pixi/main/assets/badge/v0.json)](https://pixi.sh)
[![Typing](https://img.shields.io/pypi/types/array-api-extra)](https://typing.python.org/)
[![codecov](https://codecov.io/github/data-apis/array-api-extra/graph/badge.svg)](https://codecov.io/github/data-apis/array-api-extra)
[![EffVer Versioning](https://img.shields.io/badge/version_scheme-EffVer-0097a7)](https://jacobtomlinson.dev/effver)
[![SPEC 8 — Securing the Release Process](https://img.shields.io/badge/SPEC-8-green?labelColor=%23004811&color=%235CA038)](https://scientific-python.org/specs/spec-0008/)

<!-- SPHINX-START -->

<!-- prettier-ignore-start -->

[actions-badge]: https://github.com/data-apis/array-api-extra/workflows/CI/badge.svg
[actions-link]: https://github.com/data-apis/array-api-extra/actions
[conda-badge]: https://img.shields.io/conda/vn/conda-forge/array-api-extra
[conda-link]: https://github.com/conda-forge/array-api-extra-feedstock
[github-discussions-badge]: https://img.shields.io/static/v1?label=Discussions&message=Ask&color=blue&logo=github
[github-discussions-link]: https://github.com/data-apis/array-api-extra/discussions
[pypi-link]: https://pypi.org/project/array-api-extra/
[pypi-platforms]: https://img.shields.io/pypi/pyversions/array-api-extra
[pypi-version]: https://img.shields.io/pypi/v/array-api-extra
[docs-badge]: https://img.shields.io/badge/docs-here!-2ea44f
[docs-link]: https://data-apis.org/array-api-extra/index.html

<!-- prettier-ignore-end -->

Extra array functions built on top of the array API standard.

Used by:

- [SciPy](https://github.com/scipy/scipy) — Fundamental algorithms for
  scientific computing.
- [scikit-learn](https://github.com/scikit-learn/scikit-learn) — Machine
  Learning in Python.
- *your library? Let us know!*

## Installation

See https://data-apis.org/array-api-extra/#installation.

## Versioning

This project uses [EffVer](https://jacobtomlinson.dev/effver/). TL;DR:

- To bump from version `x.y.z` to `x.(y+1).0` of array-api-extra, expect that
  you may need to put in some work.
- To bump from version `x.y.z` to `x.y.(z+1)`, any work needed on your side
  should be minimal. Please open an issue if this is not the case!

## Contributors

This project exists thanks to the following contributors
([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://lucascolley.github.io/"><img src="https://avatars.githubusercontent.com/u/51488791?v=4?s=100" width="100px;" alt="Lucas Colley"/><br /><sub><b>Lucas Colley</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/commits?author=lucascolley" title="Code">💻</a> <a href="https://github.com/data-apis/array-api-extra/commits?author=lucascolley" title="Documentation">📖</a> <a href="#example-lucascolley" title="Examples">💡</a> <a href="#ideas-lucascolley" title="Ideas, Planning, & Feedback">🤔</a> <a href="#infra-lucascolley" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="#maintenance-lucascolley" title="Maintenance">🚧</a> <a href="#tool-lucascolley" title="Tools">🔧</a> <a href="https://github.com/data-apis/array-api-extra/commits?author=lucascolley" title="Tests">⚠️</a> <a href="https://github.com/data-apis/array-api-extra/issues?q=author%3Alucascolley" title="Bug reports">🐛</a> <a href="#platform-lucascolley" title="Packaging/porting to new platform">📦</a> <a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Alucascolley" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mdhaber"><img src="https://avatars.githubusercontent.com/u/6570539?v=4?s=100" width="100px;" alt="Matt Haberland"/><br /><sub><b>Matt Haberland</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/commits?author=mdhaber" title="Code">💻</a> <a href="#ideas-mdhaber" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/data-apis/array-api-extra/commits?author=mdhaber" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/j-bowhay"><img src="https://avatars.githubusercontent.com/u/60778417?v=4?s=100" width="100px;" alt="Jake Bowhay"/><br /><sub><b>Jake Bowhay</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/commits?author=j-bowhay" title="Code">💻</a> <a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Aj-bowhay" title="Reviewed Pull Requests">👀</a> <a href="#tool-j-bowhay" title="Tools">🔧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/asmeurer"><img src="https://avatars.githubusercontent.com/u/71486?v=4?s=100" width="100px;" alt="Aaron Meurer"/><br /><sub><b>Aaron Meurer</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Aasmeurer" title="Reviewed Pull Requests">👀</a> <a href="#ideas-asmeurer" title="Ideas, Planning, & Feedback">🤔</a> <a href="#infra-asmeurer" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/betatim"><img src="https://avatars.githubusercontent.com/u/1448859?v=4?s=100" width="100px;" alt="Tim Head"/><br /><sub><b>Tim Head</b></sub></a><br /><a href="#ideas-betatim" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/stdlib-js/stdlib"><img src="https://avatars.githubusercontent.com/u/2643044?v=4?s=100" width="100px;" alt="Athan"/><br /><sub><b>Athan</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Akgryte" title="Reviewed Pull Requests">👀</a> <a href="#ideas-kgryte" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/vnmabus"><img src="https://avatars.githubusercontent.com/u/2364173?v=4?s=100" width="100px;" alt="Carlos Ramos Carreño"/><br /><sub><b>Carlos Ramos Carreño</b></sub></a><br /><a href="#ideas-vnmabus" title="Ideas, Planning, & Feedback">🤔</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/crusaderky"><img src="https://avatars.githubusercontent.com/u/6213168?v=4?s=100" width="100px;" alt="Guido Imperiale"/><br /><sub><b>Guido Imperiale</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/commits?author=crusaderky" title="Code">💻</a> <a href="https://github.com/data-apis/array-api-extra/commits?author=crusaderky" title="Documentation">📖</a> <a href="#tool-crusaderky" title="Tools">🔧</a> <a href="https://github.com/data-apis/array-api-extra/commits?author=crusaderky" title="Tests">⚠️</a> <a href="#example-crusaderky" title="Examples">💡</a> <a href="https://github.com/data-apis/array-api-extra/issues?q=author%3Acrusaderky" title="Bug reports">🐛</a> <a href="#ideas-crusaderky" title="Ideas, Planning, & Feedback">🤔</a> <a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Acrusaderky" title="Reviewed Pull Requests">👀</a> <a href="#maintenance-crusaderky" title="Maintenance">🚧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jorenham"><img src="https://avatars.githubusercontent.com/u/6208662?v=4?s=100" width="100px;" alt="Joren Hammudoglu"/><br /><sub><b>Joren Hammudoglu</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Ajorenham" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.thomasjpfan.com/"><img src="https://avatars.githubusercontent.com/u/5402633?v=4?s=100" width="100px;" alt="Thomas J. Fan"/><br /><sub><b>Thomas J. Fan</b></sub></a><br /><a href="#ideas-thomasjpfan" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/izaid"><img src="https://avatars.githubusercontent.com/u/482179?v=4?s=100" width="100px;" alt="Irwin Zaid"/><br /><sub><b>Irwin Zaid</b></sub></a><br /><a href="#ideas-izaid" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jakirkham"><img src="https://avatars.githubusercontent.com/u/3019665?v=4?s=100" width="100px;" alt="jakirkham"/><br /><sub><b>jakirkham</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/commits?author=jakirkham" title="Code">💻</a> <a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Ajakirkham" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/tupui"><img src="https://avatars.githubusercontent.com/u/23188539?v=4?s=100" width="100px;" alt="Pamphile Roy"/><br /><sub><b>Pamphile Roy</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/commits?author=tupui" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/OmarManzoor"><img src="https://avatars.githubusercontent.com/u/17495884?v=4?s=100" width="100px;" alt="Omar Salman"/><br /><sub><b>Omar Salman</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/commits?author=OmarManzoor" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rgommers/"><img src="https://avatars.githubusercontent.com/u/98330?v=4?s=100" width="100px;" alt="Ralf Gommers"/><br /><sub><b>Ralf Gommers</b></sub></a><br /><a href="#ideas-rgommers" title="Ideas, Planning, & Feedback">🤔</a> <a href="#infra-rgommers" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Argommers" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://ogrisel.com"><img src="https://avatars.githubusercontent.com/u/89061?v=4?s=100" width="100px;" alt="Olivier Grisel"/><br /><sub><b>Olivier Grisel</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/commits?author=ogrisel" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ev-br"><img src="https://avatars.githubusercontent.com/u/2133832?v=4?s=100" width="100px;" alt="Evgeni Burovski"/><br /><sub><b>Evgeni Burovski</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/commits?author=ev-br" title="Code">💻</a> <a href="https://github.com/data-apis/array-api-extra/commits?author=ev-br" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.vanderplas.com/"><img src="https://avatars.githubusercontent.com/u/781659?v=4?s=100" width="100px;" alt="Jake Vanderplas"/><br /><sub><b>Jake Vanderplas</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Ajakevdp" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/KotlinIsland"><img src="https://avatars.githubusercontent.com/u/65446343?v=4?s=100" width="100px;" alt="kotlinisland"/><br /><sub><b>kotlinisland</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Akotlinisland" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/DetachHead"><img src="https://avatars.githubusercontent.com/u/57028336?v=4?s=100" width="100px;" alt="detachhead"/><br /><sub><b>detachhead</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Adetachhead" title="Reviewed Pull Requests">👀</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/NeilGirdhar"><img src="https://avatars.githubusercontent.com/u/730137?v=4?s=100" width="100px;" alt="Neil Girdhar"/><br /><sub><b>Neil Girdhar</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/commits?author=NeilGirdhar" title="Code">💻</a> <a href="https://github.com/data-apis/array-api-extra/commits?author=NeilGirdhar" title="Tests">⚠️</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lithomas1"><img src="https://avatars.githubusercontent.com/u/47963215?v=4?s=100" width="100px;" alt="Thomas Li"/><br /><sub><b>Thomas Li</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/issues?q=author%3Alithomas1" title="Bug reports">🐛</a> <a href="#tool-lithomas1" title="Tools">🔧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/pearu"><img src="https://avatars.githubusercontent.com/u/402156?v=4?s=100" width="100px;" alt="Pearu Peterson"/><br /><sub><b>Pearu Peterson</b></sub></a><br /><a href="https://github.com/data-apis/array-api-extra/pulls?q=is%3Apr+reviewed-by%3Apearu" title="Reviewed Pull Requests">👀</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

We follow the
[all-contributors](https://github.com/all-contributors/all-contributors)
specification. Contributions of any kind welcome!
