/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.recognition;

import com.aspose.barcode.barcoderecognition.BarCodeReader;
import com.aspose.barcode.barcoderecognition.BaseDecodeType;
import com.aspose.barcode.barcoderecognition.ChecksumValidation;
import com.aspose.barcode.barcoderecognition.CustomerInformationInterpretingType;
import com.aspose.barcode.barcoderecognition.DecodeType;
import com.aspose.barcode.barcoderecognition.MultyDecodeType;
import com.aspose.barcode.barcoderecognition.QualitySettings;
import com.aspose.barcode.barcoderecognition.SingleDecodeType;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.recognition.MwBarCodeResult;
import com.aspose.mw.barcode.recognition.MwDecodeTypeUtils;
import com.aspose.mw.barcode.recognition.MwQualitySettings;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import javax.imageio.ImageIO;

public class MwBarcodeReader
extends MwJavaWrapper<BarCodeReader> {
    private MwQualitySettings a;

    public MwBarcodeReader(String image, String[] rectangles, String[] decodeTypes) throws Exception {
        super(new BarCodeReader());
        try {
            if (rectangles != null) {
                this.construct(image, rectangles, decodeTypes);
            } else if (decodeTypes != null) {
                this.construct(image, decodeTypes);
            } else if (image != null) {
                this.construct(image);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    protected void construct(String image) throws IOException {
        BufferedImage bufferedImage = MwBarcodeReader.b(image);
        ((BarCodeReader)this.nativeObject).setBarCodeImage(bufferedImage);
    }

    protected void construct(String image, String[] decodeTypes) throws Exception {
        this.construct(image);
        BaseDecodeType[] baseDecodeTypeArray = MwDecodeTypeUtils.convertDecodeType(decodeTypes);
        ((BarCodeReader)this.nativeObject).setBarCodeReadType(new MultyDecodeType(baseDecodeTypeArray));
    }

    protected void construct(String image, String[] rectangles, String[] decodeTypes) throws Exception {
        BaseDecodeType[] baseDecodeTypeArray = MwDecodeTypeUtils.convertDecodeType(decodeTypes);
        ((BarCodeReader)this.nativeObject).setBarCodeReadType(new MultyDecodeType(baseDecodeTypeArray));
        BufferedImage bufferedImage = MwBarcodeReader.b(image);
        ((BarCodeReader)this.nativeObject).setBarCodeImage(bufferedImage, MwBarcodeReader.convertPhpRectangles(rectangles));
    }

    protected static Rectangle[] convertPhpRectangles(String[] phpRectangles) {
        Rectangle[] rectangleArray = new Rectangle[phpRectangles.length];
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            rectangleArray[i2] = new Rectangle(Integer.parseInt(phpRectangles[i2].split(",")[0]), Integer.parseInt(phpRectangles[i2].split(",")[1]), Integer.parseInt(phpRectangles[i2].split(",")[2]), Integer.parseInt(phpRectangles[i2].split(",")[3]));
        }
        return rectangleArray;
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.a = new MwQualitySettings(((BarCodeReader)this.getNativeObject()).getQualitySettings());
    }

    public int getTimeout() throws MwBarcodeException {
        try {
            return ((BarCodeReader)this.getNativeObject()).getTimeout();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setTimeout(int value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setTimeout(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getChecksumValidation() throws MwBarcodeException {
        try {
            return ((BarCodeReader)this.getNativeObject()).getChecksumValidation().getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setChecksumValidation(int value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setChecksumValidation(ChecksumValidation.values()[value]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public boolean getStripFNC() throws MwBarcodeException {
        try {
            return ((BarCodeReader)this.getNativeObject()).getStripFNC();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setStripFNC(boolean value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setStripFNC(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getCustomerInformationInterpretingType() throws MwBarcodeException {
        try {
            return ((BarCodeReader)this.getNativeObject()).getCustomerInformationInterpretingType().getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setCustomerInformationInterpretingType(int value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setCustomerInformationInterpretingType(CustomerInformationInterpretingType.values()[value]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void abort() throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).abort();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final MwQualitySettings getQualitySettings() throws MwBarcodeException {
        try {
            return this.a;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final void setQualitySettings(MwQualitySettings value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setQualitySettings((QualitySettings)value.getNativeObject());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public boolean getDetectEncoding() throws MwBarcodeException {
        try {
            return ((BarCodeReader)this.getNativeObject()).getDetectEncoding();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setDetectEncoding(boolean value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setDetectEncoding(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final void setBarCodeImage(String base64Image, String ... areas) throws MwBarcodeException {
        try {
            BufferedImage bufferedImage = MwBarcodeReader.b(base64Image);
            if (areas != null && areas.length > 0) {
                Rectangle[] rectangleArray = new Rectangle[areas.length];
                for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
                    rectangleArray[i2] = MwBarcodeReader.a(areas[i2]);
                }
                ((BarCodeReader)this.getNativeObject()).setBarCodeImage(bufferedImage, rectangleArray);
                return;
            }
            ((BarCodeReader)this.getNativeObject()).setBarCodeImage(bufferedImage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private static Rectangle a(String string) {
        String[] stringArray = string.split(",");
        return new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
    }

    private static BufferedImage b(String string) throws IOException {
        Object object;
        InputStream inputStream;
        if (new File(string).exists()) {
            inputStream = new FileInputStream(new File(string));
        } else {
            object = Base64.getDecoder().decode(string);
            inputStream = new ByteArrayInputStream((byte[])object);
        }
        object = ImageIO.read(inputStream);
        return object;
    }

    public void setBarCodeReadType(String ... types) throws Exception {
        try {
            ((BarCodeReader)this.getNativeObject()).setBarCodeReadType(new MultyDecodeType(MwDecodeTypeUtils.convertDecodeType(types)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public short getBarCodeDecodeType() throws MwBarcodeException {
        try {
            BaseDecodeType baseDecodeType = ((BarCodeReader)this.getNativeObject()).getBarCodeDecodeType();
            if (baseDecodeType.equals(DecodeType.ALL_SUPPORTED_TYPES)) {
                return 66;
            }
            if (baseDecodeType.equals(DecodeType.TYPES_1D)) {
                return 67;
            }
            if (baseDecodeType.equals(DecodeType.POSTAL_TYPES)) {
                return 68;
            }
            if (baseDecodeType.equals(DecodeType.MOST_COMMON_TYPES)) {
                return 69;
            }
            return ((SingleDecodeType)((BarCodeReader)this.getNativeObject()).getBarCodeDecodeType()).getTypeIndex();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public boolean containsAny(String ... decodeTypesString) throws Exception {
        BaseDecodeType[] baseDecodeTypeArray = MwDecodeTypeUtils.convertDecodeType(decodeTypesString);
        return ((BarCodeReader)this.getNativeObject()).getBarCodeDecodeType().containsAny(baseDecodeTypeArray);
    }

    public MwBarCodeResult[] getFoundBarCodes() throws MwBarcodeException {
        MwBarCodeResult[] mwBarCodeResultArray = new MwBarCodeResult[((BarCodeReader)this.getNativeObject()).readBarCodes().length];
        for (int i2 = 0; i2 < mwBarCodeResultArray.length; ++i2) {
            mwBarCodeResultArray[i2] = new MwBarCodeResult(((BarCodeReader)this.getNativeObject()).readBarCodes()[i2]);
        }
        return mwBarCodeResultArray;
    }

    public int getFoundCount() {
        return ((BarCodeReader)this.getNativeObject()).getFoundCount();
    }

    public MwBarCodeResult[] readBarCodes() throws MwBarcodeException {
        MwBarCodeResult[] mwBarCodeResultArray = new MwBarCodeResult[((BarCodeReader)this.getNativeObject()).readBarCodes().length];
        for (int i2 = 0; i2 < ((BarCodeReader)this.getNativeObject()).readBarCodes().length; ++i2) {
            mwBarCodeResultArray[i2] = new MwBarCodeResult(((BarCodeReader)this.getNativeObject()).readBarCodes()[i2]);
        }
        return mwBarCodeResultArray;
    }
}

