/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.generation;

import com.aspose.barcode.BaseEncodeType;
import com.aspose.barcode.EncodeTypes;
import com.aspose.barcode.generation.BarCodeImageFormat;
import com.aspose.barcode.generation.BarcodeGenerator;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.generation.MwBaseGenerationParameters;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;

public class MwBarcodeGenerator
extends MwJavaWrapper<BarcodeGenerator> {
    private MwBaseGenerationParameters a;

    public MwBarcodeGenerator(int encodeType, String codeText) throws MwBarcodeException {
        super(new BarcodeGenerator(MwBarcodeGenerator.a(encodeType)));
        if (codeText != null && codeText.length() > 0) {
            ((BarcodeGenerator)this.getNativeObject()).setCodeText(codeText);
        }
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.a = new MwBaseGenerationParameters(((BarcodeGenerator)this.nativeObject).getParameters());
    }

    public MwBaseGenerationParameters getParameters() throws MwBarcodeException {
        try {
            return this.a;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String generateBarCodeImage(String formatName) throws MwBarcodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (formatName == null) {
                formatName = "PNG";
            }
            ((BarcodeGenerator)this.getNativeObject()).save(byteArrayOutputStream, BarCodeImageFormat.valueOf(formatName));
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Cannot convert image to Base64", exception.getMessage());
        }
    }

    public String getCodeText() throws MwBarcodeException {
        try {
            String string = ((BarcodeGenerator)this.getNativeObject()).getCodeText();
            return string;
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setCodeText(String value) throws MwBarcodeException {
        try {
            ((BarcodeGenerator)this.getNativeObject()).setCodeText(value);
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public short getBarcodeType() throws MwBarcodeException {
        try {
            short s2 = ((BarcodeGenerator)this.getNativeObject()).getBarcodeType().getTypeIndex();
            return s2;
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setBarcodeType(int barcodeType) throws MwBarcodeException {
        try {
            BaseEncodeType baseEncodeType = MwBarcodeGenerator.a(barcodeType);
            ((BarcodeGenerator)this.getNativeObject()).setBarcodeType(baseEncodeType);
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private static String a(RenderedImage renderedImage, String string) throws MwBarcodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (string == null) {
                string = "PNG";
            }
            ImageIO.write(renderedImage, string, byteArrayOutputStream);
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Cannot convert image to Base64", exception.getMessage());
        }
    }

    private static BaseEncodeType a(int n2) throws MwBarcodeException {
        try {
            short s2 = (short)n2;
            for (BaseEncodeType baseEncodeType : EncodeTypes.getAllEncodeTypes()) {
                if (baseEncodeType.getTypeIndex() != s2) continue;
                return baseEncodeType;
            }
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Waiting for short type, but got '" + n2);
        }
        return EncodeTypes.NONE;
    }
}

