/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.recognition;

import com.aspose.barcode.barcoderecognition.BarCodeReader;
import com.aspose.barcode.barcoderecognition.BaseDecodeType;
import com.aspose.barcode.barcoderecognition.ChecksumValidation;
import com.aspose.barcode.barcoderecognition.CustomerInformationInterpretingType;
import com.aspose.barcode.barcoderecognition.DecodeType;
import com.aspose.barcode.barcoderecognition.MultyDecodeType;
import com.aspose.barcode.barcoderecognition.QualitySettings;
import com.aspose.barcode.barcoderecognition.SingleDecodeType;
import com.aspose.barcode.barcoderecognition.s;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.recognition.MwBarCodeResult;
import com.aspose.mw.barcode.recognition.MwBarcodeSettings;
import com.aspose.mw.barcode.recognition.MwDecodeTypeUtils;
import com.aspose.mw.barcode.recognition.MwQualitySettings;
import com.aspose.mw.barcode.recognition.MwRecognitionAbortedException;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class MwBarCodeReader
extends MwJavaWrapper<BarCodeReader> {
    private MwQualitySettings a;
    private MwBarcodeSettings b;

    public static void main(String[] args) throws Exception {
        String string = "iVBORw0KGgoAAAANSUhEUgAAAUUAAAA0CAYAAAAdfSqNAAAACXBIWXMAAA7DAAAOwwHHb6hkAAAL5ElEQVR4Ae1aUaQW3xe9JEnSS5IkiSRJEkkPvSY9JIkkSdJLkiSRJOmpJEkSSZIkkiRJJD0kifSQJJEkSSJJkpz/t8bdc89dzZ797eb87+/eax+++80+e++1z1lzZs2Z+e5AihYMBAPBQDBQMzBQH8VBMBAMBAPBQApRjEUQDAQDwUDGQIhiRkYcBgPBQDAQohhrIBgIBoKBjIEQxYyMOAwGgoFgoKgoDgwMJHyksS39pb674lv5lp/nwfGWbeV39XN9xrPskc7vWq/0fKzxsN+yS4/PwrP81njZz3jsZ5vjLZvz2bbyS/mHFKwAIk+C7QIlhkF0xbfyLf+wwfQMjrdsK7+rn+sznmWPdH7XeqXnY42H/ZZdenwWnuW3xst+xmM/2xxv2ZzPtpVfyh+imO1smVTvSeF4y/bWYzwr34rnfLZHOr9rPR4/2158K579ls3jYZvz2V/a5nqWzfW98ZzPdmk8xu/XDlEMUVTXCi9SNVBxePO98UpZtduLb8Wz37LVgQ06ON+K7+rnepbN9bzxnM92aTzG79cOUQxRVNcKL1I1UHF4873xSlm124tvxbPfstWBDTo434rv6ud6ls31vPGcz3ZpPMbv1w5RDFFU1wovUjVQcXjzvfFKWbXbi2/Fs9+y1YENOjjfiu/q53qWzfW88ZzPdmk8xu/XDlEMUVTXCi9SNVBxePO98UpZtduLb8Wz37LVgQ06ON+K7+rnepbN9bzxnM92aTzG79cOUQxRVNcKL1I1UHF4873xSlm124tvxbPfstWBDTo434rv6ud6ls31vPGcz3ZpPMbv124VRWuQ4W//v8zgJ/jBGpAW62F0rQc5L/w9dMbY07PjJI6ukxjnI85HiOyQZHW9Hhokr+oaqtAQ0bVo5MdFHBfx0CUW18Pouh4aJC9EMRbp6FqkcT7ifIzkTTREscdAXHRx0Y3kRRfrbXSvtxDFEMW4KfR+9AhRjMd5TQylf4gh6cm++U6XuRoPvfEMwvlsc/z/27bqs99r8/i9+Rxv4bHfa1v1GI/j2fbGcz7bpfG8+FyfbS+eN75rPc732jxey/biW/Fcz4rX/CGKGjO9fotk9nttLu3N53gLj/1e26rHeBzPtjee89kujefF5/pse/G88V3rcb7X5vFathffiud6VrzmD1HUmOn1WySz32tzaW8+x1t47PfaVj3G43i2vfGcz3ZpPC8+12fbi+eN71qP8702j9eyvfhWPNez4jV/iKLGTK/fIpn9XptLe/M53sJjv9e26jEex7Ptjed8tkvjefG5PttePG9813qc77V5vJbtxbfiuZ4Vr/lDFDVmev0Wyez32lzam8/xFh77vbZVj/E4nm1vPOezXRrPi8/12fbieeO71uN8r83jtWwvvhXP9ax4zR+iqDHT67dIZr/X5tLefI638Njvta16jMfxbHvjOZ/t0nhefK7PthfPG9+1Hud7bR6vZXvxrXiuZ8Vr/hBFjZlev0Uy+702l/bmc7yFx36vbdVjPI5n2xvP+WyXxvPic322vXje+K71ON9r83gt24tvxXM9K17zhyhqzPT6LZLZ77W5tDef4y089nttqx7jcTzb3njOZ7s0nhef67PtxfPGd63H+V6bx2vZXnwrnutZ8Zq/VRS1pOgPBoKBYGC8MhCiOF7PbMwrGAgG/omBEMV/oi2SgoFgYLwyEKI4Xs9szCsYCAb+iYEQxX+iLZKCgWBgvDIQotjHmf3y5UvavXt3Y+TDhw8TPtK+ffuWjh49mrZt25bu3r0r3dX3p0+f0qFDhyrfgwcPhvlQQ/KuX78+zAejaQwfPnxIhw8frvDOnTuX/vz5U+e1+SSoCRM+nhP6fv/+nc6cOZO2b9+eTp8+PazWkydP0oULF+rPvXv3kNKao3Hx5s2bGifHRP22MbTNd8eOHanp8/3792qcTT7M0ZpDFdD708QXfDifly5dkrD6G/Uwl7w9fvw4nT17tu7S1gNimsbbhFmDxYGLgRDFPujasGFDmjp16l+Rz549SzNmzKguYnGuXLkyHTx4MN26dSstWbIkXblypXL9+PEjzZ49O506daryLVq0KN24cUPS0uLFiyuBu337dgLGyZMnax8OeAwQ35kzZ1ZxyFm/fn3aunVrldPmy0EZE76mOaEf+Ljw7ty5U41l165d6K7apk2b0tq1axP68JGLW8tp4wICKzj4XrVqVcUbRETDs+aLf9W4ePFiunz58rDPr1+/qvHDf/78+WE+uWlpNQenrvL17t27tHDhwuoc5Tcr5KGe1BYcjA21pGnrAQIs88Ca3LdvX21zHcGKbx8DIYoGX7jTQ2xYFHHhz507N61YsaIWRdztsZil4QKHMKJBbLCrk4aFvXnz5srErmnKlCniSjdv3qxERjqaxoAYiJG0r1+/pgkTJlRmm0/imzCb5oT458+fJ4i4NIx3z549YlYX/+vXr2sbB205bVzkINjJzZkzJ4HHNjxrvk0ilNeBX3aNeX9bTcRpfMGHc33gwIG0evXqdPXqVXTVrWk8uSha60GApk+fXt2kxI7vMgyEKLbw+Pbt27R06dL0+fPnv0QRd2zseLB7wmMeGhb2li1bakTcuSFUfAeHgOFikUc0+OfNm1ftHHFxQizxmI3WNoa6UO8Agjxr1qy8qz5mn4bZNCeAYJeFed6/fz/t3Llz2CMhdnCTJk1KJ06cqET6yJEj6efPn6059cB6B8xF7sMuCLtFtLYx5Dk45vk2iVCeo4miVVPjC9gQc4gq1gR2u3mTetgtyge1ZKfYth5ynBDFnI1yxyGKLVziMRa7GggV7xQlLRdFvNeDnbeJEycOe1TCrmbZsmXVY9XLly/rUAgkaixfvrzyQbjQ+hkDdhYQ1WvXrtV4ctDkszDzOQEH71MhuHhPil0PdsciVhAgjBuPn3iMx2P0mjVrWnNkbBoX8H/8+DFNnjw5YfxobWOoAgb/NM0XIgThzj/Y5UuDH3PIP/K+VZu35OKb+cLNQ54YcNMA7qtXr+qUpvFgnYgoIlBbDzVI7yBEMWej3HGIosIlXpLjg9avKEIY8ENE3rBT5Jfq8OOdI94xouH91fz586tdE2y8t8NF288Y8NiKWHmPh3xpTb5+MPkix6MyhFQads7avLB7hg8Y/ebkXEgNjDPfdfczhqb5Aq9pZ5a/04MfIii7NvH1UxP4zBd2+hBFeTeKG9bevXsRWjXUkxrSlz8+a+tBYuU7RFGYKPsdoqjwuWDBgmE7Byxk3PF5MecXBH413rhxY42ICw27HbT379+np0+f1j4cABOPmseOHftLTJEHocx3LzyGR48eVTs47NC4ab5+5pXPCbi4YPGjTN6ws4EAYl54TMwbdmTHjx9vzdG4EBzspiGW0trGgBhtvvA1iRD6pcHf9E7Rqin5OV94HYD5Y0eNnTs++HFt2rRp9dppGk8uitp64DGGKMoZKPsdotgHn/3uFOXdozzy4Rdk+UUYd38IEkQQDUImj3D4Fxb8kCE+CAYWfP4ukseAXzcRg8dXbm2+PJYxxZdf5OiD8EGc8UiLJuOVY4i3jB2/qMNuy2njApjYWUN08x12G5413yYRQh1pmii21ZRcfOd84bEX74u54fzKu+em8eSiKPwKp03rAfghisxyGTtEsQ8eNfFAan5BwMbixkt2XBj4lwwRSPjwayQEA+/cIIj4VVUa/o0HeevWraseqyEceeMx4HEMFxd/kNPma8MUH88J/djxyPjwOJjv9Pbv31/NB3PG/F68eFFBteW0cQFesLPipuFZ82WOxAYeGmzw29S0mnlszhf+2wBrgBtukHhfjIZ6/MSRiyJirPWAmBBFsFC+hSiW57Ta4eHRsqnhYtB82Blqviaske5rGx92dU1jb8tp40KbWxueltO1/7+oiTH/V3W78jXW80MUx/oZjPEHA8FAUQZCFIvSGWDBQDAw1hkIURzrZzDGHwwEA0UZCFEsSmeABQPBwFhnIERxrJ/BGH8wEAwUZSBEsSidARYMBANjnYEQxbF+BmP8wUAwUJSBEMWidAZYMBAMjHUGQhTH+hmM8QcDwUBRBv4HGzCfzRud3w8AAAAASUVORK5CYII=";
        try {
            MwBarCodeReader mwBarCodeReader = new MwBarCodeReader(string, null, new String[]{"66"});
        }
        catch (Exception exception) {
            System.out.println();
        }
    }

    public MwBarCodeReader() throws MwBarcodeException {
        this(new BarCodeReader());
    }

    public MwBarCodeReader(String image, String[] rectangles, String[] decodeTypes) throws Exception {
        this(new BarCodeReader());
        try {
            if (rectangles != null) {
                this.construct(image, rectangles, decodeTypes);
            } else if (decodeTypes != null) {
                this.construct(image, decodeTypes);
            } else if (image != null) {
                this.construct(image);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private MwBarCodeReader(BarCodeReader reader) throws MwBarcodeException {
        super(reader);
    }

    protected void construct(String image) throws IOException {
        BufferedImage bufferedImage = MwBarCodeReader.b(image);
        ((BarCodeReader)this.nativeObject).setBarCodeImage(bufferedImage);
    }

    protected void construct(String image, String[] decodeTypes) throws Exception {
        this.construct(image);
        BaseDecodeType[] baseDecodeTypeArray = MwDecodeTypeUtils.convertDecodeType(decodeTypes);
        ((BarCodeReader)this.nativeObject).setBarCodeReadType(new MultyDecodeType(baseDecodeTypeArray));
    }

    protected void construct(String image, String[] rectangles, String[] decodeTypes) throws Exception {
        BaseDecodeType[] baseDecodeTypeArray = MwDecodeTypeUtils.convertDecodeType(decodeTypes);
        ((BarCodeReader)this.nativeObject).setBarCodeReadType(new MultyDecodeType(baseDecodeTypeArray));
        BufferedImage bufferedImage = MwBarCodeReader.b(image);
        ((BarCodeReader)this.nativeObject).setBarCodeImage(bufferedImage, MwBarCodeReader.convertPhpRectangles(rectangles));
    }

    protected static Rectangle[] convertPhpRectangles(String[] phpRectangles) {
        Rectangle[] rectangleArray = new Rectangle[phpRectangles.length];
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            rectangleArray[i2] = new Rectangle(Integer.parseInt(phpRectangles[i2].split(",")[0]), Integer.parseInt(phpRectangles[i2].split(",")[1]), Integer.parseInt(phpRectangles[i2].split(",")[2]), Integer.parseInt(phpRectangles[i2].split(",")[3]));
        }
        return rectangleArray;
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.a = new MwQualitySettings(((BarCodeReader)this.getNativeObject()).getQualitySettings());
        this.b = new MwBarcodeSettings(((BarCodeReader)this.getNativeObject()).getBarcodeSettings());
    }

    public int getTimeout() throws MwBarcodeException {
        try {
            return ((BarCodeReader)this.getNativeObject()).getTimeout();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setTimeout(int value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setTimeout(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getChecksumValidation() throws MwBarcodeException {
        try {
            return ((BarCodeReader)this.getNativeObject()).getChecksumValidation().getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setChecksumValidation(int value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setChecksumValidation(ChecksumValidation.values()[value]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public boolean getStripFNC() throws MwBarcodeException {
        try {
            return ((BarCodeReader)this.getNativeObject()).getStripFNC();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setStripFNC(boolean value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setStripFNC(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getCustomerInformationInterpretingType() throws MwBarcodeException {
        try {
            return ((BarCodeReader)this.getNativeObject()).getCustomerInformationInterpretingType().getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setCustomerInformationInterpretingType(int value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setCustomerInformationInterpretingType(CustomerInformationInterpretingType.values()[value]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void abort() throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).abort();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final MwQualitySettings getQualitySettings() throws MwBarcodeException {
        try {
            return this.a;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final void setQualitySettings(MwQualitySettings value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setQualitySettings((QualitySettings)value.getNativeObject());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public MwBarcodeSettings getBarcodeSettings() {
        return this.b;
    }

    public boolean getDetectEncoding() throws MwBarcodeException {
        try {
            return ((BarCodeReader)this.getNativeObject()).getDetectEncoding();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setDetectEncoding(boolean value) throws MwBarcodeException {
        try {
            ((BarCodeReader)this.getNativeObject()).setDetectEncoding(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final void setBarCodeImage(String base64Image, String ... areas) throws MwBarcodeException {
        try {
            BufferedImage bufferedImage = MwBarCodeReader.b(base64Image);
            if (areas != null && areas.length > 0) {
                Rectangle[] rectangleArray = new Rectangle[areas.length];
                for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
                    rectangleArray[i2] = MwBarCodeReader.a(areas[i2]);
                }
                ((BarCodeReader)this.getNativeObject()).setBarCodeImage(bufferedImage, rectangleArray);
                return;
            }
            ((BarCodeReader)this.getNativeObject()).setBarCodeImage(bufferedImage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private static Rectangle a(String string) {
        String[] stringArray = string.split(",");
        return new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
    }

    private static BufferedImage b(String string) throws IOException {
        Object object;
        InputStream inputStream;
        if (new File(string).exists()) {
            inputStream = new FileInputStream(new File(string));
        } else {
            object = Base64.getDecoder().decode(string);
            inputStream = new ByteArrayInputStream((byte[])object);
        }
        object = ImageIO.read(inputStream);
        return object;
    }

    public void setBarCodeReadType(String ... types) throws Exception {
        try {
            ((BarCodeReader)this.getNativeObject()).setBarCodeReadType(new MultyDecodeType(MwDecodeTypeUtils.convertDecodeType(types)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public short getBarCodeDecodeType() throws MwBarcodeException {
        try {
            BaseDecodeType baseDecodeType = ((BarCodeReader)this.getNativeObject()).getBarCodeDecodeType();
            if (baseDecodeType.equals(DecodeType.ALL_SUPPORTED_TYPES)) {
                return 71;
            }
            if (baseDecodeType.equals(DecodeType.TYPES_1D)) {
                return 67;
            }
            if (baseDecodeType.equals(DecodeType.POSTAL_TYPES)) {
                return 68;
            }
            if (baseDecodeType.equals(DecodeType.MOST_COMMON_TYPES)) {
                return 69;
            }
            return ((SingleDecodeType)((BarCodeReader)this.getNativeObject()).getBarCodeDecodeType()).getTypeIndex();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public boolean containsAny(String ... decodeTypesString) throws Exception {
        BaseDecodeType[] baseDecodeTypeArray = MwDecodeTypeUtils.convertDecodeType(decodeTypesString);
        return ((BarCodeReader)this.getNativeObject()).getBarCodeDecodeType().containsAny(baseDecodeTypeArray);
    }

    public MwBarCodeResult[] getFoundBarCodes() throws MwBarcodeException {
        MwBarCodeResult[] mwBarCodeResultArray = new MwBarCodeResult[((BarCodeReader)this.getNativeObject()).readBarCodes().length];
        for (int i2 = 0; i2 < mwBarCodeResultArray.length; ++i2) {
            mwBarCodeResultArray[i2] = new MwBarCodeResult(((BarCodeReader)this.getNativeObject()).readBarCodes()[i2]);
        }
        return mwBarCodeResultArray;
    }

    public int getFoundCount() {
        return ((BarCodeReader)this.getNativeObject()).getFoundCount();
    }

    public MwBarCodeResult[] readBarCodes() throws MwBarcodeException {
        try {
            MwBarCodeResult[] mwBarCodeResultArray = new MwBarCodeResult[((BarCodeReader)this.getNativeObject()).readBarCodes().length];
            for (int i2 = 0; i2 < ((BarCodeReader)this.getNativeObject()).readBarCodes().length; ++i2) {
                mwBarCodeResultArray[i2] = new MwBarCodeResult(((BarCodeReader)this.getNativeObject()).readBarCodes()[i2]);
            }
            return mwBarCodeResultArray;
        }
        catch (s s2) {
            System.out.println("!!!!!!!!!!!!!!!");
            System.out.println(s2.getMessage());
            throw new MwRecognitionAbortedException(s2);
        }
    }

    public String exportToXml() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (((BarCodeReader)this.getNativeObject()).exportToXml(byteArrayOutputStream)) {
            return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()))).lines().collect(Collectors.joining("\n"));
        }
        throw new Exception();
    }

    public static MwBarCodeReader importFromXml(String xmlData) throws Exception {
        return new MwBarCodeReader(BarCodeReader.importFromXml(new ByteArrayInputStream(xmlData.getBytes(StandardCharsets.UTF_8))));
    }
}

