/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.recognition;

import com.aspose.barcode.barcoderecognition.ab;
import com.aspose.barcode.barcoderecognition.ac;
import com.aspose.barcode.barcoderecognition.d;
import com.aspose.barcode.barcoderecognition.l;
import com.aspose.barcode.barcoderecognition.q;
import com.aspose.barcode.barcoderecognition.t;
import com.aspose.barcode.barcoderecognition.z;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.recognition.MwBarCodeResult;
import com.aspose.mw.barcode.recognition.MwBarcodeSettings;
import com.aspose.mw.barcode.recognition.MwDecodeTypeUtils;
import com.aspose.mw.barcode.recognition.MwQualitySettings;
import com.aspose.mw.barcode.recognition.MwRecognitionAbortedException;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class MwBarCodeReader
extends MwJavaWrapper<d> {
    private MwQualitySettings a;
    private MwBarcodeSettings b;

    public MwBarCodeReader() throws MwBarcodeException {
        this(new d());
    }

    public MwBarCodeReader(String image, String[] rectangles, String[] decodeTypes) throws Exception {
        this(new d());
        try {
            if (image != null && rectangles != null) {
                this.construct(image, rectangles, decodeTypes);
            } else if (image != null && decodeTypes != null) {
                this.construct(image, decodeTypes);
            } else if (image != null) {
                this.construct(image);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private MwBarCodeReader(d reader) throws MwBarcodeException {
        super(reader);
    }

    protected void construct(String image) throws IOException {
        BufferedImage bufferedImage = MwBarCodeReader.b(image);
        ((d)this.nativeObject).a(bufferedImage);
    }

    protected void construct(String image, String[] decodeTypes) throws Exception {
        this.construct(image);
        l[] lArray = MwDecodeTypeUtils.convertDecodeType(decodeTypes);
        ((d)this.nativeObject).a(new t(lArray));
    }

    protected void construct(String image, String[] rectangles, String[] decodeTypes) throws Exception {
        l[] lArray = MwDecodeTypeUtils.convertDecodeType(decodeTypes);
        ((d)this.nativeObject).a(new t(lArray));
        BufferedImage bufferedImage = MwBarCodeReader.b(image);
        ((d)this.nativeObject).a(bufferedImage, MwBarCodeReader.convertPhpRectangles(rectangles));
    }

    protected static Rectangle[] convertPhpRectangles(String[] phpRectangles) {
        Rectangle[] rectangleArray = new Rectangle[phpRectangles.length];
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            rectangleArray[i2] = new Rectangle(Integer.parseInt(phpRectangles[i2].split(",")[0]), Integer.parseInt(phpRectangles[i2].split(",")[1]), Integer.parseInt(phpRectangles[i2].split(",")[2]), Integer.parseInt(phpRectangles[i2].split(",")[3]));
        }
        return rectangleArray;
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.a = new MwQualitySettings(((d)this.getNativeObject()).g());
        this.b = new MwBarcodeSettings(((d)this.getNativeObject()).h());
    }

    public int getTimeout() throws MwBarcodeException {
        try {
            return ((d)this.getNativeObject()).b();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setTimeout(int value) throws MwBarcodeException {
        try {
            ((d)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void abort() throws MwBarcodeException {
        try {
            ((d)this.getNativeObject()).c();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final MwQualitySettings getQualitySettings() throws MwBarcodeException {
        try {
            return this.a;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final void setQualitySettings(MwQualitySettings value) throws MwBarcodeException {
        try {
            ((d)this.getNativeObject()).a((z)value.getNativeObject());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public MwBarcodeSettings getBarcodeSettings() {
        return this.b;
    }

    public final void setBarCodeImage(String base64Image, String ... areas) throws MwBarcodeException {
        try {
            BufferedImage bufferedImage = MwBarCodeReader.b(base64Image);
            if (areas != null && areas.length > 0) {
                Rectangle[] rectangleArray = new Rectangle[areas.length];
                for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
                    rectangleArray[i2] = MwBarCodeReader.a(areas[i2]);
                }
                ((d)this.getNativeObject()).a(bufferedImage, rectangleArray);
                return;
            }
            ((d)this.getNativeObject()).a(bufferedImage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private static Rectangle a(String string) {
        String[] stringArray = string.split(",");
        return new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
    }

    private static BufferedImage b(String string) throws IOException {
        Object object;
        InputStream inputStream;
        if (new File(string).exists()) {
            inputStream = new FileInputStream(new File(string));
        } else {
            object = Base64.getDecoder().decode(string);
            inputStream = new ByteArrayInputStream((byte[])object);
        }
        object = ImageIO.read(inputStream);
        return object;
    }

    public void setBarCodeReadType(String ... types) throws Exception {
        try {
            ((d)this.getNativeObject()).a(new t(MwDecodeTypeUtils.convertDecodeType(types)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public short getBarCodeDecodeType() throws MwBarcodeException {
        try {
            l l2 = ((d)this.getNativeObject()).j();
            if (l2.equals(q.aB)) {
                return 99;
            }
            if (l2.equals(q.aC)) {
                return 97;
            }
            if (l2.equals(q.aD)) {
                return 98;
            }
            if (l2.equals(q.aE)) {
                return 95;
            }
            if (l2.equals(q.aF)) {
                return 96;
            }
            return ((ac)((d)this.getNativeObject()).j()).a();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public boolean containsAny(String ... decodeTypesString) throws Exception {
        l[] lArray = MwDecodeTypeUtils.convertDecodeType(decodeTypesString);
        return ((d)this.getNativeObject()).j().a(lArray);
    }

    public MwBarCodeResult[] getFoundBarCodes() throws MwBarcodeException {
        MwBarCodeResult[] mwBarCodeResultArray = new MwBarCodeResult[((d)this.getNativeObject()).f().length];
        for (int i2 = 0; i2 < mwBarCodeResultArray.length; ++i2) {
            mwBarCodeResultArray[i2] = new MwBarCodeResult(((d)this.getNativeObject()).f()[i2]);
        }
        return mwBarCodeResultArray;
    }

    public int getFoundCount() {
        return ((d)this.getNativeObject()).e();
    }

    public MwBarCodeResult[] readBarCodes() throws MwBarcodeException {
        try {
            MwBarCodeResult[] mwBarCodeResultArray = new MwBarCodeResult[((d)this.getNativeObject()).f().length];
            for (int i2 = 0; i2 < ((d)this.getNativeObject()).f().length; ++i2) {
                mwBarCodeResultArray[i2] = new MwBarCodeResult(((d)this.getNativeObject()).f()[i2]);
            }
            return mwBarCodeResultArray;
        }
        catch (ab ab2) {
            System.out.println(ab2.getMessage());
            throw new MwRecognitionAbortedException(ab2);
        }
    }

    public String exportToXml() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (((d)this.getNativeObject()).a(byteArrayOutputStream)) {
            return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()))).lines().collect(Collectors.joining("\n"));
        }
        throw new Exception();
    }

    public static MwBarCodeReader importFromXml(String xmlData) throws Exception {
        return new MwBarCodeReader(d.b(new ByteArrayInputStream(xmlData.getBytes(StandardCharsets.UTF_8))));
    }
}

