/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.generation;

import com.aspose.barcode.generation.BarCodeImageFormat;
import com.aspose.barcode.generation.ac;
import com.aspose.barcode.generation.c;
import com.aspose.barcode.generation.e;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.generation.MwBaseGenerationParameters;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;

public class MwBarcodeGenerator
extends MwJavaWrapper<c> {
    private MwBaseGenerationParameters a;

    public MwBarcodeGenerator(int encodeType, String codeText) throws MwBarcodeException {
        super(new c(MwBarcodeGenerator.findEncodeTypeByIndex(encodeType)));
        if (codeText != null) {
            ((c)this.getNativeObject()).a(codeText);
        }
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.a = new MwBaseGenerationParameters(((c)this.nativeObject).a());
    }

    public MwBaseGenerationParameters getParameters() throws MwBarcodeException {
        try {
            return this.a;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String generateBarCodeImage(int format) throws MwBarcodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (format < 0 || format > 7) {
                format = BarCodeImageFormat.PNG.getValue();
            }
            ((c)this.getNativeObject()).a(byteArrayOutputStream, BarCodeImageFormat.values()[format]);
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Cannot convert image to Base64", exception.getMessage());
        }
    }

    public String getCodeText() throws MwBarcodeException {
        try {
            String string = ((c)this.getNativeObject()).c();
            return string;
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setCodeText(String value) throws MwBarcodeException {
        try {
            ((c)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public short getBarcodeType() throws MwBarcodeException {
        try {
            return ((c)this.getNativeObject()).b().a();
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setBarcodeType(int barcodeType) throws MwBarcodeException {
        try {
            e e2 = MwBarcodeGenerator.findEncodeTypeByIndex(barcodeType);
            ((c)this.getNativeObject()).a(e2);
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private static String a(RenderedImage renderedImage, String string) throws MwBarcodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (string == null) {
                string = "PNG";
            }
            ImageIO.write(renderedImage, string, byteArrayOutputStream);
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Cannot convert image to Base64", exception.getMessage());
        }
    }

    public static e findEncodeTypeByIndex(int typeIndexString) throws MwBarcodeException {
        try {
            short s2 = (short)typeIndexString;
            for (e e2 : ac.a()) {
                if (e2.a() != s2) continue;
                return e2;
            }
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Waiting for short type, but got '" + typeIndexString);
        }
        return ac.a;
    }
}

