/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.recognition;

import com.aspose.barcode.barcoderecognition.aa;
import com.aspose.barcode.barcoderecognition.ag;
import com.aspose.barcode.barcoderecognition.ai;
import com.aspose.barcode.barcoderecognition.ak;
import com.aspose.barcode.barcoderecognition.e;
import com.aspose.barcode.barcoderecognition.n;
import com.aspose.barcode.barcoderecognition.u;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.recognition.MwBarCodeResult;
import com.aspose.mw.barcode.recognition.MwBarcodeSettings;
import com.aspose.mw.barcode.recognition.MwDecodeTypeUtils;
import com.aspose.mw.barcode.recognition.MwQualitySettings;
import com.aspose.mw.barcode.recognition.MwRecognitionAbortedException;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class MwBarCodeReader
extends MwJavaWrapper<e> {
    private MwQualitySettings a;
    private MwBarcodeSettings b;

    public MwBarCodeReader() throws MwBarcodeException {
        this(new e());
    }

    public MwBarCodeReader(String image, String[] rectangles, String[] decodeTypes) throws Exception {
        this(new e());
        try {
            if (image != null && rectangles != null) {
                this.construct(image, rectangles, decodeTypes);
            } else if (image != null && decodeTypes != null) {
                this.construct(image, decodeTypes);
            } else if (image != null) {
                this.construct(image);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private MwBarCodeReader(e reader) throws MwBarcodeException {
        super(reader);
    }

    protected void construct(String image) throws IOException {
        BufferedImage bufferedImage = MwBarCodeReader.b(image);
        ((e)this.nativeObject).a(bufferedImage);
    }

    protected void construct(String image, String[] decodeTypes) throws Exception {
        this.construct(image);
        n[] nArray = MwDecodeTypeUtils.convertDecodeType(decodeTypes);
        ((e)this.nativeObject).a(new aa(nArray));
    }

    protected void construct(String image, String[] rectangles, String[] decodeTypes) throws Exception {
        n[] nArray = MwDecodeTypeUtils.convertDecodeType(decodeTypes);
        ((e)this.nativeObject).a(new aa(nArray));
        BufferedImage bufferedImage = MwBarCodeReader.b(image);
        ((e)this.nativeObject).a(bufferedImage, MwBarCodeReader.convertPhpRectangles(rectangles));
    }

    protected static Rectangle[] convertPhpRectangles(String[] phpRectangles) {
        Rectangle[] rectangleArray = new Rectangle[phpRectangles.length];
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            rectangleArray[i2] = new Rectangle(Integer.parseInt(phpRectangles[i2].split(",")[0]), Integer.parseInt(phpRectangles[i2].split(",")[1]), Integer.parseInt(phpRectangles[i2].split(",")[2]), Integer.parseInt(phpRectangles[i2].split(",")[3]));
        }
        return rectangleArray;
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.a = new MwQualitySettings(((e)this.getNativeObject()).g());
        this.b = new MwBarcodeSettings(((e)this.getNativeObject()).h());
    }

    public int getTimeout() throws MwBarcodeException {
        try {
            return ((e)this.getNativeObject()).b();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setTimeout(int value) throws MwBarcodeException {
        try {
            ((e)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void abort() throws MwBarcodeException {
        try {
            ((e)this.getNativeObject()).c();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final MwQualitySettings getQualitySettings() throws MwBarcodeException {
        try {
            return this.a;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final void setQualitySettings(MwQualitySettings value) throws MwBarcodeException {
        try {
            ((e)this.getNativeObject()).a((ag)value.getNativeObject());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public MwBarcodeSettings getBarcodeSettings() {
        return this.b;
    }

    public final void setBarCodeImage(String base64Image, String ... areas) throws MwBarcodeException {
        try {
            BufferedImage bufferedImage = MwBarCodeReader.b(base64Image);
            if (areas != null && areas.length > 0) {
                Rectangle[] rectangleArray = new Rectangle[areas.length];
                for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
                    rectangleArray[i2] = MwBarCodeReader.a(areas[i2]);
                }
                ((e)this.getNativeObject()).a(bufferedImage, rectangleArray);
                return;
            }
            ((e)this.getNativeObject()).a(bufferedImage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private static Rectangle a(String string) {
        String[] stringArray = string.split(",");
        return new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
    }

    private static BufferedImage b(String string) throws IOException {
        Object object;
        InputStream inputStream;
        if (new File(string).exists()) {
            inputStream = new FileInputStream(new File(string));
        } else {
            object = Base64.getDecoder().decode(string);
            inputStream = new ByteArrayInputStream((byte[])object);
        }
        object = ImageIO.read(inputStream);
        return object;
    }

    public void setBarCodeReadType(String ... types) throws Exception {
        try {
            ((e)this.getNativeObject()).a(new aa(MwDecodeTypeUtils.convertDecodeType(types)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public short getBarCodeDecodeType() throws MwBarcodeException {
        try {
            n n2 = ((e)this.getNativeObject()).j();
            if (n2.equals(u.aH)) {
                return 99;
            }
            if (n2.equals(u.aI)) {
                return 97;
            }
            if (n2.equals(u.aJ)) {
                return 98;
            }
            if (n2.equals(u.aK)) {
                return 95;
            }
            if (n2.equals(u.aL)) {
                return 96;
            }
            return ((ak)((e)this.getNativeObject()).j()).a();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public boolean containsAny(String ... decodeTypesString) throws Exception {
        n[] nArray = MwDecodeTypeUtils.convertDecodeType(decodeTypesString);
        return ((e)this.getNativeObject()).j().a(nArray);
    }

    public MwBarCodeResult[] getFoundBarCodes() throws MwBarcodeException {
        MwBarCodeResult[] mwBarCodeResultArray = new MwBarCodeResult[((e)this.getNativeObject()).f().length];
        for (int i2 = 0; i2 < mwBarCodeResultArray.length; ++i2) {
            mwBarCodeResultArray[i2] = new MwBarCodeResult(((e)this.getNativeObject()).f()[i2]);
        }
        return mwBarCodeResultArray;
    }

    public int getFoundCount() {
        return ((e)this.getNativeObject()).e();
    }

    public MwBarCodeResult[] readBarCodes() throws MwBarcodeException {
        try {
            MwBarCodeResult[] mwBarCodeResultArray = new MwBarCodeResult[((e)this.getNativeObject()).f().length];
            for (int i2 = 0; i2 < ((e)this.getNativeObject()).f().length; ++i2) {
                mwBarCodeResultArray[i2] = new MwBarCodeResult(((e)this.getNativeObject()).f()[i2]);
            }
            return mwBarCodeResultArray;
        }
        catch (ai ai2) {
            System.out.println(ai2.getMessage());
            throw new MwRecognitionAbortedException(ai2);
        }
    }

    public String exportToXml() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (((e)this.getNativeObject()).a(byteArrayOutputStream)) {
            return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()))).lines().collect(Collectors.joining("\n"));
        }
        throw new Exception();
    }

    public static MwBarCodeReader importFromXml(String xmlData) throws Exception {
        return new MwBarCodeReader(e.b(new ByteArrayInputStream(xmlData.getBytes(StandardCharsets.UTF_8))));
    }
}

